/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content.titlelist;

import com.ericsson.cms.devices.content.ContentMessageDispatcher;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetList;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetListMetadata;
import com.tandbergtv.cms.contentmgmt.titlelist.service.IAssetListManager;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public abstract class TitleListMessageDispatcher
extends ContentMessageDispatcher {
    private static final String ASSETLIST_MANAGER_SERVICE = "cms/AssetListManager/local";

    public TitleListMessageDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    protected IAssetListManager getAssetListManagerService() {
        IAssetListManager service = null;
        try {
            service = (IAssetListManager)InitialContext.doLookup(ASSETLIST_MANAGER_SERVICE);
        }
        catch (NamingException e) {
            String msg = "Failed to lookup the Asset List Manager service(cms/AssetListManager/local).";
            throw new RuntimeException(msg);
        }
        return service;
    }

    protected AssetList getAssetList(long id) {
        AssetList assetList = null;
        try {
            assetList = this.getAssetListManagerService().get(id);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("The title list[" + id + "] does not exist.", e);
        }
        if (assetList == null) {
            throw new RuntimeException("The title list[" + id + "] does not exist.");
        }
        return assetList;
    }

    protected String getMetadataValue(AssetListMetadata metadata) {
        String stringValue = null;
        if (metadata != null && metadata.getDataType() != null) {
            switch (metadata.getDataType()) {
                case DATE: {
                    Date dateValue = metadata.getDateValue();
                    if (dateValue == null) break;
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                    stringValue = format.format(dateValue);
                    break;
                }
                case IMAGE: {
                    break;
                }
                default: {
                    Object value = metadata.getTypedValue();
                    stringValue = value != null ? value.toString() : null;
                }
            }
        }
        return stringValue != null ? stringValue : "";
    }
}

