/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ejb;

import com.ericsson.ejb.Contract;
import com.ericsson.ejb.CopyHolderContacts;
import com.ericsson.ejb.CopyHolderDocuments;
import com.ericsson.ejb.CustomLicFieldValue;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="CM_COPYRIGHT_HOLDER", uniqueConstraints={@UniqueConstraint(columnNames={"NAME"})})
public class CopyrightHolder
implements Serializable {
    private static final long serialVersionUID = 2577823663138731177L;
    private Long idCopyrightHolder;
    private String name;
    private String address;
    private String affiliation;
    private Set<CopyHolderDocuments> copyHolderDocuments = new HashSet<CopyHolderDocuments>(0);
    private Set<CopyHolderContacts> copyHolderContacts = new HashSet<CopyHolderContacts>(0);
    private Set<Contract> contracts = new HashSet<Contract>(0);
    private Set<CustomLicFieldValue> copyHolderCustomLicFieldValues = new HashSet<CustomLicFieldValue>(0);
    private String externalId;

    public CopyrightHolder() {
    }

    public CopyrightHolder(String name, String address, String affiliation) {
        this.name = name;
        this.address = address;
        this.affiliation = affiliation;
    }

    public CopyrightHolder(String name, String address, String affiliation, Set<CopyHolderDocuments> copyHolderDocuments, Set<CopyHolderContacts> copyHolderContacts, Set<Contract> contracts, Set<CustomLicFieldValue> customLicFieldValues) {
        this.name = name;
        this.address = address;
        this.affiliation = affiliation;
        this.copyHolderDocuments = copyHolderDocuments;
        this.copyHolderContacts = copyHolderContacts;
        this.contracts = contracts;
        this.copyHolderCustomLicFieldValues = customLicFieldValues;
    }

    @Id
    @Column(name="ID_COPYRIGHTHOLDER", unique=true, nullable=false, precision=22, scale=0)
    @SequenceGenerator(name="CopyHolderID Sequence Generator", sequenceName="CM_COPYRIGHT_HOLDER_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="CopyHolderID Sequence Generator")
    public Long getIdCopyrightHolder() {
        return this.idCopyrightHolder;
    }

    public void setIdCopyrightHolder(Long idCopyrightholder) {
        this.idCopyrightHolder = idCopyrightholder;
    }

    @Column(name="NAME", unique=true, nullable=false, length=50)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="ADDRESS", nullable=false, length=300)
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @Column(name="AFFILIATION", nullable=false, length=50)
    public String getAffiliation() {
        return this.affiliation;
    }

    public void setAffiliation(String affiliation) {
        this.affiliation = affiliation;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="copyrightHolder", cascade={CascadeType.ALL})
    public Set<CopyHolderDocuments> getCopyHolderDocuments() {
        return this.copyHolderDocuments;
    }

    public void setCopyHolderDocuments(Set<CopyHolderDocuments> copyHolderDocuments) {
        this.copyHolderDocuments = copyHolderDocuments;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="copyrightHolder", cascade={CascadeType.ALL})
    public Set<CopyHolderContacts> getCopyHolderContacts() {
        return this.copyHolderContacts;
    }

    public void setCopyHolderContacts(Set<CopyHolderContacts> copyHolderContacts) {
        this.copyHolderContacts = copyHolderContacts;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="copyrightHolder", cascade={CascadeType.REMOVE})
    public Set<Contract> getContracts() {
        return this.contracts;
    }

    public void setContracts(Set<Contract> contracts) {
        this.contracts = contracts;
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="ID_COPYRIGHTHOLDER")
    public Set<CustomLicFieldValue> getCopyHolderCustomLicFieldValues() {
        return this.copyHolderCustomLicFieldValues;
    }

    public void setCopyHolderCustomLicFieldValues(Set<CustomLicFieldValue> customLicFieldValues) {
        this.copyHolderCustomLicFieldValues = customLicFieldValues;
    }

    @Column(name="EXTERNAL_ID", unique=true, nullable=true, length=100)
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = StringUtils.isEmpty((String)externalId) ? null : externalId;
    }
}

