/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ejb;

import com.ericsson.ejb.Contract;
import com.ericsson.ejb.CustomLicFieldValue;
import com.ericsson.ejb.DealContacts;
import com.ericsson.ejb.DealDocuments;
import com.ericsson.ejb.DealType;
import com.ericsson.ejb.License;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Type;

@Entity
@Table(name="CM_DEAL", uniqueConstraints={@UniqueConstraint(columnNames={"NAME"})})
public class Deal
implements Serializable {
    private static final long serialVersionUID = -6172555953512889274L;
    private Long idDeal;
    private Contract contract;
    private DealType dealType;
    private String name;
    private Boolean active;
    private Date creationDate;
    private Date effectiveDate;
    private Date expiryDate;
    private Long licenseExpiryReminder;
    private Set<DealContacts> dealContacts = new HashSet<DealContacts>(0);
    private Set<CustomLicFieldValue> dealCustomLicFieldValues = new HashSet<CustomLicFieldValue>(0);
    private Set<License> licenses = new HashSet<License>(0);
    private Set<DealDocuments> dealDocuments = new HashSet<DealDocuments>(0);
    private String externalId;

    public Deal() {
    }

    public Deal(Long idDeal) {
        this.idDeal = idDeal;
    }

    public Deal(Contract contract, DealType dealType, String name, Boolean active, Date creationDate, Date effectiveDate, Date expiryDate) {
        this.contract = contract;
        this.dealType = dealType;
        this.name = name;
        this.active = active;
        this.creationDate = creationDate;
        this.effectiveDate = effectiveDate;
        this.expiryDate = expiryDate;
    }

    public Deal(Contract contract, DealType dealType, String name, Boolean active, Date creationDate, Date effectiveDate, Date expiryDate, Long licenseExpiryReminder, Set<DealContacts> dealContacts, Set<CustomLicFieldValue> customLicFieldValues, Set<License> licenses, Set<DealDocuments> dealDocuments) {
        this.contract = contract;
        this.dealType = dealType;
        this.name = name;
        this.active = active;
        this.creationDate = creationDate;
        this.effectiveDate = effectiveDate;
        this.expiryDate = expiryDate;
        this.licenseExpiryReminder = licenseExpiryReminder;
        this.dealContacts = dealContacts;
        this.dealCustomLicFieldValues = customLicFieldValues;
        this.licenses = licenses;
        this.dealDocuments = dealDocuments;
    }

    @Id
    @Column(name="ID_DEAL", unique=true, nullable=false, precision=22, scale=0)
    @SequenceGenerator(name="DealID Sequence Generator", sequenceName="CM_DEAL_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="DealID Sequence Generator")
    public Long getIdDeal() {
        return this.idDeal;
    }

    public void setIdDeal(Long idDeal) {
        this.idDeal = idDeal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONTRACT", nullable=false)
    public Contract getContract() {
        return this.contract;
    }

    public void setContract(Contract contract) {
        this.contract = contract;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TYPE", nullable=false)
    public DealType getDealType() {
        return this.dealType;
    }

    public void setDealType(DealType dealType) {
        this.dealType = dealType;
    }

    @Column(name="NAME", unique=true, nullable=false, length=50)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Type(type="yes_no")
    @Column(name="ACTIVE", nullable=false, length=1)
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="CREATION_DATE", nullable=false)
    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="EFFECTIVE_DATE", nullable=false)
    public Date getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="EXPIRY_DATE", nullable=false)
    public Date getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(Date expiryDate) {
        this.expiryDate = expiryDate;
    }

    @Column(name="LICENSE_EXPIRY_REMINDER", precision=22, scale=0)
    public Long getLicenseExpiryReminder() {
        return this.licenseExpiryReminder;
    }

    public void setLicenseExpiryReminder(Long licenseExpiryReminder) {
        this.licenseExpiryReminder = licenseExpiryReminder;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="deal", cascade={CascadeType.ALL})
    public Set<DealContacts> getDealContacts() {
        return this.dealContacts;
    }

    public void setDealContacts(Set<DealContacts> dealContacts) {
        this.dealContacts = dealContacts;
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="ID_DEAL")
    public Set<CustomLicFieldValue> getDealCustomLicFieldValues() {
        return this.dealCustomLicFieldValues;
    }

    public void setDealCustomLicFieldValues(Set<CustomLicFieldValue> customLicFieldValues) {
        this.dealCustomLicFieldValues = customLicFieldValues;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="deal", cascade={CascadeType.REMOVE})
    public Set<License> getLicenses() {
        return this.licenses;
    }

    public void setLicenses(Set<License> licenses) {
        this.licenses = licenses;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="deal", cascade={CascadeType.ALL})
    public Set<DealDocuments> getDealDocuments() {
        return this.dealDocuments;
    }

    public void setDealDocuments(Set<DealDocuments> dealDocuments) {
        this.dealDocuments = dealDocuments;
    }

    @Column(name="EXTERNAL_ID", unique=true, nullable=true, length=100)
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = StringUtils.isEmpty((String)externalId) ? null : externalId;
    }
}

