/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ejb;

import com.ericsson.ejb.CustomLicFieldValue;
import com.ericsson.ejb.FieldDropdown;
import com.ericsson.enumeration.FieldType;
import com.ericsson.enumeration.ScreenName;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="CM_FIELD")
public class Field
implements Serializable {
    private static final long serialVersionUID = 125601636223734676L;
    private Long idField;
    private FieldType type;
    private String name;
    private ScreenName screenName;
    private Boolean dropdown;
    private Boolean required;
    private String defaultValue;
    private Integer minChars;
    private Integer maxChars;
    private Integer fieldOrder;
    private Set<FieldDropdown> fieldDropdowns = new HashSet<FieldDropdown>(0);
    private Set<CustomLicFieldValue> customLicFieldValues = new HashSet<CustomLicFieldValue>(0);

    public Field() {
    }

    public Field(Long idField) {
        this.idField = idField;
    }

    public Field(FieldType type, String name, ScreenName screenName, Boolean required) {
        this.type = type;
        this.name = name;
        this.screenName = screenName;
        this.required = required;
    }

    public Field(FieldType type, String name, ScreenName screenName, Boolean dropdown, Boolean required, String defaultValue, Integer minChars, Integer maxChars, Integer fieldOrder, Set<FieldDropdown> fieldDropdowns) {
        this.type = type;
        this.name = name;
        this.screenName = screenName;
        this.dropdown = dropdown;
        this.required = required;
        this.defaultValue = defaultValue;
        this.minChars = minChars;
        this.maxChars = maxChars;
        this.fieldOrder = fieldOrder;
        this.fieldDropdowns = fieldDropdowns;
    }

    @Id
    @Column(name="ID_FIELD", unique=true, nullable=false, precision=22, scale=0)
    @SequenceGenerator(name="FieldID Sequence Generator", sequenceName="CM_FIELD_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="FieldID Sequence Generator")
    public Long getIdField() {
        return this.idField;
    }

    public void setIdField(Long idField) {
        this.idField = idField;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="TYPE", nullable=false, length=50)
    public FieldType getType() {
        return this.type;
    }

    public void setType(FieldType type) {
        this.type = type;
    }

    @Column(name="NAME", nullable=false, length=50)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="SCREEN_NAME", nullable=false, length=50)
    public ScreenName getScreenName() {
        return this.screenName;
    }

    public void setScreenName(ScreenName screenName) {
        this.screenName = screenName;
    }

    @Type(type="yes_no")
    @Column(name="DROPDOWN", length=1)
    public Boolean getDropdown() {
        return this.dropdown == null ? false : this.dropdown;
    }

    public void setDropdown(Boolean dropdown) {
        this.dropdown = dropdown;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="field", cascade={CascadeType.ALL})
    public Set<FieldDropdown> getFieldDropdowns() {
        return this.fieldDropdowns;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    @Type(type="yes_no")
    @Column(name="REQUIRED", nullable=false, length=1)
    public Boolean getRequired() {
        return this.required;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Column(name="DEFAULT_VALUE", length=50)
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setMinChars(Integer minChars) {
        this.minChars = minChars;
    }

    @Column(name="MIN_CHARS")
    public Integer getMinChars() {
        return this.minChars;
    }

    public void setMaxChars(Integer maxChars) {
        this.maxChars = maxChars;
    }

    @Column(name="MAX_CHARS")
    public Integer getMaxChars() {
        return this.maxChars;
    }

    public void setFieldOrder(Integer fieldOrder) {
        this.fieldOrder = fieldOrder;
    }

    @Column(name="F_ORDER")
    public Integer getFieldOrder() {
        return this.fieldOrder;
    }

    public void setFieldDropdowns(Set<FieldDropdown> fieldDropdowns) {
        this.fieldDropdowns = fieldDropdowns;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="field")
    public Set<CustomLicFieldValue> getCustomLicFieldValues() {
        return this.customLicFieldValues;
    }

    public void setCustomLicFieldValues(Set<CustomLicFieldValue> customLicFieldValues) {
        this.customLicFieldValues = customLicFieldValues;
    }
}

