/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ejb;

import com.ericsson.ejb.Document;
import com.ericsson.ejb.License;
import java.io.Serializable;
import java.util.Arrays;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="CM_LICENSE_DOCUMENTS")
public class LicenseDocuments
implements Serializable,
Document {
    private static final long serialVersionUID = -2101850209199496233L;
    private Long idDocument;
    private License license;
    private String fileName;
    private byte[] fileBytes;

    public LicenseDocuments() {
    }

    public LicenseDocuments(License license) {
        this.license = license;
    }

    public LicenseDocuments(License license, String fileName, byte[] licenseFile) {
        this.license = license;
        this.fileName = fileName;
        this.fileBytes = licenseFile == null ? null : Arrays.copyOf(licenseFile, licenseFile.length);
    }

    @Override
    @Id
    @Column(name="ID_DOCUMENT", unique=true, nullable=false, precision=22, scale=0)
    @SequenceGenerator(name="LicenseDocumentsID Sequence Generator", sequenceName="CM_LICENSE_DOCUMENTS_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="LicenseDocumentsID Sequence Generator")
    public Long getIdDocument() {
        return this.idDocument;
    }

    public void setIdDocument(Long idDocument) {
        this.idDocument = idDocument;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LICENSE", nullable=false)
    public License getLicense() {
        return this.license;
    }

    public void setLicense(License license) {
        this.license = license;
    }

    @Override
    @Column(name="FILE_NAME", length=50)
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    @Basic(fetch=FetchType.LAZY)
    @Column(name="LICENSE_FILE")
    public byte[] getFileBytes() {
        return this.fileBytes;
    }

    public void setFileBytes(byte[] licenseFile) {
        this.fileBytes = licenseFile == null ? null : Arrays.copyOf(licenseFile, licenseFile.length);
    }
}

