/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content;

import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.adaptor.dispatcher.AbstractDispatcher;
import com.tandbergtv.workflow.adaptor.dispatcher.DispatcherException;
import com.tandbergtv.workflow.adaptor.util.XMLDocumentUtility;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.HTTPMessage;
import com.tandbergtv.workflow.message.HTTPPayload;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.message.util.Marshaller;
import com.tandbergtv.workflow.message.util.Unmarshaller;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import javax.ejb.EJBException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class MetadataEnhancementMessageDispatcher
extends AbstractDispatcher {
    protected static final String SUBSCRIPTION_PROFILE_IDS = "subscriptionProfileIds";
    protected static final String TITLE_ID = "titleId";
    protected static final String CONFLICT_RESOLUTION_URL = "conflictResolutionUrl";
    protected static final String CONFLICT_RESOLUTION_URL_PREFIX = "/portal/#Content.Search?action=DECONFLICT&titleId=";
    private static final Logger logger = Logger.getLogger(MetadataEnhancementMessageDispatcher.class);
    protected static final int DEFAULT_MAXIMUM_MESSAGE_LENGTH = 2048;

    public MetadataEnhancementMessageDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    public IMessage send(IMessage msg) throws DispatcherException {
        WorkflowMessage message = null;
        try {
            message = this.getWorkflowMessage(msg);
        }
        catch (Exception e) {
            String errMsg = "Failed to parse the workflow message, error: " + e.getMessage();
            throw new DispatcherException(errMsg, (Throwable)e);
        }
        WorkflowMessage response = null;
        try {
            response = this.generateResponse(message);
        }
        catch (RuntimeException e) {
            Throwable error = this.getError(e);
            String errorMessage = "Failed to perform operation, error: " + error.getMessage();
            response = this.generateNackMessage(message, errorMessage);
            logger.error((Object)errorMessage, (Throwable)e);
        }
        try {
            Document responseDocument = Marshaller.newMarshaller().marshal(response);
            String responseValue = XMLDocumentUtility.convertToString((Node)responseDocument);
            HTTPPayload httpPayload = new HTTPPayload(responseValue);
            HTTPMessage responseMsg = new HTTPMessage(httpPayload);
            logger.debug((Object)("Generated message: " + responseMsg));
            return responseMsg;
        }
        catch (Exception e) {
            String errMsg = "Could not serialize the workflow message response to XML, error: " + e.getMessage();
            throw new DispatcherException(errMsg, (Throwable)e);
        }
    }

    protected abstract WorkflowMessage generateResponse(WorkflowMessage var1);

    private WorkflowMessage getWorkflowMessage(IMessage message) throws Exception {
        Document doc = XMLDocumentUtility.loadXml((String)message.getPayload().getContent());
        return Unmarshaller.unmarshal((Document)doc);
    }

    protected WorkflowMessage generateNackMessage(WorkflowMessage request, String errorMessage) {
        WorkflowMessage response = WorkflowMessageFactory.createNackMessage((WorkflowMessage)request);
        response.putValue("error-message", errorMessage);
        return response;
    }

    protected String getIndexedParameterName(String parameterNamePrefix, int index) {
        return parameterNamePrefix + Integer.toString(index);
    }

    protected String getPropertyValue(String property) {
        return this.getConfiguration().getParameterValue(property);
    }

    protected void saveXMLDocument(Document document, File xmlFile) {
        OutputStream outputStream = null;
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            String xmlEncoding = document.getXmlEncoding();
            if (xmlEncoding != null) {
                transformer.setOutputProperty("encoding", xmlEncoding);
            }
            outputStream = new FileOutputStream(xmlFile);
            transformer.transform(new DOMSource(document), new StreamResult(outputStream));
        }
        catch (Exception e) {
            String message = "Failed to write XML document to file: " + xmlFile;
            throw new RuntimeException(message, e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception ex) {
                    String message = "Failed to close the output stream for the file: " + xmlFile;
                    logger.warn((Object)message, (Throwable)ex);
                }
            }
        }
    }

    private Throwable getError(RuntimeException e) {
        Exception error = e;
        while (error instanceof EJBException) {
            error = ((EJBException)error).getCausedByException();
        }
        return error;
    }

    protected String getFileSize(String fileURI) {
        try {
            File file = new File(fileURI);
            long length = file.length();
            return Long.toString(length);
        }
        catch (Exception ignore) {
            logger.debug((Object)("Failed to get file size for file: " + fileURI + ", ignoring error: " + ignore.getLocalizedMessage()), (Throwable)ignore);
            return null;
        }
    }

    protected String getCSVString(Collection<?> list) {
        StringBuilder buf = new StringBuilder();
        for (Object value : list) {
            if (buf.length() != 0) {
                buf.append(",");
            }
            buf.append(value);
        }
        return buf.toString();
    }

    protected String trimMessage(String message) {
        return this.trimMessage(message, 2048);
    }

    protected String trimMessage(String message, int maxLength) {
        if (message == null) {
            return "";
        }
        if (message.length() > maxLength) {
            message = message.substring(0, maxLength - 3) + "...";
        }
        return message;
    }

    protected String getCount(Collection<?> collection) {
        int size = collection != null ? collection.size() : 0;
        return Integer.toString(size);
    }

    protected String getOutputValue(Object value) {
        return value == null ? "" : value.toString();
    }

    protected void validateRequired(WorkflowMessage message, String ... paramNames) {
        if (paramNames != null) {
            for (String paramName : paramNames) {
                if (this.getStringValueTrimmed(message, paramName) != null) continue;
                throw new RuntimeException("Parameter " + paramName + " is not found or does not have value");
            }
        }
    }

    protected String getStringValueTrimmed(WorkflowMessage message, String paramName) {
        String value;
        String string = value = message.getPayload() != null ? message.getValue(paramName) : null;
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() == 0) {
            return null;
        }
        return value;
    }

    protected void validateRequired(WorkflowMessage message, String paramName) {
        Object value;
        Object object = value = message.getPayload() != null ? message.getParameterValue(paramName) : null;
        if (value == null) {
            throw new RuntimeException("Parameter " + paramName + " is not found or does not have value");
        }
    }

    protected Object getMessageParameter(WorkflowMessage message, String name) {
        return message.getPayload().getParameterValue(name);
    }

    protected String getWorkorderRequestKey(WorkflowMessage message) {
        return message.getKey().toString();
    }

    protected String getConflictResolutionUrl(String titleId) {
        return CONFLICT_RESOLUTION_URL_PREFIX + titleId;
    }
}

