/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.specimpl.cl1_1;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.metadatamanager.spec.IIdentifier;
import com.tandbergtv.metadatamanager.specimpl.IdentifierBase;
import com.tandbergtv.metadatamanager.specimpl.SingleTitleSpecHandler;
import com.tandbergtv.metadatamanager.specimpl.cl1_1.CL1_1_Identifier;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class CL1_1SpecHandler
extends SingleTitleSpecHandler {
    private static final String ADI_ROOTELEMENT_NAME = "ADI";
    private static boolean CL1_1_RETAIN_DERIVED_ASSETS = false;
    private static String[] LIST_OF_ASSET_TYPES_TO_RETAIN = new String[]{"MOVIE"};
    private static final String[] LIST_OF_ALLOWED_ASSET_TYPES = new String[]{"MOVIE", "PREVIEW", "POSTER", "BOXCOVER", "TRICK", "ENCRYPTED", "BARKER"};

    public CL1_1SpecHandler() {
        this.alias = "CL1_1";
        this.rootElementName = ADI_ROOTELEMENT_NAME;
    }

    public IIdentifier extractId(Asset asset) {
        CL1_1_Identifier id = new CL1_1_Identifier();
        id.setSearchService(this.getSearchService());
        id.setMappingResourceUrl(this.getMappingResourceUrl());
        Map<String, String> idXPaths = id.getTTVPaths();
        HashMap<String, String> idValues = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : idXPaths.entrySet()) {
            Field f = asset.getFirstField(entry.getValue());
            if (f == null) continue;
            idValues.put(entry.getKey(), f.getValue());
        }
        id.setSpecIdentifiers(idValues);
        return id;
    }

    public IdentifierBase getIdentifier() {
        CL1_1_Identifier identifier = new CL1_1_Identifier();
        identifier.setSearchService(this.searchService);
        identifier.setMappingResourceUrl(this.mappingResourceUrl);
        return identifier;
    }

    public String getSpecDisplayName() {
        return "CableLabsVOD1.1";
    }

    protected boolean requireSpecSpecificMerging(String assetType) {
        if (CL1_1_RETAIN_DERIVED_ASSETS && Arrays.asList(LIST_OF_ASSET_TYPES_TO_RETAIN).contains(assetType)) {
            return true;
        }
        return super.requireSpecSpecificMerging(assetType);
    }

    protected void specSpecificMergingNoSave(Asset newAsset, Relation oldRelation, Asset oldTargetAsset) {
        if (Arrays.asList(LIST_OF_ASSET_TYPES_TO_RETAIN).contains(oldTargetAsset.getType()) && Arrays.asList(LIST_OF_ALLOWED_ASSET_TYPES).contains(oldTargetAsset.getType())) {
            this.mergeOldAsset(newAsset, oldTargetAsset);
        } else {
            super.specSpecificMergingNoSave(newAsset, oldRelation, oldTargetAsset);
        }
    }

    private void mergeOldAsset(Asset newAsset, Asset oldTargetAsset) {
        Asset newTargetAsset = this.findAsset(oldTargetAsset, newAsset.getImmediateChildren());
        if (newTargetAsset != null) {
            this.mergeRecursively(newTargetAsset, oldTargetAsset);
        } else {
            newAsset.addChild(this.copyAssetTree(oldTargetAsset));
        }
    }

    static {
        Properties config = new Properties();
        InputStream fileStream = CL1_1SpecHandler.class.getResourceAsStream("/cl1_1.properties");
        if (fileStream != null) {
            String assetTypes;
            try {
                config.load(fileStream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String retainAssetsFlag = config.getProperty("cl1_1.retainDerivedAssets");
            if (retainAssetsFlag != null && "true".compareToIgnoreCase(retainAssetsFlag) == 0) {
                CL1_1_RETAIN_DERIVED_ASSETS = true;
            }
            if ((assetTypes = config.getProperty("cl1_1.assetTypesToRetain")) != null && assetTypes.length() > 0) {
                LIST_OF_ASSET_TYPES_TO_RETAIN = assetTypes.toUpperCase().split("( *),( *)");
            }
        }
    }
}

