/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.export.csv;

import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.cms.sites.core.entities.DistributionSiteTitle;
import com.ericsson.cms.sites.export.ISiteExporter;
import com.tandbergtv.cms.contentmgmt.service.specification.IAssetSpecificationManager;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.workflow.web.table.Column;
import com.tandbergtv.workflow.web.table.Table;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CSVExporter
implements ISiteExporter {
    private static Logger logger = Logger.getLogger(CSVExporter.class);
    private static final String TABLE_NAME = "targetedTitlesColumns";
    private static final char DELIMITER = ',';
    private static final String COLUMN_NAME_ID = "id";
    private static final String COLUMN_NAME_STATUS = "status";
    private static final String COLUMN_NAME_THUMBNAIL = "thumbnail";
    private static final String COLUMN_NAME_STATUS_UPDATE_TIME = "statusUpdateTime";
    private IAssetSpecificationManager specManager = (IAssetSpecificationManager)InjectionUtil.injectInstance((String)"cms/AssetSpecificationManager/local", IAssetSpecificationManager.class);

    public void setParams(Map<String, String> params) {
        logger.info((Object)("params : " + params));
    }

    public void exportTitles(DistributionSite distSite, Collection<DistributionSiteTitle> siteTitles, String filePath) {
        logger.info((Object)distSite);
        Table table = this.specManager.getTableConfiguration(TABLE_NAME);
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(filePath)), Charset.forName("UTF-8")));
            StringBuilder sb = new StringBuilder();
            for (Column col : table.getColumns()) {
                String columnName = col.getMethodName();
                if (COLUMN_NAME_THUMBNAIL.equals(columnName)) continue;
                if (sb.length() > 0) {
                    sb.append(',');
                }
                this.encodeValue(sb, col.getColumnName());
            }
            out.write(sb.toString());
            out.newLine();
            for (DistributionSiteTitle dst : siteTitles) {
                logger.info((Object)("Got dst : " + dst));
                Title title = dst.getTitle();
                Asset rootAsset = title.getAsset();
                sb = new StringBuilder();
                for (Column col : table.getColumns()) {
                    String columnName = col.getMethodName();
                    String sectionName = null;
                    ArrayList<String> assetTypes = new ArrayList<String>();
                    if (col.getColumnAttribute("TitleSection") != null) {
                        String[] sectionNameParts;
                        columnName = col.getParameter();
                        sectionName = col.getColumnAttribute("TitleSection");
                        for (String sectionNamePart : sectionNameParts = sectionName.split("/")) {
                            assetTypes.add(sectionNamePart);
                        }
                    }
                    if (COLUMN_NAME_THUMBNAIL.equals(columnName)) continue;
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    if (COLUMN_NAME_ID.equals(columnName)) {
                        sb.append(title.getId());
                        continue;
                    }
                    if (COLUMN_NAME_STATUS.equals(columnName)) {
                        sb.append(dst.getStatus());
                        continue;
                    }
                    if (COLUMN_NAME_STATUS_UPDATE_TIME.equals(columnName)) {
                        sb.append(dst.getStatusUpdatedTime());
                        continue;
                    }
                    List assets = rootAsset.getAllAssetsWithLineage(assetTypes);
                    if (assets.size() <= 0) continue;
                    Asset asset = (Asset)assets.get(0);
                    Field field = asset.getFirstField(columnName);
                    if (field != null) {
                        this.encodeValue(sb, field.getValue());
                        continue;
                    }
                    sb.append("");
                }
                out.write(sb.toString());
                out.newLine();
            }
            out.close();
        }
        catch (Exception e) {
            logger.error((Object)("Exception occured exporting titles : " + e), (Throwable)e);
            throw new RuntimeException(e);
        }
        logger.info((Object)filePath);
    }

    private void encodeValue(StringBuilder sb, String value) {
        boolean wrapWithQuotes = false;
        int startIndex = sb.length();
        for (int i = 0; i < value.length(); ++i) {
            char chr = value.charAt(i);
            if (!(wrapWithQuotes || chr != ',' && chr != '\"')) {
                wrapWithQuotes = true;
                sb.insert(startIndex, '\"');
            }
            if (chr == '\"') {
                sb.append('\"');
            }
            if (chr == '\r' || chr == '\n') {
                sb.append(' ');
                continue;
            }
            sb.append(chr);
        }
        if (wrapWithQuotes) {
            sb.append('\"');
        }
    }
}

