/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.service.category;

import com.ericsson.cms.criteria.ret.RetTree;
import com.ericsson.cms.sites.core.entities.Site;
import com.ericsson.cms.sites.core.entities.mediapath.MSO;
import com.tandbergtv.cms.titlefilter.CriteriaMode;
import com.tandbergtv.marvin.udt.TreEvent;
import com.tandbergtv.marvin.udt.TreMsoOverrrideRuleSet;
import com.tandbergtv.marvin.udt.TrePackage;
import com.tandbergtv.marvin.udt.TreRule;
import com.tandbergtv.marvin.udt.TreRuleSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TreRuleSetCachable {
    TrePackage tpack;
    Date updateDate;
    Integer order;
    boolean enabled;
    private Set<TreEvent> events;
    private Integer ruleSetId;
    private String ruleName;
    private RetTree filter;
    private List<TreRule> rules = new ArrayList<TreRule>();
    private Set<Integer> validSites;
    private Set<Integer> msos = new HashSet<Integer>();
    private boolean global;
    private CriteriaMode critMode;
    private String uuid;
    private TreRuleSet ruleSet;

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public TreRuleSet getRuleSet() {
        return this.ruleSet;
    }

    public void setRuleSet(TreRuleSet ruleSet) {
        this.ruleSet = ruleSet;
    }

    public TreRuleSetCachable(TreRuleSet rs) {
        this.ruleSetId = rs.getRuleSetId();
        this.ruleSet = rs;
        this.enabled = rs.getEnabled();
        this.updateDate = rs.getUpdateDate();
        this.events = rs.getEvents();
        this.order = rs.getOrder_();
        this.ruleName = rs.getRuleName();
        this.uuid = rs.getUuid().toString();
        if (rs.getRules() != null) {
            for (TreRule r : rs.getRules()) {
                this.getRules().add(r.clone());
            }
        }
        this.filter = rs.getFilter().getRootNode() != null ? rs.getFilter().getRootNode().getAsOptimizedTree() : new RetTree();
        this.global = rs.isRunOnGlobal();
        if (!rs.getSites().isEmpty()) {
            this.validSites = new HashSet<Integer>();
            for (Site s : rs.getSites()) {
                this.validSites.add(s.getId());
            }
        }
        this.critMode = rs.getFilter().getCriteriaMode();
        this.tpack = rs.getTpackage();
        if (this.tpack.getName().equals("MSOOVERRIDE") && ((TreMsoOverrrideRuleSet)rs).getMsos() != null) {
            for (MSO mso : ((TreMsoOverrrideRuleSet)rs).getMsos()) {
                this.msos.add(new Integer(mso.getId()));
            }
        }
    }

    public Set<Integer> getSites() {
        if (this.validSites == null) {
            this.validSites = new HashSet<Integer>();
        }
        return this.validSites;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public Integer getOrder() {
        return this.order;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Set<TreEvent> getEvents() {
        return this.events;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public RetTree getFilter() {
        return this.filter;
    }

    public Integer getRuleSetId() {
        return this.ruleSetId;
    }

    public TrePackage getTpackage() {
        return this.tpack;
    }

    public List<TreRule> getRules() {
        return this.rules;
    }

    public boolean filterHasCriter() {
        return this.filter != null;
    }

    public CriteriaMode getCriteriaMode() {
        return this.critMode;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public Set<Integer> getMsos() {
        return this.msos;
    }
}

