/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.udt;

import com.ericsson.cms.criteria.ChangesBuilder;
import com.ericsson.cms.criteria.EntityChangeRecord;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.tandbergtv.marvin.udt.TreAction;
import com.tandbergtv.marvin.udt.TreCustomRule;
import com.tandbergtv.marvin.udt.TreStandardRule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlSeeAlso;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=TreStandardRule.class, name="treStandardRule"), @JsonSubTypes.Type(value=TreCustomRule.class, name="treCustomRule")})
@XmlSeeAlso(value={TreStandardRule.class, TreCustomRule.class})
public abstract class TreRule
implements Serializable,
Cloneable,
EntityChangeRecord<TreRule> {
    private static final long serialVersionUID = -4033407941523059683L;
    private Integer ruleId;
    private List<TreAction> actions;
    private RuleType ruleType;
    private Date createDate;
    private Date updateDate;
    private Integer version;

    public TreRule() {
    }

    public TreRule(List<TreAction> actions, RuleType ruleType) {
        this.actions = actions;
        this.ruleType = ruleType;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    @XmlElement
    public Date getCreateDate() {
        return this.createDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    @XmlElement
    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setRuleId(Integer ruleId) {
        this.ruleId = ruleId;
    }

    @XmlAttribute
    public Integer getRuleId() {
        return this.ruleId;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    @XmlElement
    public Integer getVersion() {
        return this.version;
    }

    public void setActions(List<TreAction> actions) {
        this.actions = actions;
    }

    @XmlElementWrapper(name="actions", nillable=true)
    @XmlElement(name="action", nillable=true)
    public List<TreAction> getActions() {
        return this.actions;
    }

    protected void setRuleType(RuleType ruleType) {
        this.ruleType = ruleType;
    }

    @JsonIgnore
    @XmlElement(nillable=true)
    public RuleType getRuleType() {
        return this.ruleType;
    }

    public abstract TreRule clone();

    protected List<TreAction> cloneActions() {
        ArrayList<TreAction> actionsClone = new ArrayList<TreAction>();
        for (TreAction a : this.actions) {
            actionsClone.add(a.clone());
        }
        return actionsClone;
    }

    public boolean hasChanges(TreRule treRule) {
        if (treRule == null) {
            return true;
        }
        return new ChangesBuilder().appendFields((Object)this.getRuleType(), (Object)treRule.getRuleType()).appendFields(this.getActions(), treRule.getActions()).build();
    }

    public static enum RuleType {
        STANDARD_RULE("SR"),
        CUSTOME_RULE("CR");

        private String key;

        private RuleType(String key) {
            this.setKey(key);
        }

        private void setKey(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public static RuleType lookUp(String key) {
            for (RuleType rt : RuleType.values()) {
                if (!rt.key.equals(key)) continue;
                return rt;
            }
            return STANDARD_RULE;
        }
    }
}

