/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.udt;

import com.ericsson.cms.criteria.ChangesBuilder;
import com.ericsson.cms.criteria.EntityChangeRecord;
import com.ericsson.cms.scheduler.entities.ScheduleRule;
import com.ericsson.cms.sites.core.entities.Site;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.tandbergtv.cms.titlefilter.TitleFilter;
import com.tandbergtv.marvin.udt.RuleSetRevisionSite;
import com.tandbergtv.marvin.udt.TreEvent;
import com.tandbergtv.marvin.udt.TreEventWrapper;
import com.tandbergtv.marvin.udt.TreMsoOverrrideRuleSet;
import com.tandbergtv.marvin.udt.TrePackage;
import com.tandbergtv.marvin.udt.TreRule;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@JsonRootName(value="ruleSet")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=TreRuleSet.class, name="treRuleSet"), @JsonSubTypes.Type(value=TreMsoOverrrideRuleSet.class, name="treMsoOverrrideRuleSet")})
@JsonPropertyOrder(value={"ruleSetId", "href", "ruleName", "version", "tpackage", "uuid", "runOnGlobal", "eventsHibernate", "scheduleRule", "filter", "rules", "sites", "enabled", "isEmailNotify", "createDate", "updateDate", "batches", "jobLimit", "currentBatch", "packId", "uiUpdate", "ignoreInvalidSchedule"})
@XmlRootElement(name="ruleSet")
@XmlSeeAlso(value={TreMsoOverrrideRuleSet.class})
@XmlType(propOrder={"ruleName", "version", "tpackage", "uuid", "runOnGlobal", "eventsHibernate", "scheduleRule", "filter", "rules", "sites", "enabled", "isEmailNotify", "createDate", "updateDate", "order_", "batches", "jobLimit", "currentBatch", "packId", "uiUpdate", "ignoreInvalidSchedule"})
public class TreRuleSet
implements Serializable,
Comparable<TreRuleSet>,
EntityChangeRecord<TreRuleSet>,
Cloneable {
    private static final long serialVersionUID = 7197005489007721384L;
    private Integer ruleSetId;
    private String uuid;
    private List<TreRule> rules;
    private Set<TreEventWrapper> events;
    private Set<Site> sites;
    private Integer version;
    private String ruleName;
    private TrePackage tpackage;
    private TitleFilter filter;
    private Boolean runOnGlobal;
    private Boolean enabled;
    private Boolean isEmailNotify = false;
    private Date createDate;
    private Date updateDate;
    private ScheduleRule scheduleRule;
    @XmlElement(nillable=true)
    private Integer order_;
    private int batches;
    private int jobLimit;
    private int currentBatch;
    private Integer packId;
    private boolean uiUpdate;
    private boolean ignoreInvalidSchedule;
    private int revision;
    private Collection<RuleSetRevisionSite> revisionSites;
    private String href;

    public TreRuleSet() {
    }

    public TreRuleSet(TreRuleSet ruleSet) {
        this.setRuleSetId(ruleSet.getRuleSetId());
        this.setUuid(ruleSet.getUuid());
        this.setRules(ruleSet.getRules());
        this.setEvents(ruleSet.getEvents());
        this.setSites(ruleSet.getSites());
        this.setVersion(ruleSet.getVersion());
        this.setRuleName(ruleSet.getRuleName());
        this.setTpackage(ruleSet.getTpackage());
        this.setFilter(ruleSet.getFilter());
        this.setRunOnGlobal(ruleSet.isRunOnGlobal());
        this.setEnabled(ruleSet.getEnabled());
        this.setIsEmailNotify(ruleSet.getIsEmailNotify());
        this.setCreateDate(ruleSet.getCreateDate());
        this.setUpdateDate(ruleSet.getUpdateDate());
        this.setScheduleRule(ruleSet.getScheduleRule());
        this.setOrder_(ruleSet.getOrder_());
        this.setBatches(ruleSet.getBatches());
        this.setJobLimit(ruleSet.getJobLimit());
        this.setCurrentBatch(ruleSet.getCurrentBatch());
        this.setPackId(ruleSet.getPackId());
        this.setUiUpdate(ruleSet.isUiUpdate());
        this.setIgnoreInvalidSchedule(ruleSet.isIgnoreInvalidSchedule());
    }

    public TreRuleSet asAuditRuleSet() {
        TreRuleSet ruleset = new TreRuleSet();
        ruleset.setRuleSetId(this.getRuleSetId());
        ruleset.setRuleName(this.getRuleName());
        ruleset.setEnabled(this.getEnabled());
        return ruleset;
    }

    public TreRuleSet asAuditRuleSet(boolean enable) {
        TreRuleSet ruleset = new TreRuleSet();
        ruleset.setRuleSetId(this.getRuleSetId());
        ruleset.setRuleName(this.getRuleName());
        ruleset.setEnabled(enable);
        return ruleset;
    }

    public boolean isIgnoreInvalidSchedule() {
        return this.ignoreInvalidSchedule;
    }

    public void setIgnoreInvalidSchedule(boolean ignoreInvalidSchedule) {
        this.ignoreInvalidSchedule = ignoreInvalidSchedule;
    }

    public boolean isUiUpdate() {
        return this.uiUpdate;
    }

    public void setUiUpdate(boolean uiUpdate) {
        this.uiUpdate = uiUpdate;
    }

    public Integer getPackId() {
        return this.packId;
    }

    public void setPackId(Integer packId) {
        this.packId = packId;
    }

    public int getCurrentBatch() {
        return this.currentBatch;
    }

    public void setCurrentBatch(int currentBatch) {
        this.currentBatch = currentBatch;
    }

    public int getJobLimit() {
        return this.jobLimit;
    }

    public void setJobLimit(int jobLimit) {
        this.jobLimit = jobLimit;
    }

    public int getBatches() {
        return this.batches;
    }

    public void setBatches(int batches) {
        this.batches = batches;
    }

    @JsonIgnore
    @XmlTransient
    public Integer getOrder_() {
        return this.order_;
    }

    public void setOrder_(Integer order) {
        this.order_ = order;
    }

    public void setRules(List<TreRule> rules) {
        this.rules = rules;
    }

    @XmlElementWrapper(name="rules", nillable=true)
    @XmlElement(name="rule", nillable=true)
    public List<TreRule> getRules() {
        return this.rules;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    @XmlElement
    public Date getCreateDate() {
        return this.createDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    @XmlElement
    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setEvents(Set<TreEvent> events) {
        if (this.events != null) {
            this.events.clear();
        }
        if (events == null) {
            return;
        }
        if (this.events == null) {
            this.events = new HashSet<TreEventWrapper>();
        }
        for (TreEvent event : events) {
            this.events.add(new TreEventWrapper(event.ordinal()));
        }
    }

    @JsonIgnore
    @XmlTransient
    public Set<TreEvent> getEvents() {
        HashSet<TreEvent> result = new HashSet<TreEvent>();
        if (this.events == null) {
            return result;
        }
        for (TreEventWrapper event : this.events) {
            result.add(TreEvent.values()[event.getEventId()]);
        }
        return result;
    }

    public void setEventsHibernate(Set<TreEventWrapper> events) {
        this.events = events;
    }

    @JsonGetter(value="events")
    @XmlElementWrapper(name="events", nillable=true)
    @XmlElement(name="event", nillable=true)
    public Set<TreEventWrapper> getEventsHibernate() {
        return this.events;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    @XmlElement
    public Integer getVersion() {
        return this.version;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    @XmlElement
    public String getRuleName() {
        return this.ruleName;
    }

    public void setRuleSetId(Integer ruleSetId) {
        this.ruleSetId = ruleSetId;
    }

    @XmlAttribute
    public Integer getRuleSetId() {
        return this.ruleSetId;
    }

    public void setFilter(TitleFilter filter) {
        this.filter = filter;
    }

    @JsonGetter(value="titleFilter")
    @XmlElement(name="titleFilter", nillable=true, required=true)
    public TitleFilter getFilter() {
        return this.filter;
    }

    public void setTpackage(TrePackage tpackage) {
        this.tpackage = tpackage;
    }

    @JsonGetter(value="package")
    @XmlElement(name="package", nillable=true, required=true)
    public TrePackage getTpackage() {
        return this.tpackage;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @XmlElement(nillable=true, required=true)
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setIsEmailNotify(Boolean notify) {
        this.isEmailNotify = notify;
    }

    @XmlElement(nillable=true, required=true)
    public Boolean getIsEmailNotify() {
        return this.isEmailNotify;
    }

    @Override
    public int compareTo(TreRuleSet comp) {
        return this.ruleSetId - comp.getRuleSetId();
    }

    public void setRunOnGlobal(boolean runOnGlobal) {
        this.runOnGlobal = runOnGlobal;
    }

    @XmlElement(nillable=true)
    public boolean isRunOnGlobal() {
        return this.runOnGlobal;
    }

    @XmlElement(nillable=true)
    public UUID getUuid() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID().toString();
        }
        return UUID.fromString(this.uuid);
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid.toString();
    }

    @JsonIgnore
    @XmlTransient
    public String getHibernateUuid() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID().toString();
        }
        return this.uuid;
    }

    public void setHibernateUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setSites(Set<Site> sites) {
        this.sites = sites;
    }

    @XmlElementWrapper(name="sites", nillable=true)
    @XmlElement(name="site", nillable=true)
    public Set<Site> getSites() {
        return this.sites;
    }

    @XmlElement(nillable=true)
    public ScheduleRule getScheduleRule() {
        return this.scheduleRule;
    }

    public void setScheduleRule(ScheduleRule scheduleRule) {
        this.scheduleRule = scheduleRule;
    }

    @JsonIgnore
    @XmlTransient
    public int getRevision() {
        return this.revision;
    }

    public void setRevision(int revision) {
        this.revision = revision;
    }

    @XmlTransient
    public Collection<RuleSetRevisionSite> getRevisionSites() {
        return this.revisionSites;
    }

    public void setRevisionSites(Collection<RuleSetRevisionSite> revisionSites) {
        this.revisionSites = revisionSites;
    }

    @JsonIgnore
    public TreRuleSet getNewInstance() {
        return new TreRuleSet(this);
    }

    public TreRuleSet copyRuleSetForDelete() {
        TreRuleSet ruleSetForDelete = new TreRuleSet();
        ruleSetForDelete.setRuleSetId(this.getRuleSetId());
        ruleSetForDelete.setRuleName(this.getRuleName());
        ruleSetForDelete.setUuid(this.getUuid());
        TrePackage trePackage = new TrePackage();
        trePackage.setName(this.getTpackage().getName());
        ruleSetForDelete.setTpackage(trePackage);
        return ruleSetForDelete;
    }

    public void setHref(String href) {
        this.href = href;
    }

    @XmlAttribute
    public String getHref() {
        return this.href;
    }

    public boolean hasChanges(TreRuleSet ruleSet) {
        if (ruleSet == null) {
            return true;
        }
        return new ChangesBuilder().appendFields((Object)this.isIgnoreInvalidSchedule(), (Object)ruleSet.isIgnoreInvalidSchedule()).appendFields(this.getEvents(), ruleSet.getEvents()).appendFields((Object)this.getJobLimit(), (Object)ruleSet.getJobLimit()).appendFields((Object)this.isRunOnGlobal(), (Object)ruleSet.isRunOnGlobal()).appendFields((Object)this.getRuleName(), (Object)ruleSet.getRuleName()).appendFields((Object)this.getIsEmailNotify(), (Object)ruleSet.getIsEmailNotify()).appendFields(this.getSites(), ruleSet.getSites()).appendFields((Object)this.getFilter(), (Object)ruleSet.getFilter()).appendFields(this.getRules(), ruleSet.getRules()).appendFields((Object)this.getScheduleRule(), (Object)ruleSet.getScheduleRule()).build();
    }

    public boolean statusChanges(TreRuleSet ruleSet) {
        if (ruleSet == null) {
            return true;
        }
        return !this.getEnabled().equals(ruleSet.getEnabled());
    }

    public TreRuleSet copyRuleSet() {
        return new TreRuleSet(this);
    }

    public TreRuleSet cloneForClusterSync() {
        TreRuleSet rs = this.copyRuleSet();
        TrePackage trePackage = new TrePackage();
        trePackage.setName(rs.getTpackage().getName());
        rs.setTpackage(trePackage);
        return rs;
    }
}

