/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services;

import com.ericsson.cms.scheduler.entities.ScheduleRule;
import com.tandbergtv.cms.services.ScheduleTime;
import com.tandbergtv.cms.services.TimeZoneHelper;
import com.tandbergtv.cms.services.TimerHelper;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class EveryNHourMins {
    private static long MSEC_IN_ONE_HOUR = 3600000L;
    private static long MSEC_IN_ONE_MIN = 60000L;
    private static final Logger logger = Logger.getLogger(EveryNHourMins.class);

    public static ScheduleTime getTime(ScheduleRule rule) {
        Date jobStartDate;
        String numberOfHourMins = rule.getParam(1).getValue();
        String timeUnit = rule.getParam(2).getValue();
        String jobTime = rule.getParam(3).getValue();
        Long tUnitMsec = MSEC_IN_ONE_HOUR;
        if (timeUnit.equals(TimeUnit.HOURS.name())) {
            tUnitMsec = MSEC_IN_ONE_HOUR;
        } else if (timeUnit.equals(TimeUnit.MINUTES.name())) {
            tUnitMsec = MSEC_IN_ONE_MIN;
        }
        if (numberOfHourMins == null) {
            logger.error((Object)"Number of hours/mins not specified");
            return null;
        }
        if (Integer.parseInt(numberOfHourMins) == 0) {
            logger.error((Object)"Number of hours/mins cannot be 0");
            return null;
        }
        Date startDate = rule.getStartDate();
        Date now = new Date();
        if (startDate == null || startDate.before(now)) {
            startDate = now;
        }
        if ((jobStartDate = TimerHelper.getStartDateTime(startDate, jobTime)).before(now)) {
            long jobStartDateMillis = jobStartDate.getTime();
            Date newJobStartDate = new Date(jobStartDateMillis += tUnitMsec.longValue());
            long timeOffset = TimeZoneHelper.getDLSTimeOffsetInDefaultTimeZone(jobStartDate, newJobStartDate);
            if (timeOffset != 0L) {
                newJobStartDate.setTime(jobStartDateMillis - timeOffset);
            }
            jobStartDate = newJobStartDate;
        }
        long periodicity = Long.parseLong(numberOfHourMins) * tUnitMsec;
        return new ScheduleTime(jobStartDate, rule.getEndDate(), periodicity);
    }
}

