/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services;

import com.ericsson.cms.scheduler.entities.ScheduleRule;
import com.tandbergtv.cms.services.ScheduleTime;
import com.tandbergtv.cms.services.TimeZoneHelper;
import com.tandbergtv.cms.services.TimerHelper;
import java.util.Date;
import org.apache.log4j.Logger;

public class EveryNWeeks {
    private static int DAYS_IN_WEEK = 7;
    private static long MSEC_IN_ONE_DAY = 86400000L;
    private static final Logger logger = Logger.getLogger(EveryNWeeks.class);

    public static ScheduleTime getTime(Date startDate, String jobTime, String numberOfWeeks, ScheduleRule scheduleRule) {
        if (numberOfWeeks == null) {
            logger.error((Object)"NumberOfWeeks is not specified.");
            return null;
        }
        if (Integer.parseInt(numberOfWeeks) == 0) {
            logger.error((Object)"NumberOfWeeks cannot be 0.");
            return null;
        }
        Date jobStartDate = TimerHelper.getStartDateTime(startDate, jobTime);
        int numberOfDays = Integer.parseInt(numberOfWeeks) * DAYS_IN_WEEK;
        long periodicity = (long)numberOfDays * MSEC_IN_ONE_DAY;
        if (jobStartDate.before(new Date())) {
            long jobStartDateMillis = jobStartDate.getTime();
            Date newJobStartDate = new Date(jobStartDateMillis += periodicity);
            long timeOffset = TimeZoneHelper.getDLSTimeOffsetInDefaultTimeZone(jobStartDate, newJobStartDate);
            if (timeOffset != 0L) {
                newJobStartDate.setTime(jobStartDateMillis - timeOffset);
            }
            jobStartDate = newJobStartDate;
        }
        return new ScheduleTime(jobStartDate, scheduleRule.getEndDate(), periodicity);
    }
}

