/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services;

import com.tandbergtv.cms.services.AuthorizationException;
import com.tandbergtv.cms.services.Authorizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.xml.bind.DatatypeConverter;
import org.apache.log4j.Logger;
import org.jboss.security.client.SecurityClient;
import org.jboss.security.client.SecurityClientFactory;

public class RESTAuthentication {
    private static final Logger logger = Logger.getLogger((String)RESTAuthentication.class.getName());
    private SecurityClient securityClient;
    private LoginInfo loginInfo;

    public RESTAuthentication(String authorizationHeader) {
        this.loginInfo = RESTAuthentication.getLoginInfoForAuthorizationHeader(authorizationHeader);
        this.securityClient = this.login(this.loginInfo);
    }

    public String getUsername() {
        if (this.loginInfo == null) {
            return null;
        }
        return this.loginInfo.getUsername();
    }

    public static RESTAuthentication loginWithoutPermissions(String authorizationHeader, String ... permissions) {
        RESTAuthentication result = new RESTAuthentication(authorizationHeader);
        if (!result.hasAnyPermission(new String[0])) {
            throw new AuthorizationException("Caller is unauthorized to execute operation.");
        }
        return result;
    }

    public static RESTAuthentication loginIfHasAnyOfThePermissions(String authorizationHeader, String ... permissions) {
        RESTAuthentication result = new RESTAuthentication(authorizationHeader);
        if (!result.hasAnyPermission(permissions)) {
            throw new AuthorizationException("Caller is unauthorized to execute operation.");
        }
        return result;
    }

    private boolean hasAllPermissions(String ... permissions) {
        return Authorizer.hasPermissionNoModule(permissions);
    }

    private boolean hasAnyPermission(String ... permissions) {
        String[] stringArray = permissions;
        int n = permissions.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            if (Authorizer.hasPermissionNoModule(p)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static RESTAuthentication loginIfHasAllOfThePermissions(String authorizationHeader, String ... permissions) {
        RESTAuthentication result = new RESTAuthentication(authorizationHeader);
        if (!result.hasAllPermissions(permissions)) {
            throw new AuthorizationException("Caller is unauthorized to execute operation.");
        }
        return result;
    }

    private SecurityClient login(LoginInfo loginInfo) throws AuthorizationException {
        try {
            SecurityClient result = SecurityClientFactory.getSecurityClient();
            result.setSimple((Object)loginInfo.getUsername(), (Object)loginInfo.getPassword());
            result.login();
            return result;
        }
        catch (Exception e) {
            throw new AuthorizationException(e);
        }
    }

    public static LoginInfo getLoginInfoForAuthorizationHeader(String authorizationHeader) {
        if (authorizationHeader == null || !authorizationHeader.toUpperCase().startsWith("BASIC ")) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        String decodedUsernameAndPassword = RESTAuthentication.decodeUsernameAndPassword(authorizationHeader);
        Pattern pattern = Pattern.compile(":.*$");
        Matcher matcher = pattern.matcher(decodedUsernameAndPassword);
        matcher.find();
        String username = decodedUsernameAndPassword.substring(0, matcher.start());
        String password = matcher.group().substring(1);
        return new LoginInfo(username, password);
    }

    private static String decodeUsernameAndPassword(String authorizationHeader) {
        try {
            String encodedUsernameAndPassword = authorizationHeader.substring(6);
            String decodedUsernameAndPassword = new String(DatatypeConverter.parseBase64Binary((String)encodedUsernameAndPassword));
            return decodedUsernameAndPassword;
        }
        catch (Exception e) {
            logger.error((Object)"Error trying to decode authentication header", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    public void logout() {
        this.securityClient.logout();
    }

    public static class LoginInfo {
        String username;
        String password;

        public LoginInfo(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

