/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services;

import com.ericsson.cms.criteria.ExpList;
import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateComplex;
import com.ericsson.cms.criteria.PredicateRightField;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.ericsson.cms.scheduler.entities.ScheduleRule;
import com.ericsson.cms.scheduler.entities.ScheduleRuleParameter;
import com.ericsson.cms.sites.core.entities.Site;
import com.ericsson.cms.sites.core.entities.mediapath.MSO;
import com.tandbergtv.cms.titlefilter.CriteriaMode;
import com.tandbergtv.cms.titlefilter.TitleFilter;
import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.marvin.udt.TreAction;
import com.tandbergtv.marvin.udt.TreActionParameterValue;
import com.tandbergtv.marvin.udt.TreCustomRule;
import com.tandbergtv.marvin.udt.TreCustomRuleParameter;
import com.tandbergtv.marvin.udt.TreEvent;
import com.tandbergtv.marvin.udt.TreEventWrapper;
import com.tandbergtv.marvin.udt.TreMsoOverrrideRuleSet;
import com.tandbergtv.marvin.udt.TrePackage;
import com.tandbergtv.marvin.udt.TreRule;
import com.tandbergtv.marvin.udt.TreRuleSet;
import com.tandbergtv.marvin.udt.TreStandardRule;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;

public class RulesServiceUtils {
    private static IContentClassService contentClassService = (IContentClassService)ServiceRegistry.getDefault().lookup(IContentClassService.class);
    private static final Logger logger = Logger.getLogger((String)RulesServiceUtils.class.getName());
    private static final Integer DEFAULT_IMPORTED_RULESET_INITIAL_VERSION_NUMBER = 0;
    private static final Integer DEFAULT_IMPORTED_PREDICATE_INITIAL_VERSION_NUMBER = 0;
    private static final Integer DEFAULT_IMPORTED_RULE_INITIAL_VERSION_NUMBER = 0;
    public static final String CONTENT_CLASS_ID = "contentClassId";
    public static final String CONTENT_CLASS_NAME = "contentClassName";

    public static void initializeRuleSet(TreRuleSet treRuleSet) {
        logger.debug((Object)("Got treRuleSet : " + treRuleSet));
        TrePackage trePackage = treRuleSet.getTpackage();
        logger.debug((Object)("Got trePackage : " + trePackage));
        Set treEvents = treRuleSet.getEventsHibernate();
        for (TreEventWrapper treEvent : treEvents) {
            logger.debug((Object)("Got treEvent : " + treEvent.getType()));
        }
        if (treRuleSet instanceof TreMsoOverrrideRuleSet) {
            RulesServiceUtils.initialize(((TreMsoOverrrideRuleSet)treRuleSet).getMsos());
        }
        TitleFilter treTitleFilter = treRuleSet.getFilter();
        RulesServiceUtils.initialize(treTitleFilter);
        List treRules = treRuleSet.getRules();
        RulesServiceUtils.initialize(treRules);
        Set sites = treRuleSet.getSites();
        for (Site site : sites) {
            logger.debug((Object)("Got site : " + site));
        }
    }

    private static void initialize(Set<MSO> msos) {
        for (MSO mso : msos) {
            mso.getId();
            mso.getMsoName();
        }
    }

    public static void initialize(TitleFilter titleFilter) {
        logger.debug((Object)("Got titleFilter : " + titleFilter));
        if (titleFilter != null) {
            ExpNode treExpNode = titleFilter.getRootNode();
            RulesServiceUtils.initialize(treExpNode);
        }
    }

    public static void initialize(List<TreRule> rules) {
        logger.debug((Object)("Got rules : " + rules));
        ArrayList<TreRule> treRules = new ArrayList<TreRule>();
        for (TreRule treRule : rules) {
            TreStandardRule treStandardRule;
            ExpNode treExpNodeConditions;
            logger.debug((Object)("Got treRule : " + treRule));
            if (treRule instanceof TreStandardRule && (treExpNodeConditions = (treStandardRule = (TreStandardRule)treRule).getConditions()) != null) {
                RulesServiceUtils.initialize(treExpNodeConditions);
            }
            if (treRule instanceof TreCustomRule) {
                TreCustomRule treCustomRule = (TreCustomRule)treRule;
                List treCustomRuleParameters = treCustomRule.getParameters();
                for (TreCustomRuleParameter treCustomRuleParameter : treCustomRuleParameters) {
                    logger.debug((Object)("Got treCustomRuleParameter : " + treCustomRuleParameter));
                }
            }
            List treActions = treRule.getActions();
            logger.debug((Object)("Got treActions : " + treActions));
            for (TreAction treAction : treActions) {
                logger.debug((Object)("Got treAction : " + treAction));
                List treParams = treAction.getParams();
                for (TreActionParameterValue treParam : treParams) {
                    logger.debug((Object)("Got treParam : " + treParam));
                    String value = treParam.getValue();
                    logger.debug((Object)("Got valueObject : " + value));
                }
            }
            treRules.add(treRule);
        }
    }

    public static void initialize(ExpNode treExpNode) {
        logger.debug((Object)("Got treExpNode : " + treExpNode));
        if (treExpNode != null) {
            if (treExpNode instanceof ExpList) {
                ExpList treExpList = (ExpList)treExpNode;
                List treExpNodes = treExpList.getNodes();
                if (treExpNodes != null) {
                    for (ExpNode childTreExpNode : treExpNodes) {
                        RulesServiceUtils.initialize(childTreExpNode);
                    }
                }
            } else if (treExpNode instanceof ExpValue) {
                Predicate trePredicate = ((ExpValue)treExpNode).getPredicate();
                logger.debug((Object)("Got trePredicate : " + trePredicate));
                RulesServiceUtils.initialize(trePredicate);
            }
        }
    }

    public static void initialize(Predicate trePredicate) {
        logger.debug((Object)("Got trePredicate : " + trePredicate));
        if (trePredicate != null) {
            FieldType fieldTypeLhs = trePredicate.getFieldTypeLhs();
            logger.debug((Object)("Got trePredicate.fieldTypeLhs : " + fieldTypeLhs));
            if (trePredicate instanceof PredicateRightValue) {
                PredicateRightValue trePredicateRightValue = (PredicateRightValue)trePredicate;
                logger.debug((Object)("Got trePredicateRightValue : " + trePredicateRightValue));
                if (trePredicateRightValue.getValue() != null) {
                    for (String value : trePredicateRightValue.getValue()) {
                        logger.debug((Object)("Got trePredicateRightValue.value.value : " + value));
                    }
                }
            } else if (trePredicate instanceof PredicateComplex) {
                PredicateComplex trePredicateComplex = (PredicateComplex)trePredicate;
                logger.debug((Object)("Got trePredicateComplex : " + trePredicateComplex));
                for (Predicate childTrePredicate : trePredicateComplex.getChildren()) {
                    RulesServiceUtils.initialize(childTrePredicate);
                }
            } else if (trePredicate instanceof PredicateRightField) {
                PredicateRightField trePredicateRightField = (PredicateRightField)trePredicate;
                logger.debug((Object)("Got trePredicateRightField : " + trePredicateRightField));
                FieldType fieldTypeRhs = trePredicateRightField.getFieldTypeRhs();
                logger.debug((Object)("Got trePredicateRightField.fieldTypeRhs : " + fieldTypeRhs));
            }
        }
    }

    public static TreRuleSet cleanseRuleSet(TreRuleSet ruleSet) {
        logger.debug((Object)("Got ruleSet : " + ruleSet));
        if (ruleSet != null) {
            ruleSet.setRuleSetId(null);
            ruleSet.setVersion(DEFAULT_IMPORTED_RULESET_INITIAL_VERSION_NUMBER);
            Date now = new Date();
            ruleSet.setCreateDate(now);
            ruleSet.setUpdateDate(now);
            ruleSet.setTpackage(null);
            Set treEvents = ruleSet.getEvents();
            for (TreEvent treEvent : treEvents) {
                logger.debug((Object)("Got treEvent : " + treEvent));
            }
            TitleFilter titleFilter = ruleSet.getFilter();
            RulesServiceUtils.cleanse(titleFilter);
            List treRules = ruleSet.getRules();
            RulesServiceUtils.cleanse(treRules);
            ScheduleRule scheduleRule = ruleSet.getScheduleRule();
            RulesServiceUtils.cleanse(scheduleRule);
        }
        return ruleSet;
    }

    public static TitleFilter cleanse(TitleFilter titleFilter) {
        logger.debug((Object)("Got titleFilter : " + titleFilter));
        if (titleFilter != null) {
            titleFilter.setTitleFilterId(null);
            CriteriaMode criteriaMode = titleFilter.getCriteriaMode();
            if (criteriaMode == null) {
                criteriaMode = CriteriaMode.MASTER;
                titleFilter.setCriteriaMode(criteriaMode);
            }
            ExpNode treExpNode = titleFilter.getRootNode();
            RulesServiceUtils.cleanse(treExpNode);
        }
        return titleFilter;
    }

    public static List<TreRule> cleanse(List<TreRule> rules) {
        logger.debug((Object)("Got rules : " + rules));
        ArrayList<TreRule> treRules = new ArrayList<TreRule>();
        for (TreRule treRule : rules) {
            TreStandardRule treStandardRule;
            ExpNode treExpNodeConditions;
            treRule.setRuleId(null);
            treRule.setVersion(DEFAULT_IMPORTED_RULE_INITIAL_VERSION_NUMBER);
            Date now = new Date();
            treRule.setCreateDate(now);
            treRule.setUpdateDate(now);
            if (treRule instanceof TreStandardRule && (treExpNodeConditions = (treStandardRule = (TreStandardRule)treRule).getConditions()) != null) {
                RulesServiceUtils.cleanse(treExpNodeConditions);
            }
            if (treRule instanceof TreCustomRule) {
                TreCustomRule treCustomRule = (TreCustomRule)treRule;
                List treCustomRuleParameters = treCustomRule.getParameters();
                for (TreCustomRuleParameter treCustomRuleParameter : treCustomRuleParameters) {
                    logger.debug((Object)("Got treCustomRuleParameter : " + treCustomRuleParameter));
                    treCustomRuleParameter.setParameterId(null);
                }
            }
            List treActions = treRule.getActions();
            for (TreAction treAction : treActions) {
                logger.debug((Object)("Got treAction : " + treAction));
                treAction.setActionId(null);
                treAction.setCreateDate(now);
                treAction.setUpdateDate(now);
                List treParams = treAction.getParams();
                for (TreActionParameterValue treParam : treParams) {
                    logger.debug((Object)("Got treParam : " + treParam));
                    treParam.setValueId(null);
                    treParam.setCreateDate(now);
                    treParam.setUpdateDate(now);
                }
            }
            treRules.add(treRule);
        }
        return treRules;
    }

    public static ScheduleRule cleanse(ScheduleRule scheduleRule) {
        logger.debug((Object)("Got scheduleRule : " + scheduleRule));
        if (scheduleRule != null) {
            scheduleRule.setId(null);
            List params = scheduleRule.getParams();
            if (params != null) {
                for (ScheduleRuleParameter scheduleRuleParameter : params) {
                    scheduleRuleParameter.setId(null);
                }
            }
        }
        return scheduleRule;
    }

    public static ExpNode cleanse(ExpNode treExpNode) {
        logger.debug((Object)("Got treExpNode : " + treExpNode));
        if (treExpNode != null) {
            treExpNode.setNodeId(null);
            Date now = new Date();
            treExpNode.setCreateDate(now);
            treExpNode.setUpdateDate(now);
            if (treExpNode instanceof ExpList) {
                ExpList treExpList = (ExpList)treExpNode;
                List treExpNodes = treExpList.getNodes();
                if (treExpNodes != null) {
                    for (ExpNode childTreExpNode : treExpNodes) {
                        RulesServiceUtils.cleanse(childTreExpNode);
                    }
                }
            } else if (treExpNode instanceof ExpValue) {
                Predicate trePredicate = ((ExpValue)treExpNode).getPredicate();
                logger.debug((Object)("Got trePredicate : " + trePredicate));
                RulesServiceUtils.cleanse(trePredicate);
            }
        }
        return treExpNode;
    }

    public static void cleanse(Predicate trePredicate) {
        logger.debug((Object)("Got trePredicate : " + trePredicate));
        if (trePredicate != null) {
            trePredicate.setPredicateId(null);
            Date now = new Date();
            trePredicate.setCreateDate(now);
            trePredicate.setUpdateDate(now);
            trePredicate.setVersion(DEFAULT_IMPORTED_PREDICATE_INITIAL_VERSION_NUMBER);
            if (trePredicate instanceof PredicateRightValue) {
                RulesServiceUtils.cleanseContentClassName((PredicateRightValue)trePredicate);
            } else if (trePredicate instanceof PredicateComplex) {
                PredicateComplex trePredicateComplex = (PredicateComplex)trePredicate;
                logger.debug((Object)("Got trePredicateComplex : " + trePredicateComplex));
                for (Predicate childTrePredicate : trePredicateComplex.getChildren()) {
                    RulesServiceUtils.cleanse(childTrePredicate);
                }
            } else if (trePredicate instanceof PredicateRightField) {
                PredicateRightField trePredicateRightField = (PredicateRightField)trePredicate;
                logger.debug((Object)("Got trePredicateRightField : " + trePredicateRightField));
            }
        }
    }

    private static void cleanseContentClassName(PredicateRightValue trePredicate) {
        if (trePredicate.getValue() == null || !CONTENT_CLASS_NAME.equals(trePredicate.getFieldLeft())) {
            return;
        }
        ArrayList<String> contentIdList = new ArrayList<String>();
        for (String value : trePredicate.getValue()) {
            try {
                if (StringUtils.isNumeric((String)value)) continue;
                Long contentClassId = contentClassService.getContentClassIdByName(value);
                if (contentClassId != null) {
                    contentIdList.add(String.valueOf(contentClassId));
                    continue;
                }
                contentIdList.add(value);
            }
            catch (ContentClassPersistenceException ex) {
                logger.error((Object)("Exception while trying to get content class id by name " + value), (Throwable)ex);
                throw new IllegalArgumentException("Failed to get contentclass by name " + value, ex);
            }
        }
        if (!contentIdList.isEmpty()) {
            trePredicate.setValue(contentIdList);
        }
        trePredicate.setFieldLeft(CONTENT_CLASS_ID);
    }

    public static TreRuleSet copyRuleSetDetails(TreRuleSet copyToRuleSet, TreRuleSet copyFromRuleSet) {
        logger.debug((Object)("Got copyToRuleSet : " + copyToRuleSet + ", copyFromRuleSet = " + copyFromRuleSet));
        copyToRuleSet.setRuleName(copyFromRuleSet.getRuleName());
        if (copyToRuleSet instanceof TreMsoOverrrideRuleSet) {
            ((TreMsoOverrrideRuleSet)copyToRuleSet).setMsos(((TreMsoOverrrideRuleSet)copyFromRuleSet).getMsos());
        }
        copyToRuleSet.setUuid(copyFromRuleSet.getUuid());
        copyToRuleSet.setVersion(copyFromRuleSet.getVersion());
        Date now = new Date();
        copyToRuleSet.setUpdateDate(now);
        copyToRuleSet.setEnabled(copyFromRuleSet.getEnabled());
        copyToRuleSet.setIsEmailNotify(copyFromRuleSet.getIsEmailNotify());
        copyToRuleSet.setRunOnGlobal(copyFromRuleSet.isRunOnGlobal());
        Set copyFromTreEvents = copyFromRuleSet.getEvents();
        for (TreEvent copyFromTreEvent : copyFromTreEvents) {
            logger.debug((Object)("Got copyFromTreEvent : " + copyFromTreEvent));
        }
        copyToRuleSet.setEvents(copyFromTreEvents);
        TitleFilter copyFromTitleFilter = copyFromRuleSet.getFilter();
        copyFromTitleFilter = RulesServiceUtils.cleanse(copyFromTitleFilter);
        copyToRuleSet.setFilter(copyFromTitleFilter);
        List copyToTreRules = copyToRuleSet.getRules();
        List copyFromTreRules = copyFromRuleSet.getRules();
        RulesServiceUtils.cleanse(copyFromTreRules);
        copyToTreRules.clear();
        copyToTreRules.addAll(copyFromTreRules);
        copyToRuleSet.getSites().clear();
        copyToRuleSet.getSites().addAll(copyFromRuleSet.getSites());
        ScheduleRule copyFromScheduleRule = copyFromRuleSet.getScheduleRule();
        copyToRuleSet.setScheduleRule(copyFromScheduleRule);
        copyToRuleSet.setIgnoreInvalidSchedule(copyFromRuleSet.isIgnoreInvalidSchedule());
        return copyToRuleSet;
    }

    private static void renameContentClass(ExpNode treExpNode) {
        if (treExpNode == null) {
            return;
        }
        if (treExpNode instanceof ExpList) {
            ExpList treExpList = (ExpList)treExpNode;
            List treExpNodes = treExpList.getNodes();
            if (treExpNodes == null) {
                return;
            }
            for (ExpNode childTreExpNode : treExpNodes) {
                RulesServiceUtils.renameContentClass(childTreExpNode);
            }
        }
        RulesServiceUtils.convertContentClassIdToName(treExpNode);
    }

    public static void renameContentClass(TreRuleSet treRuleSet) {
        List ruleList;
        TitleFilter treTitleFilter = treRuleSet.getFilter();
        if (treTitleFilter != null) {
            ExpNode treExpNode = treTitleFilter.getRootNode();
            RulesServiceUtils.renameContentClass(treExpNode);
        }
        if ((ruleList = treRuleSet.getRules()) == null) {
            return;
        }
        for (TreRule rule : ruleList) {
            if (!(rule instanceof TreStandardRule)) continue;
            ExpNode treExpNode = ((TreStandardRule)rule).getConditions();
            RulesServiceUtils.renameContentClass(treExpNode);
        }
    }

    private static void convertContentClassIdToName(ExpNode treExpNode) {
        if (!(treExpNode instanceof ExpValue)) {
            return;
        }
        Predicate trePredicate = ((ExpValue)treExpNode).getPredicate();
        if (trePredicate == null || !(trePredicate instanceof PredicateRightValue)) {
            return;
        }
        PredicateRightValue trePredicateRightValue = (PredicateRightValue)trePredicate;
        if (!CONTENT_CLASS_ID.equals(trePredicateRightValue.getFieldLeft()) || trePredicateRightValue.getValue() == null) {
            return;
        }
        ArrayList<String> contentClassNameList = new ArrayList<String>();
        for (String value : trePredicateRightValue.getValue()) {
            try {
                Long contentClassId = NumberUtils.toLong((String)value, (long)-1L);
                if (contentClassId != -1L) {
                    ContentClass contentClass = contentClassService.getContentClassById(contentClassId.longValue());
                    contentClassNameList.add(contentClass.getName());
                    continue;
                }
                contentClassNameList.add(value);
            }
            catch (ContentClassPersistenceException ex) {
                logger.error((Object)("Exception while trying to get content class by Id " + value), (Throwable)ex);
                throw new IllegalArgumentException("Failed to get content class by Id" + value, ex);
            }
        }
        if (!contentClassNameList.isEmpty()) {
            trePredicateRightValue.setFieldLeft(CONTENT_CLASS_NAME);
            trePredicateRightValue.setValue(contentClassNameList);
        }
    }
}

