/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.health;

import com.tandbergtv.cms.services.health.Cluster;
import com.tandbergtv.cms.services.health.ICMSHealthService;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;

public class CMSHealthService
implements ICMSHealthService {
    private static final String NO_CACHE = "NO-CACHE";
    private static Logger logger = Logger.getLogger(ICMSHealthService.class);
    private IPartnerManagement partnerManager = (IPartnerManagement)ServiceRegistry.getDefault().lookup(IPartnerManagement.class);

    @Override
    public Response getHealth(HttpServletRequest servletRequest, Request request) {
        Response.ResponseBuilder builder = null;
        if (this.canConnectToDatabase()) {
            String response = "CMS alive and reachable , master = " + Cluster.isMaster() + "\n" + Cluster.getMembersAdresses();
            builder = Response.ok((Object)response, (String)"text/plain").header("Cache-Control", (Object)NO_CACHE);
        } else {
            builder = Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE);
        }
        return builder.build();
    }

    private boolean canConnectToDatabase() {
        try {
            this.partnerManager.getNumberOfTenants();
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)"Getting CMS health error ", (Throwable)ex);
            return false;
        }
    }
}

