/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.snmp;

import java.lang.management.ManagementFactory;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.Logger;

public class JMXClient {
    private static JMXClient _jmxClient = null;
    private static Logger logger = Logger.getLogger(JMXClient.class);
    private MBeanServer server = ManagementFactory.getPlatformMBeanServer();

    private JMXClient() {
    }

    public static JMXClient getInstance() {
        if (_jmxClient == null) {
            _jmxClient = new JMXClient();
        }
        return _jmxClient;
    }

    public int getIntAttributeVal(String mbeanName, String attribute) {
        Object obj = this.getMbeanAttribute(mbeanName, attribute);
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return 0;
    }

    public long getLongAttributeVal(String mbeanName, String attribute) {
        Object obj = this.getMbeanAttribute(mbeanName, attribute);
        if (obj instanceof Long) {
            return (Long)obj;
        }
        return 0L;
    }

    public double getDoubleAttributeVal(String mbeanName, String attribute) {
        Object obj = this.getMbeanAttribute(mbeanName, attribute);
        if (obj instanceof Double) {
            return (Double)obj;
        }
        return 0.0;
    }

    public Object getMbeanAttribute(String mbeanName, String attribute) {
        try {
            ObjectName name = new ObjectName(mbeanName);
            if (name != null && this.server != null && this.server.getAttribute(name, attribute) != null) {
                return this.server.getAttribute(name, attribute);
            }
        }
        catch (Exception ex) {
            logger.warn((Object)("[Monitoring Error] Unable to retrieve attribute: " + attribute + " for MBean:" + mbeanName), (Throwable)ex);
        }
        return null;
    }

    public Object getMbeanAttribute(ObjectName mbean, String attribute) {
        try {
            if (mbean != null) {
                return this.server.getAttribute(mbean, attribute);
            }
        }
        catch (Exception ex) {
            logger.warn((Object)("[Monitoring Error] Unable to retrieve attribute: " + attribute + " for MBean:" + mbean.getCanonicalName()), (Throwable)ex);
        }
        return null;
    }

    public MBeanServer getMBeanServer() {
        return this.server;
    }

    public ObjectName getMbeanByPattern(String pattern) {
        MBeanServer server = JMXClient.getInstance().getMBeanServer();
        try {
            Set<ObjectName> objects = server.queryNames(null, new ObjectName(pattern));
            if (objects != null && objects.size() != 0) {
                Iterator<ObjectName> i = objects.iterator();
                ObjectName obj = i.next();
                logger.debug((Object)("Located MBean:" + obj.getCanonicalName()));
                return obj;
            }
        }
        catch (Exception ex) {
            logger.warn((Object)("[Monitoring Error] Unable to locate MBean " + pattern), (Throwable)ex);
        }
        return null;
    }
}

