/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.tenant;

import com.tandbergtv.cms.services.AuthorizationException;
import com.tandbergtv.cms.services.tenant.ITenantService;
import com.tandbergtv.cms.services.util.ConversionUtil;
import com.tandbergtv.cms.util.ResponseTypeUtilities;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerUserManager;
import java.util.List;
import javax.ejb.EJBAccessException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONObject;
import org.w3c.dom.Document;

public class TenantService
implements ITenantService {
    private static Logger logger = Logger.getLogger(TenantService.class);
    private static final String NO_CACHE = "NO-CACHE";
    private IPartnerUserManager partnerService = (IPartnerUserManager)InjectionUtil.injectInstance((String)"cms/PartnerUserManager/local", IPartnerUserManager.class);

    @Override
    public Response getTenantAccess(Request request) {
        try {
            boolean isAllowed = this.checkAllowed(this.partnerService.getDirectPartnersByCurrentUser());
            MediaType type = ResponseTypeUtilities.getMediaTypeFromRequest(request);
            if (type == MediaType.APPLICATION_JSON_TYPE) {
                return Response.ok((Object)this.createJson(isAllowed).toString(), (String)"application/json").header("Cache-Control", (Object)NO_CACHE).build();
            }
            return Response.ok((Object)ConversionUtil.serialize(this.createXML(isAllowed)), (String)"application/xml").header("Cache-Control", (Object)NO_CACHE).build();
        }
        catch (AuthorizationException e) {
            logger.error((Object)"error", (Throwable)e);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type("text/plain").build();
        }
        catch (EJBAccessException e) {
            logger.error((Object)"error", (Throwable)e);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type("text/plain").build();
        }
        catch (Exception e) {
            logger.error((Object)"error", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).type("text/plain").build();
        }
    }

    private boolean checkAllowed(List<Partner> partners) {
        if (partners == null) {
            return false;
        }
        boolean isAllowed = false;
        for (Partner p : partners) {
            if (p.getIsTenant() == null || !p.getIsTenant().booleanValue()) continue;
            isAllowed = true;
            break;
        }
        return isAllowed;
    }

    private JSONObject createJson(boolean isAllowed) throws Exception {
        JSONObject obj = new JSONObject();
        obj.put("tenantAccessAllowed", isAllowed);
        return obj;
    }

    private Document createXML(boolean isAllowed) throws Exception {
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = db.newDocument();
        doc.appendChild(ConversionUtil.createChild("tenantAccessAllowed", String.valueOf(isAllowed), doc));
        return doc;
    }
}

