/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.titles;

import com.tandbergtv.cms.services.titles.ResponseUtil;
import com.tandbergtv.cms.services.titles.TitleServiceNG;
import java.util.Objects;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class JsonResponseBuilder {
    private static final Logger LOGGER = Logger.getLogger(TitleServiceNG.class);
    private boolean isOk = true;
    private String msg;
    private Long titleId;
    private Long workOrderId;
    private String eventType;
    private String errorMsg;
    private Integer statusCode;

    private JsonResponseBuilder() {
    }

    public static JsonResponseBuilder newInstance() {
        return new JsonResponseBuilder();
    }

    public JsonResponseBuilder setTitle(Long titleId) {
        this.titleId = titleId;
        return this;
    }

    public JsonResponseBuilder setOk(boolean isOk) {
        this.isOk = isOk;
        return this;
    }

    public JsonResponseBuilder setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    public JsonResponseBuilder setWorkOrderId(Long workOrderId) {
        this.workOrderId = workOrderId;
        return this;
    }

    public JsonResponseBuilder setEventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    public JsonResponseBuilder setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
        return this;
    }

    public JsonResponseBuilder setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public Response build() {
        JSONObject json = new JSONObject();
        try {
            json.put("titleId", (Object)this.titleId);
            if (!Objects.isNull(this.workOrderId)) {
                json.put("workOrderId", (Object)this.workOrderId);
            }
            if (!Objects.isNull(this.eventType)) {
                json.put("eventType", (Object)this.eventType);
            }
            if (!Objects.isNull(this.statusCode)) {
                json.put("statusCode", (Object)this.statusCode);
            }
            if (!Objects.isNull(this.errorMsg)) {
                json.put("error", (Object)this.errorMsg);
            }
            if (!Objects.isNull(this.msg)) {
                json.put("msg", (Object)this.msg);
            }
            if (this.isOk) {
                return ResponseUtil.createJsonOkResponse(json);
            }
            return ResponseUtil.createBadRequestJsonResponse(json);
        }
        catch (JSONException e) {
            LOGGER.error((Object)"JSON Exception.", (Throwable)e);
            return ResponseUtil.createInternalServerErrorResponse(e.getMessage());
        }
    }
}

