/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services;

import com.tandbergtv.cms.services.IContentClassService;
import com.tandbergtv.cms.services.resources.Errors;
import com.tandbergtv.cms.util.EndpointsAuthorizationUtil;
import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.entities.ContentClassPartner;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.beans.XMLEncoder;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.springframework.util.CollectionUtils;

public class ContentClassService
implements IContentClassService {
    private static final String PERMISSION_CONTENT_CLASS_EXPORT = "ContentClassManagement_View";
    private static final String PERMISSION_CONTENT_CLASS_IMPORT_CREATE = "ContentClassManagement_Create";
    private static final String PERMISSION_CONTENT_CLASS_IMPORT_MODIFY = "ContentClassManagement_Modify";
    private static final String XML_MEDIA = "application/xml";

    @Override
    public Response contentClassExport(HttpServletRequest servletRequest) {
        Response.ResponseBuilder builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, null, PERMISSION_CONTENT_CLASS_EXPORT);
        if (builder != null) {
            return builder.build();
        }
        Errors errors = new Errors();
        String xml = null;
        String id = servletRequest.getParameter("id");
        boolean partner = Boolean.parseBoolean(servletRequest.getParameter("partner"));
        try {
            id = id.trim();
            long lid = 0L;
            try {
                lid = Long.parseLong(id);
            }
            catch (Exception exception) {
                errors.getErrors().add("Error: Invalid content class id: " + id);
                builder = Response.ok((Object)errors);
                return builder.build();
            }
            com.tandbergtv.content.contentclass.service.IContentClassService ccService = this.getContentClassService();
            ContentClass contentClassExport = ccService.getContentClassById(lid);
            if (partner) {
                List partners = ccService.getContentClassPartnersByContentClassId(lid, true, false);
                xml = ccService.marshalContentClassWithPartners(contentClassExport, partners);
            } else {
                xml = ccService.marshalContentClass(contentClassExport);
            }
        }
        catch (Exception ex) {
            StringWriter strWriter = new StringWriter();
            PrintWriter writer = new PrintWriter(strWriter);
            ex.printStackTrace(writer);
            errors.getErrors().add("Error: " + strWriter.toString());
            builder = Response.ok((Object)errors);
            return builder.build();
        }
        builder = Response.ok((Object)xml).type(XML_MEDIA);
        return builder.build();
    }

    private void saveContentClass(ContentClass cc) throws Exception {
        com.tandbergtv.content.contentclass.service.IContentClassService ccService = this.getContentClassService();
        Long id = ccService.getContentClassIdByName(cc.getName());
        if (id != null) {
            cc.setId(id.longValue());
        }
        if ("Default".equals(cc.getName())) {
            cc.setDefault(true);
        }
        ccService.saveContentClass(cc);
    }

    @Override
    public Response contentClassImport(HttpServletRequest servletRequest) {
        Response.ResponseBuilder builder;
        block6: {
            builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, null, PERMISSION_CONTENT_CLASS_IMPORT_CREATE, PERMISSION_CONTENT_CLASS_IMPORT_MODIFY);
            if (builder != null) {
                return builder.build();
            }
            String partner = servletRequest.getParameter("partner");
            String xml = servletRequest.getParameter("xml");
            Errors errors = new Errors();
            try {
                if ("ignore".equalsIgnoreCase(partner)) {
                    builder = Response.ok((Object)this.doIgnore(xml));
                    break block6;
                }
                if ("updateExisting".equalsIgnoreCase(partner)) {
                    builder = Response.ok((Object)this.doUpdateExisting(xml));
                    break block6;
                }
                if ("createAndUpdate".equalsIgnoreCase(partner)) {
                    builder = Response.ok((Object)this.doCreateAndUpdate(xml));
                    break block6;
                }
                errors.getErrors().add("Invalid partner option: " + partner);
                builder = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errors);
                return builder.build();
            }
            catch (Exception ex) {
                StringWriter strWriter = new StringWriter();
                PrintWriter writer = new PrintWriter(strWriter);
                ex.printStackTrace(writer);
                errors.getErrors().add(strWriter.toString());
                builder = Response.serverError().entity((Object)errors);
            }
        }
        return builder.build();
    }

    private String doIgnore(String xml) throws Exception {
        com.tandbergtv.content.contentclass.service.IContentClassService ccService = this.getContentClassService();
        ContentClass ccImport = ccService.unmarshalContentClass(xml);
        this.saveContentClass(ccImport);
        return "The content class " + ccImport.getName() + " was imported successfully";
    }

    private String doUpdateExisting(String xml) throws Exception {
        com.tandbergtv.content.contentclass.service.IContentClassService ccService = this.getContentClassService();
        StringBuilder partnersMessage = new StringBuilder();
        ArrayList partnersToImport = new ArrayList();
        ContentClass ccImport = ccService.unmarshalContentClassWithPartners(xml, partnersToImport);
        this.saveContentClass(ccImport);
        List partnersToUpdate = ccService.getContentClassPartnersByContentClassId(ccImport.getId(), false, false);
        if (!CollectionUtils.isEmpty((Collection)partnersToUpdate)) {
            for (ContentClassPartner cp : partnersToUpdate) {
                for (ContentClassPartner cpI : partnersToImport) {
                    Long pid;
                    if (!cpI.getContentClassName().equals(cp.getContentClassName()) || !cpI.getPartnerName().equals(cp.getPartnerName())) continue;
                    if (cpI.getMetadata() != null) {
                        cp.setMetadata(cpI.getMetadata());
                    }
                    if (cpI.getPartnerName() != null) {
                        cp.setPartnerName(cpI.getPartnerName());
                    }
                    if ((pid = ccService.getPartnerIdByName(cpI.getPartnerName())) != null) {
                        cpI.setPartnerId(pid.longValue());
                    }
                    ccService.saveContentClassPartner(cp);
                    partnersMessage.append(cpI.getPartnerName()).append(" ");
                }
            }
        }
        return "The content class " + ccImport.getName() + " was imported successfully with the following partners:" + partnersMessage.toString();
    }

    private String doCreateAndUpdate(String xml) throws Exception {
        com.tandbergtv.content.contentclass.service.IContentClassService ccService = this.getContentClassService();
        StringBuilder partnersMessage = new StringBuilder();
        ArrayList partnersToImport = new ArrayList();
        ContentClass ccImport = ccService.unmarshalContentClassWithPartners(xml, partnersToImport);
        this.saveContentClass(ccImport);
        for (ContentClassPartner cc : partnersToImport) {
            Long partnerId = ccService.getPartnerIdByName(cc.getPartnerName());
            if (partnerId == null) {
                throw new Exception("Content Class " + ccImport.getName() + ": Partner with name " + cc.getPartnerName() + " doesn't exist.");
            }
            cc.setContentClassId(ccImport.getId());
            cc.setPartnerId(partnerId.longValue());
            ccService.saveContentClassPartner(cc);
            partnersMessage.append(cc.getPartnerName()).append(" ");
        }
        return "The content class " + ccImport.getName() + " was imported successfully with the following partners: " + partnersMessage.toString();
    }

    @Override
    public Response getContentClassIds(HttpServletRequest servletRequest) {
        Response.ResponseBuilder builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, null, PERMISSION_CONTENT_CLASS_EXPORT);
        if (builder != null) {
            return builder.build();
        }
        Errors errors = new Errors();
        ArrayList<Long> contentClassIDList = new ArrayList<Long>();
        try {
            com.tandbergtv.content.contentclass.service.IContentClassService ccService = this.getContentClassService();
            List contentClassList = ccService.getAllContentClassesWithoutMetadata();
            for (ContentClass cc : contentClassList) {
                contentClassIDList.add(cc.getId());
            }
        }
        catch (Exception ex) {
            errors.getErrors().add("Exception occurred getting Content Class Ids : " + ex.getMessage());
            builder = Response.serverError().entity((Object)errors);
            return builder.build();
        }
        builder = Response.ok((Object)((Object)contentClassIDList).toString());
        return builder.build();
    }

    @Override
    public Response getContentClassTypes(HttpServletRequest servletRequest) {
        Response.ResponseBuilder builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, null, PERMISSION_CONTENT_CLASS_EXPORT);
        if (builder != null) {
            return builder.build();
        }
        Errors errors = new Errors();
        HashMap<Integer, String> contentClassTypes = new HashMap<Integer, String>();
        try {
            ContentClass.Type[] typeArray = ContentClass.Type.values();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ContentClass.Type ccType = typeArray[n2];
                contentClassTypes.put(ccType.ordinal(), ccType.toString());
                ++n2;
            }
        }
        catch (Exception ex) {
            errors.getErrors().add("Exception occurred getting Content Class Types : " + ex.getMessage());
            builder = Response.serverError().entity((Object)errors);
            return builder.build();
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLEncoder xmlEncoder = new XMLEncoder(bos);
        xmlEncoder.writeObject(contentClassTypes);
        xmlEncoder.close();
        String serializedMap = bos.toString();
        builder = Response.ok((Object)serializedMap);
        return builder.build();
    }

    private com.tandbergtv.content.contentclass.service.IContentClassService getContentClassService() throws Exception {
        return (com.tandbergtv.content.contentclass.service.IContentClassService)InjectionUtil.injectInstance((String)"cms/ContentClassService/local", com.tandbergtv.content.contentclass.service.IContentClassService.class);
    }
}

