/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services;

import com.tandbergtv.cms.services.ICustomFieldsService;
import com.tandbergtv.cms.services.resources.Errors;
import com.tandbergtv.cms.util.EndpointsAuthorizationUtil;
import com.tandbergtv.content.contentclass.service.ICustomFieldManager;
import com.tandbergtv.metadatamanager.customfield.model.CustomField;
import com.tandbergtv.metadatamanager.customfield.model.CustomFieldGroup;
import com.tandbergtv.metadatamanager.customfield.model.CustomFields;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;

public class CustomFieldsService
implements ICustomFieldsService {
    private static final Logger logger = Logger.getLogger((String)CustomFieldsService.class.getName());
    private static final String XML_MEDIA = "application/xml";
    private static final String CUSTOM_FIELDS_EXPORT = "CustomFieldsAdministration_View";
    private static final String CUSTOM_FIELDS_IMPORT = "CustomFieldsAdministration_Administer";

    @Override
    public Response customFieldsExport(HttpServletRequest servletRequest) {
        Response.ResponseBuilder builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, null, CUSTOM_FIELDS_EXPORT);
        if (builder != null) {
            return builder.build();
        }
        Errors errors = new Errors();
        CustomFields customFields = new CustomFields();
        try {
            ICustomFieldManager manager = (ICustomFieldManager)ServiceRegistry.getDefault().lookup(ICustomFieldManager.class);
            List customFieldGroupList = manager.getAllGroups();
            customFields.setCustomFieldGroups(customFieldGroupList);
        }
        catch (Exception e) {
            errors.getErrors().add("Exception occurred getting custom fields : " + e.getMessage());
            builder = Response.serverError().entity((Object)errors);
            return builder.build();
        }
        builder = Response.ok((Object)customFields).type(XML_MEDIA);
        logger.info((Object)"Finished exporting custom fields ");
        return builder.build();
    }

    private static void setGroupId(List<CustomFieldGroup> customFieldGroups) {
        if (customFieldGroups != null) {
            for (CustomFieldGroup group : customFieldGroups) {
                List fieldList = group.getCustomFieldList();
                if (fieldList == null) continue;
                for (CustomField field : fieldList) {
                    field.setGroup(group);
                }
            }
        }
    }

    @Override
    public Response customFieldsImport(HttpServletRequest servletRequest) {
        Response.ResponseBuilder builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, null, CUSTOM_FIELDS_IMPORT);
        if (builder != null) {
            return builder.build();
        }
        Errors errors = new Errors();
        CustomFields customFields = null;
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{CustomFields.class});
            Unmarshaller u = jc.createUnmarshaller();
            customFields = (CustomFields)u.unmarshal((InputStream)servletRequest.getInputStream());
        }
        catch (Exception exception) {
            builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
            return builder.build();
        }
        int isError = 0;
        try {
            ICustomFieldManager manager = (ICustomFieldManager)ServiceRegistry.getDefault().lookup(ICustomFieldManager.class);
            List groupList = customFields.getCustomFieldGroups();
            if (groupList != null) {
                this.checkUniqueNameWithinGroup(groupList);
                this.getRidOfIds(groupList);
                CustomFieldsService.setGroupId(groupList);
                isError = manager.saveImportedCustomFields(groupList);
            }
        }
        catch (Exception e) {
            errors.getErrors().add("Exception occurred importing custom fields : " + e.getMessage());
            builder = Response.serverError().entity((Object)errors);
            return builder.build();
        }
        logger.info((Object)"Finished importing custom fields ");
        if (isError == 0) {
            builder = Response.ok();
        } else {
            errors.getErrors().add("One more fields/groups failed to import. Please Check logs for more details.");
            builder = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errors);
        }
        return builder.build();
    }

    private void getRidOfIds(List<CustomFieldGroup> groupList) {
        for (CustomFieldGroup group : groupList) {
            group.setId(null);
            List cfList = group.getCustomFieldList();
            if (cfList == null) continue;
            for (CustomField cf : cfList) {
                cf.setId(null);
                this.validateJobScheduleParameter(cf);
            }
        }
    }

    private void validateJobScheduleParameter(CustomField field) {
        if (field != null && field.getJobScheduleParameter() != null && !field.getDataType().equalsIgnoreCase("Date") && field.getJobScheduleParameter().equalsIgnoreCase("Y")) {
            field.setJobScheduleParameter("N");
            logger.info((Object)"Forcing the jobScheduleParameter to N: JobScheduleParameter can't not be set to Y if field type is not a date.");
        }
    }

    private void checkUniqueNameWithinGroup(List<CustomFieldGroup> groupList) {
        for (CustomFieldGroup group : groupList) {
            List fieldList = group.getCustomFieldList();
            if (fieldList == null) continue;
            ArrayList<String> usedNames = new ArrayList<String>();
            for (CustomField field : fieldList) {
                if (usedNames.contains(field.getName())) {
                    throw new RuntimeException("Duplicate fieldname " + field.getName() + " is within CustomFieldGroup: " + group.getDisplayName());
                }
                usedNames.add(field.getName());
            }
        }
    }
}

