/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services;

import com.ericsson.cms.criteria.FieldType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.tandbergtv.cms.data.RuleSetResourceList;
import com.tandbergtv.cms.data.SummaryRuleSet;
import com.tandbergtv.cms.data.SummaryRuleSetResourceList;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.cms.rules.service.category.IRuleManager;
import com.tandbergtv.cms.rules.service.category.IRuleManagerCache;
import com.tandbergtv.cms.rules.service.category.TreRuleSetCachable;
import com.tandbergtv.cms.services.IRuleServiceNG;
import com.tandbergtv.cms.services.JsonCommonDateFormatSerializer;
import com.tandbergtv.cms.services.resources.Errors;
import com.tandbergtv.cms.services.titles.FieldAlias;
import com.tandbergtv.cms.services.titles.FieldAliases;
import com.tandbergtv.cms.services.util.ContentTypeUtil;
import com.tandbergtv.cms.util.EndpointsAuthorizationUtil;
import com.tandbergtv.marvin.services.RuleFullTextMigrationService;
import com.tandbergtv.marvin.udt.TreRuleSet;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.naming.InitialContext;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.TransactionManager;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;

public class RuleServiceNG
implements IRuleServiceNG {
    private static final String DETAIL_FULL = "Full";
    private static final String PERMISSION_RULES_EXPORT = "RulesManagement_View";
    private static final Logger LOGGER = Logger.getLogger(RuleServiceNG.class);
    private static final String BUILD_XML_ERROR_MSG = "Error when building xml response.";
    private static final String BUILD_JSON_ERROR_MSG = "Error when building JSON response.";
    private static final String INVALID_RULE_SET_ID_MSG = "Error when getting rule set with rule set ID %s";
    private static final String INVALID_FILTER_MSG = "Invalid filter format. Use format \"[field]:[operator]:[value]\".";
    private static final String MIGRATE_ERROR_MSG = "Not all rule sets have been migrated to support this feature, please try again later.";
    private static final String DB_ERROR_MSG = "Error when retrieving data.";
    private static final String PACKAGE_EMPTY_ERROR_MSG = "package is required.";
    private static final String UPSUPPORT_MEDIA_TYPE_ERROR_MSG = "Unsupported media type: %s";
    private static final String ECMF_SPEC_PREFIX = "/ECMFSpec/";
    private IRuleManager ruleManager;
    private IRuleManagerCache ruleManagerCache;
    private JAXBContext jc;
    private final ObjectMapper objectMapper = this.getObjectMapper();
    private final FieldAliases aliases = FieldAliases.getInstance();
    private static /* synthetic */ Annotation ajc$anno$0;

    @Override
    @Transactional
    public Response list(HttpServletRequest servletRequest, UriInfo uriInfo, String accept, String packageName, String keywords, String metadataField, String filter, String detail) {
        HttpServletRequest httpServletRequest = servletRequest;
        UriInfo uriInfo2 = uriInfo;
        String string = accept;
        String string2 = packageName;
        String string3 = keywords;
        String string4 = metadataField;
        String string5 = filter;
        String string6 = detail;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = RuleServiceNG.class.getDeclaredMethod("list", HttpServletRequest.class, UriInfo.class, String.class, String.class, String.class, String.class, String.class, String.class).getAnnotation(Transactional.class);
        }
        return (Response)RuleServiceNG.list_aroundBody1$advice(this, httpServletRequest, uriInfo2, string, string2, string3, string4, string5, string6, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    public Response get(HttpServletRequest servletRequest, String accept, Integer ruleSetId) {
        Response errorResponse = this.validateParam(servletRequest, accept);
        if (errorResponse != null) {
            return errorResponse;
        }
        if (Objects.isNull(ruleSetId)) {
            return this.buildErrorResponse(String.format(INVALID_RULE_SET_ID_MSG, ruleSetId), Response.Status.BAD_REQUEST);
        }
        TreRuleSetCachable ruleSetCachable = this.getRuleManagerCache().getRuleSet(ruleSetId);
        if (Objects.isNull(ruleSetCachable)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if ("application/xml".equalsIgnoreCase(accept)) {
            return Response.ok((Object)ruleSetCachable.getRuleSet()).type("application/xml").build();
        }
        return this.buildJsonResponse(ruleSetCachable.getRuleSet());
    }

    private Response validateParam(HttpServletRequest servletRequest, String accept) {
        Response.ResponseBuilder builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, null, PERMISSION_RULES_EXPORT);
        if (builder != null) {
            return builder.build();
        }
        if (!ContentTypeUtil.validContentType(accept)) {
            return this.buildErrorResponse(String.format(UPSUPPORT_MEDIA_TYPE_ERROR_MSG, accept), Response.Status.BAD_REQUEST);
        }
        return null;
    }

    private Response buildListResponse(UriInfo uriInfo, String accept, String packageName, String detail, Boolean status, String searchText) {
        List ruleSetList = null;
        try {
            ruleSetList = this.getRuleManager().getRuleSets(packageName, status, searchText);
        }
        catch (Exception e) {
            LOGGER.error((Object)DB_ERROR_MSG, (Throwable)e);
            return this.buildErrorResponse(DB_ERROR_MSG, Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (Objects.isNull(ruleSetList) || ruleSetList.isEmpty()) {
            return Response.ok((Object)new RuleSetResourceList()).type(accept).build();
        }
        String baseUri = uriInfo.getBaseUri().toString();
        if (DETAIL_FULL.equalsIgnoreCase(detail)) {
            return this.buildFullResponse(accept, baseUri, ruleSetList);
        }
        return this.buildSummaryResponse(accept, baseUri, ruleSetList);
    }

    private Response buildFullResponse(String accept, String baseUri, List<TreRuleSet> ruleSetList) {
        RuleSetResourceList resourceList = new RuleSetResourceList();
        ruleSetList.forEach(ruleSet -> {
            ruleSet.setHref(this.buildHref(baseUri, ruleSet.getRuleSetId()));
            resourceList.getRuleSets().add((TreRuleSet)ruleSet);
        });
        if ("application/xml".equalsIgnoreCase(accept)) {
            return this.buildXmlResponse(resourceList);
        }
        return this.buildJsonResponse(resourceList);
    }

    private Response buildSummaryResponse(String accept, String baseUri, List<TreRuleSet> ruleSetList) {
        List<SummaryRuleSet> summaryRuleSetList = this.buildSummaryRuleSetList(baseUri, ruleSetList);
        SummaryRuleSetResourceList resourceList = new SummaryRuleSetResourceList();
        summaryRuleSetList.forEach(resourceList.getRuleSets()::add);
        if ("application/xml".equalsIgnoreCase(accept)) {
            return Response.ok((Object)resourceList).type("application/xml").build();
        }
        return this.buildJsonResponse(resourceList);
    }

    private IRuleManager getRuleManager() {
        if (Objects.isNull(this.ruleManager)) {
            this.ruleManager = (IRuleManager)InjectionUtil.injectInstance((String)"cms/RuleManagerImpl/local", IRuleManager.class);
        }
        return this.ruleManager;
    }

    private Boolean isRuleSetEnabled(String filter) {
        Boolean isRuleSetEnabled = null;
        if (StringUtils.isBlank((String)filter)) {
            return isRuleSetEnabled;
        }
        String[] strs = filter.split(":");
        if (strs.length != 3 || !"enable".equals(strs[0]) || !"EQUALS".equals(strs[1])) {
            throw new IllegalArgumentException(String.format(INVALID_FILTER_MSG, filter));
        }
        return Boolean.valueOf(strs[2]);
    }

    private String buildHref(String baseUri, Integer ruleSetId) {
        return baseUri + "rules/" + ruleSetId;
    }

    private List<SummaryRuleSet> buildSummaryRuleSetList(String baseUri, List<TreRuleSet> ruleSetList) {
        ArrayList<SummaryRuleSet> summaryRuleSetList = new ArrayList<SummaryRuleSet>();
        for (TreRuleSet ruleSet : ruleSetList) {
            SummaryRuleSet summaryRuleSet = new SummaryRuleSet();
            summaryRuleSet.setRuleName(ruleSet.getRuleName());
            summaryRuleSet.setRuleSetId(ruleSet.getRuleSetId());
            summaryRuleSet.setRuleSetPackage(ruleSet.getTpackage());
            summaryRuleSet.setUuid(ruleSet.getUuid().toString());
            summaryRuleSet.setHref(this.buildHref(baseUri, ruleSet.getRuleSetId()));
            summaryRuleSetList.add(summaryRuleSet);
        }
        return summaryRuleSetList;
    }

    private JAXBContext getJAXBContext() throws JAXBException {
        if (Objects.isNull(this.jc)) {
            this.jc = JAXBContext.newInstance((Class[])new Class[]{RuleSetResourceList.class});
        }
        return this.jc;
    }

    private Response buildXmlResponse(RuleSetResourceList resourceList) {
        StringWriter writer = new StringWriter();
        try {
            this.getJAXBContext().createMarshaller().marshal((Object)resourceList, (Writer)writer);
        }
        catch (JAXBException e) {
            LOGGER.error((Object)BUILD_XML_ERROR_MSG, (Throwable)e);
            return this.buildErrorResponse(BUILD_XML_ERROR_MSG, Response.Status.INTERNAL_SERVER_ERROR);
        }
        return Response.ok((Object)writer.toString()).type("application/xml").build();
    }

    private IRuleManagerCache getRuleManagerCache() {
        if (Objects.isNull(this.ruleManagerCache)) {
            this.ruleManagerCache = (IRuleManagerCache)InjectionUtil.injectInstance((String)"cms/RuleManagerCache/local", IRuleManagerCache.class);
        }
        return this.ruleManagerCache;
    }

    private ObjectMapper getObjectMapper() {
        SimpleModule module = new SimpleModule();
        module.addSerializer(Date.class, (JsonSerializer)new JsonCommonDateFormatSerializer());
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.WRAP_ROOT_VALUE);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        mapper.registerModule((Module)module);
        return mapper;
    }

    private Response buildErrorResponse(String msg, Response.Status status) {
        Errors errors = new Errors();
        errors.getErrors().add(msg);
        return Response.status((Response.Status)status).entity((Object)errors).build();
    }

    private Response buildJsonResponse(Object object) {
        try {
            return Response.ok((Object)this.objectMapper.writeValueAsString(object)).type("application/json").build();
        }
        catch (JsonProcessingException e) {
            LOGGER.error((Object)BUILD_JSON_ERROR_MSG, (Throwable)e);
            return this.buildErrorResponse(BUILD_JSON_ERROR_MSG, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private String handleAlias(String metadataField) {
        FieldAlias fieldAlias = this.aliases.getFieldAlias(metadataField);
        String assetType = fieldAlias.getAssetType();
        String field = fieldAlias.getField();
        if (!StringUtils.isEmpty((String)assetType)) {
            return String.valueOf(assetType) + field;
        }
        FieldType fieldType = fieldAlias.getFieldType();
        return String.valueOf(fieldType.toString()) + "/" + field;
    }

    private String processMetadataField(String metadataField) {
        String field = metadataField;
        if (metadataField.startsWith(ECMF_SPEC_PREFIX)) {
            field = metadataField.substring(ECMF_SPEC_PREFIX.length());
        } else if (this.aliases.containsAlias(metadataField)) {
            field = this.handleAlias(metadataField);
        }
        return field;
    }

    private static final /* synthetic */ Response list_aroundBody0(RuleServiceNG ajc$this, HttpServletRequest servletRequest, UriInfo uriInfo, String accept, String packageName, String keywords, String metadataField, String filter, String detail) {
        LOGGER.debug((Object)String.format("packageName:%s, keywords:%s, metadataField:%s, filter:%s, details:%s.", packageName, keywords, metadataField, filter, detail));
        Response errorResponse = ajc$this.validateParam(servletRequest, accept);
        if (errorResponse != null) {
            return errorResponse;
        }
        if (!RuleFullTextMigrationService.migrateComplete()) {
            return ajc$this.buildErrorResponse(MIGRATE_ERROR_MSG, Response.Status.SERVICE_UNAVAILABLE);
        }
        if (StringUtils.isBlank((String)packageName)) {
            return ajc$this.buildErrorResponse(PACKAGE_EMPTY_ERROR_MSG, Response.Status.BAD_REQUEST);
        }
        Boolean status = null;
        try {
            status = ajc$this.isRuleSetEnabled(filter);
        }
        catch (IllegalArgumentException e) {
            LOGGER.info((Object)"Exception occurs when parse filter.", (Throwable)e);
            return ajc$this.buildErrorResponse(INVALID_FILTER_MSG, Response.Status.BAD_REQUEST);
        }
        String field = ajc$this.processMetadataField(metadataField);
        String searchText = field + ' ' + keywords;
        return ajc$this.buildListResponse(uriInfo, accept, packageName, detail, status, searchText);
    }

    private static final /* synthetic */ Object list_aroundBody1$advice(RuleServiceNG ajc$this, HttpServletRequest servletRequest, UriInfo uriInfo, String accept, String packageName, String keywords, String metadataField, String filter, String detail, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return RuleServiceNG.list_aroundBody0(ajc$this, servletRequest, uriInfo, accept, packageName, keywords, metadataField, filter, detail);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Response object = RuleServiceNG.list_aroundBody0(ajc$this, servletRequest, uriInfo, accept, packageName, keywords, metadataField, filter, detail);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

