/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services;

import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.entities.Site;
import com.ericsson.cms.sites.core.entities.TargetResult;
import com.ericsson.neptune.security.audit.AbstractAuditManager;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tandbergtv.cms.data.RuleSetsListing;
import com.tandbergtv.cms.rules.service.RuleDeleteException;
import com.tandbergtv.cms.rules.service.audit.RulesetStatusAuditor;
import com.tandbergtv.cms.rules.service.category.IRuleExecutionHandler;
import com.tandbergtv.cms.rules.service.category.IRuleManager;
import com.tandbergtv.cms.services.AuthorizationException;
import com.tandbergtv.cms.services.Authorizer;
import com.tandbergtv.cms.services.IRulesUtilities;
import com.tandbergtv.cms.util.EndpointsAuthorizationUtil;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.marvin.udt.ActionMessage;
import com.tandbergtv.marvin.udt.TreEvent;
import com.tandbergtv.marvin.udt.TrePackage;
import com.tandbergtv.marvin.udt.TreRuleSet;
import com.tandbergtv.marvin.udt.ValidationMessage;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.metadatamanager.specimpl.ttv.TTVSpecHandler;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.ejb.EJBAccessException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.jboss.security.client.SecurityClient;
import org.jboss.security.client.SecurityClientFactory;
import org.springframework.util.CollectionUtils;
import org.w3c.dom.Document;

public class RulesUtilities
implements IRulesUtilities {
    private static final String RULES_MANAGEMENT_MODIFY = "RulesManagement_Modify";
    private static final String RULES_MANAGEMENT_DELETE = "RulesManagement_Delete";
    private static final Logger logger = Logger.getLogger(RulesUtilities.class);
    private RulesetStatusAuditor auditor = RulesetStatusAuditor.getInstance();
    private AbstractAuditManager auditManager = AbstractAuditManager.getInstance();
    private IRuleManager ruleManager;

    @Override
    public Response enable(HttpServletRequest servletRequest, String username, String password, Boolean enabled, List<Integer> ruleSetIds) {
        try {
            SecurityClient securityClient = SecurityClientFactory.getSecurityClient();
            securityClient.setSimple((Object)username, (Object)password);
            securityClient.login();
            if (!Authorizer.hasPermissionNoModule(RULES_MANAGEMENT_MODIFY)) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type("text/plain").build();
            }
            List ruleSets = this.getRuleManager().getRuleSets(ruleSetIds);
            List<TreRuleSet> originalStatusRuleSets = ruleSets.stream().map(ruleSet -> ruleSet.asAuditRuleSet()).collect(Collectors.toList());
            this.getRuleManager().setRuleSetsEnabled(ruleSetIds, enabled.booleanValue());
            this.statusAuditLog(originalStatusRuleSets, enabled, servletRequest);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").build();
        }
        return Response.status((Response.Status)Response.Status.OK).type("text/plain").build();
    }

    @Override
    public Response enable(HttpServletRequest servletRequest, String authorizationHeader, Boolean enabled, List<Integer> ruleSetIds) {
        try {
            Response.ResponseBuilder builder = null;
            builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builder, RULES_MANAGEMENT_MODIFY);
            if (builder != null) {
                return builder.build();
            }
            List ruleSets = this.getRuleManager().getRuleSets(ruleSetIds);
            List<TreRuleSet> originalStatusRuleSets = ruleSets.stream().map(ruleSet -> ruleSet.asAuditRuleSet()).collect(Collectors.toList());
            this.getRuleManager().setRuleSetsEnabled(ruleSetIds, enabled.booleanValue());
            this.statusAuditLog(originalStatusRuleSets, enabled, servletRequest);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").build();
        }
        return Response.status((Response.Status)Response.Status.OK).type("text/plain").build();
    }

    @Override
    public List<Integer> getRuleSetId(HttpServletRequest servletRequest, String authorizationHeader, String ruleSetName) {
        block3: {
            try {
                Response.ResponseBuilder builder = null;
                builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builder, RULES_MANAGEMENT_MODIFY);
                if (builder == null) break block3;
                Response.status((Response.Status)Response.Status.FORBIDDEN).type("text/plain").build();
                return null;
            }
            catch (Exception e) {
                logger.error((Object)e);
                Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").build();
                return null;
            }
        }
        return this.getRuleManager().getRuleSetsByName(ruleSetName);
    }

    @Override
    public List<ValidationMessage> executeValdationRule(HttpServletRequest servletRequest, String authorizationHeader, final String ruleSetXmlLoc, final String cableLabsLoc) {
        return this.runWSecurity(servletRequest, authorizationHeader, new Runner<List<ValidationMessage>>(){

            @Override
            public List<ValidationMessage> run() {
                try {
                    List ruleSets = RulesUtilities.this.getRuleSetsFromXml(ruleSetXmlLoc);
                    Document document = RulesUtilities.this.getDocument(cableLabsLoc);
                    ISpecHandler handler = RulesUtilities.this.getSpecFromDoc(document);
                    Title title = new Title();
                    title.setAsset((Asset)handler.mergeWithoutSave(document).get(0));
                    List results = RulesUtilities.this.getExecutioner().runRuler(title, (Collection)ruleSets).getMessages();
                    return RulesUtilities.this.convertMessage(results);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Override
    public Response executeNormalizationRule(HttpServletRequest servletRequest, String authorizationHeader, final String ruleSetXmlFileLocation, final String cableLabsFileLocation) {
        return this.runWSecurity(servletRequest, authorizationHeader, new Runner<Response>(){

            @Override
            public Response run() {
                try {
                    Document document = RulesUtilities.this.getDocument(cableLabsFileLocation);
                    ISpecHandler handler = RulesUtilities.this.getSpecFromDoc(document);
                    return RulesUtilities.this.normalizationHelper(handler, handler, document, ruleSetXmlFileLocation);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").build();
                }
            }
        });
    }

    @Override
    public Response executeNormalizationRuleEcmf(HttpServletRequest servletRequest, String authorizationHeader, final String ruleSetXmlFileLocation, final String cableLabsFileLocation) {
        return this.runWSecurity(servletRequest, authorizationHeader, new Runner<Response>(){

            @Override
            public Response run() {
                try {
                    Document document = RulesUtilities.this.getDocument(cableLabsFileLocation);
                    ISpecHandler handler = RulesUtilities.this.getSpecFromDoc(document);
                    return RulesUtilities.this.normalizationHelper(handler, (ISpecHandler)new TTVSpecHandler(), document, ruleSetXmlFileLocation);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").build();
                }
            }
        });
    }

    private Response normalizationHelper(ISpecHandler handlerIn, ISpecHandler handlerOut, Document document, String ruleSetXmlFileLocation) throws Exception {
        List<TreRuleSet> ruleSets = this.getRuleSetsFromXml(ruleSetXmlFileLocation);
        Title title = new Title();
        title.setContentClassId(((IContentClassService)ServiceRegistry.getDefault().lookup(IContentClassService.class)).getDefaultContentClassId());
        title.setAsset((Asset)handlerIn.mergeWithoutSave(document).get(0));
        title.setPartnerId(Long.valueOf(1L));
        Asset asset = this.getExecutioner().runRuler(title, ruleSets).getTitle().getAsset();
        Document doc = handlerOut.convertAssetToXMLDocument(asset);
        StringWriter sw = new StringWriter();
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.transform(new DOMSource(doc), new StreamResult(sw));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)new String(sw.toString())).build();
    }

    private List<TreRuleSet> getRuleSetsFromXml(String ruleSetXmlLoc) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{RuleSetsListing.class});
        Unmarshaller u = jc.createUnmarshaller();
        RuleSetsListing ruleSetsListing = (RuleSetsListing)u.unmarshal(new File(ruleSetXmlLoc));
        return ruleSetsListing.getRuleSets();
    }

    private ISpecHandler getSpecFromDoc(Document document) {
        ISpecHandler handler;
        ISpecificationManager service = (ISpecificationManager)ServiceRegistry.getDefault().lookup(ISpecificationManager.class);
        Specification specification = service.getSpecificationForDocument(document);
        ISpecHandler iSpecHandler = handler = specification != null ? specification.getSpecHandler() : null;
        if (handler == null) {
            String msg = "Failed to match a specification for " + document + ". Check your license or the specification plugin(s).";
            throw new RuntimeException(msg);
        }
        return handler;
    }

    private Document getDocument(String cableLabsLoc) throws Exception {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        return docBuilder.parse(new File(cableLabsLoc));
    }

    @Override
    public List<ValidationMessage> executeValdationRuleById(HttpServletRequest servletRequest, String authorizationHeader, final Integer ruleSetId, final Long titleId) {
        return this.runWSecurity(servletRequest, authorizationHeader, new Runner<List<ValidationMessage>>(){

            @Override
            public List<ValidationMessage> run() {
                List results = RulesUtilities.this.getExecutioner().runRuler(RulesUtilities.this.getTitle(titleId), Arrays.asList(ruleSetId)).getMessages();
                return RulesUtilities.this.convertMessage(results);
            }
        });
    }

    @Override
    public List<ValidationMessage> executeValdation(HttpServletRequest servletRequest, String authorizationHeader, final Long titleId) {
        return this.runWSecurity(servletRequest, authorizationHeader, new Runner<List<ValidationMessage>>(){

            @Override
            public List<ValidationMessage> run() {
                List results = RulesUtilities.this.getExecutioner().runValidateRuler(RulesUtilities.this.getTitle(titleId)).getMessages();
                return RulesUtilities.this.convertMessage(results);
            }
        });
    }

    private List<ValidationMessage> convertMessage(List<ActionMessage> messages) {
        ArrayList<ValidationMessage> vmessage = new ArrayList<ValidationMessage>(messages.size());
        for (ActionMessage message : messages) {
            vmessage.add((ValidationMessage)message);
        }
        return vmessage;
    }

    @Override
    public Response executeCPById(HttpServletRequest servletRequest, String authorizationHeader, final Integer ruleSetId, final Long titleId) {
        return this.runWSecurity(servletRequest, authorizationHeader, new Runner<Response>(){

            @Override
            public Response run() {
                List results = RulesUtilities.this.getExecutioner().runRuler(RulesUtilities.this.getTitle(titleId), Arrays.asList(ruleSetId)).getTemplateNames();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ObjectMapper mapper = new ObjectMapper();
                try {
                    mapper.writeValue((OutputStream)out, (Object)results);
                }
                catch (Exception exception) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").build();
                }
                return Response.status((Response.Status)Response.Status.OK).entity((Object)new String(out.toByteArray())).build();
            }
        });
    }

    @Override
    public Response executeConentProc(HttpServletRequest servletRequest, String authorizationHeader, final Long titleId, final String event) {
        return this.runWSecurity(servletRequest, authorizationHeader, new Runner<Response>(){

            @Override
            public Response run() {
                List results = RulesUtilities.this.getExecutioner().runRuler(RulesUtilities.this.getTitle(titleId), TreEvent.valueOf((String)event), new TrePackage("PROCESSING")).getTemplateNames();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ObjectMapper mapper = new ObjectMapper();
                try {
                    mapper.writeValue((OutputStream)out, (Object)results);
                }
                catch (Exception exception) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").build();
                }
                return Response.status((Response.Status)Response.Status.OK).entity((Object)new String(out.toByteArray())).build();
            }
        });
    }

    private IRuleExecutionHandler getExecutioner() {
        return (IRuleExecutionHandler)InjectionUtil.injectInstance((String)"cms/EventHandler/local", IRuleExecutionHandler.class);
    }

    private Title getTitle(Long titleId) {
        ITitleManager titleManager = (ITitleManager)InjectionUtil.injectInstance((String)"cms/TitleManagerProxy/local", ITitleManager.class);
        return titleManager.get(titleId);
    }

    private <T> T runWSecurity(HttpServletRequest servletRequest, String authorizationHeader, Runner<T> runner) {
        block3: {
            try {
                Response.ResponseBuilder builder = null;
                builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builder, RULES_MANAGEMENT_MODIFY);
                if (builder == null) break block3;
                Response.status((Response.Status)Response.Status.FORBIDDEN).type("text/plain").build();
            }
            catch (Exception e) {
                logger.error((Object)e);
                Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").build();
                return null;
            }
            return null;
        }
        return runner.run();
    }

    @Override
    public Response executeTargetTitle(HttpServletRequest servletRequest, String authorizationHeader, final Long titleId) {
        return this.runWSecurity(servletRequest, authorizationHeader, new Runner<Response>(){

            @Override
            public Response run() {
                try {
                    ISiteManager siteManager = (ISiteManager)InjectionUtil.injectInstance((String)"cms/SiteManager/local", ISiteManager.class);
                    TargetResult results = siteManager.targetWithRules(titleId.longValue());
                    ArrayList<String> activeSitesTargeted = new ArrayList<String>();
                    for (Site s : results.getActiveSites()) {
                        activeSitesTargeted.add(s.getName());
                    }
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    ObjectMapper mapper = new ObjectMapper();
                    try {
                        mapper.writeValue((OutputStream)out, activeSitesTargeted);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    return Response.status((Response.Status)Response.Status.OK).entity((Object)new String(out.toByteArray())).build();
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                }
            }
        });
    }

    @Override
    public Response getRuleSetIdByUUID(HttpServletRequest servletRequest, String authorizationHeader, final String uuid) {
        return this.runWSecurity(servletRequest, authorizationHeader, new Runner<Response>(){

            @Override
            public Response run() {
                try {
                    List results = RulesUtilities.this.getRuleManager().getRuleSetsByUuid(uuid);
                    if (results.size() == 1) {
                        return Response.status((Response.Status)Response.Status.OK).entity((Object)((TreRuleSet)results.get(0)).getRuleSetId()).build();
                    }
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)("There should be one uuid but there is " + results.size())).build();
                }
                catch (Exception exception) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").build();
                }
            }
        });
    }

    @Override
    public Response deleteRuleSet(HttpServletRequest servletRequest, String authorizationHeader, Integer ruleSetId) {
        try {
            Response.ResponseBuilder builder = null;
            builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builder, RULES_MANAGEMENT_DELETE);
            if (builder != null) {
                return builder.build();
            }
        }
        catch (AuthorizationException authorizationException) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type("text/plain").build();
        }
        catch (EJBAccessException eJBAccessException) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type("text/plain").build();
        }
        try {
            this.getRuleManager().deleteRuleSet(ruleSetId.intValue());
        }
        catch (RuleDeleteException e) {
            logger.error((Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    private void statusAuditLog(List<TreRuleSet> ruleSets, Boolean enabled, HttpServletRequest request) {
        if (CollectionUtils.isEmpty(ruleSets)) {
            return;
        }
        for (TreRuleSet ruleset : ruleSets) {
            if (ruleset.getEnabled().equals(enabled)) continue;
            TreRuleSet newRuleSet = ruleset.asAuditRuleSet(enabled.booleanValue());
            this.auditManager.logAudit(this.auditor.audit((Object)ruleset, (Object)newRuleSet), request);
        }
    }

    private IRuleManager getRuleManager() {
        if (this.ruleManager == null) {
            this.ruleManager = (IRuleManager)InjectionUtil.injectInstance((String)"cms/RuleManagerImpl/local", IRuleManager.class);
        }
        return this.ruleManager;
    }

    private static interface Runner<T> {
        public T run();
    }
}

