/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.health;

import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.ericsson.neptune.clustermgmt.service.ClusterConstant;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import java.net.InetSocketAddress;
import java.util.Set;

public final class Cluster {
    private static IClusterService hzcs = com.ericsson.cms.neptune.cluster.Cluster.getService((String)ClusterConstant.CLUSTER_CONFIG_PATH);
    private static HazelcastInstance hazelcastInstance = hzcs.getInstance();

    public static Member localMember() {
        return hazelcastInstance.getCluster().getLocalMember();
    }

    public static InetSocketAddress localAddress() {
        return Cluster.localMember().getInetSocketAddress();
    }

    public static Member memberForAddress(InetSocketAddress address) {
        for (Member member : hazelcastInstance.getCluster().getMembers()) {
            if (!member.getInetSocketAddress().equals(address)) continue;
            return member;
        }
        return null;
    }

    public static boolean memberForAddressExists(InetSocketAddress address) {
        return Cluster.memberForAddress(address) != null;
    }

    public static boolean isLocalMemberAddress(InetSocketAddress address) {
        return Cluster.localMember().getInetSocketAddress().equals(address);
    }

    public static Member masterMember() {
        Member member = null;
        if (hazelcastInstance != null && hazelcastInstance.getCluster() != null && hazelcastInstance.getCluster().getMembers() != null && hazelcastInstance.getCluster().getMembers().size() > 0) {
            member = (Member)hazelcastInstance.getCluster().getMembers().iterator().next();
        }
        return member;
    }

    public static boolean isMaster() {
        if (Cluster.masterMember() == null) {
            return false;
        }
        return Cluster.masterMember().equals(Cluster.localMember());
    }

    public static boolean isMember(Member member) {
        return hazelcastInstance.getCluster().getMembers().contains(member);
    }

    public static String getMembersAdresses() {
        Set members = hazelcastInstance.getCluster().getMembers();
        String addreses = "";
        for (Member m : members) {
            boolean master = Cluster.masterMember().equals(m);
            boolean local = Cluster.localMember().equals(m);
            addreses = String.valueOf(addreses) + m.getInetSocketAddress().toString().replace("/", "") + (master ? " [master]" : "") + (local ? " [this]" : "") + "\n";
        }
        return addreses;
    }
}

