/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.partner;

import com.ericsson.cms.search.PartnerSearchColumn;
import com.tandbergtv.cms.services.exception.BadRequestException;
import com.tandbergtv.cms.services.resources.Partner;
import com.tandbergtv.neptune.licensing.ILicenseManager;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.entities.ContainerProperty;
import com.tandbergtv.watchpoint.pmm.entities.PartnerContact;
import com.tandbergtv.watchpoint.pmm.entities.PartnerType;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.search.SearchOperator;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.mail.internet.InternetAddress;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringUtils;

public class PartnerServiceHelper {
    private static IPartnerManagement partnerManager;
    private static ILicenseManager neptuneLicenseManager;
    private static final Map<String, SearchOperator> supportedOperatorMap;
    private static final List<PartnerSearchColumn> supportedSearchField;

    static {
        supportedOperatorMap = new HashMap<String, SearchOperator>();
        supportedSearchField = new ArrayList<PartnerSearchColumn>();
        supportedSearchField.add(PartnerSearchColumn.LOOKUPKEY);
        supportedSearchField.add(PartnerSearchColumn.NAME);
        supportedSearchField.add(PartnerSearchColumn.PROVIDERID);
        supportedOperatorMap.put("CONTAINS", SearchOperator.LIKE);
    }

    private PartnerServiceHelper() {
    }

    public static Partner convertFromBackendPartner(com.tandbergtv.watchpoint.pmm.entities.Partner partner, UriInfo uriInfo, boolean isChild) {
        Partner frontendPartner = new Partner();
        String href = uriInfo.getBaseUri() + "partners/" + partner.getId();
        if (isChild) {
            frontendPartner.setHref(href);
            frontendPartner.setName(partner.getName());
            frontendPartner.setProviderId(partner.getProviderId());
        } else {
            frontendPartner.setName(partner.getName());
            frontendPartner.setType(partner.getType().toString());
            frontendPartner.setProviderId(partner.getProviderId());
            frontendPartner.setLookupKey(partner.getLookupKey());
            frontendPartner.setFirstName(partner.getContact().getFirstName() == null ? "" : partner.getContact().getFirstName());
            frontendPartner.setLastName(partner.getContact().getLastName() == null ? "" : partner.getContact().getLastName());
            frontendPartner.setEmail(partner.getContact().getEmail() == null ? "" : partner.getContact().getEmail());
            frontendPartner.setProperties(new Partner.Properties());
            frontendPartner.setIsEmailNotify(partner.getIsEmailNotify() == null ? false : partner.getIsEmailNotify());
            frontendPartner.setIsSuccessNotify(partner.getIsSuccessNotify() == null ? false : partner.getIsSuccessNotify());
            if (frontendPartner.getType().equals(PartnerType.SELF.name())) {
                frontendPartner.setIsTenant(Boolean.TRUE);
            } else {
                frontendPartner.setIsTenant(partner.getIsTenant() == null ? false : partner.getIsTenant());
            }
            for (ContainerProperty property : partner.getProperties()) {
                frontendPartner.getProperties().getEntries().add(new Partner.Properties.Entry(property){
                    {
                        this.setKey(containerProperty.getName());
                        this.setValue(containerProperty.getValue());
                    }
                });
            }
            frontendPartner.setHref(href);
        }
        if (partner.getChildPartnerList() != null && !partner.getChildPartnerList().isEmpty()) {
            Partner.ChildPartners childPartners = new Partner.ChildPartners();
            for (com.tandbergtv.watchpoint.pmm.entities.Partner p : partner.getChildPartnerList()) {
                Partner fPartner = PartnerServiceHelper.convertFromBackendPartner(p, uriInfo, true);
                childPartners.getChildPartners().add(fPartner);
            }
            frontendPartner.setChildPartners(childPartners);
        }
        return frontendPartner;
    }

    public static com.tandbergtv.watchpoint.pmm.entities.Partner convertToBackendPartner(com.tandbergtv.watchpoint.pmm.entities.Partner backendPartner, Partner metadata) {
        Partner.Properties metaProperties;
        PartnerContact contact;
        if (backendPartner == null) {
            backendPartner = new com.tandbergtv.watchpoint.pmm.entities.Partner();
        }
        if ((contact = backendPartner.getContact()) == null) {
            contact = new PartnerContact();
        }
        backendPartner.setName(metadata.getName());
        backendPartner.setType(PartnerType.valueOf((String)metadata.getType()));
        backendPartner.setProviderId(metadata.getProviderId());
        String lookupKey = metadata.getLookupKey() != null ? metadata.getLookupKey().trim() : "";
        backendPartner.setLookupKey(lookupKey);
        if (metadata.getIsEmailNotify() == null) {
            backendPartner.setIsEmailNotify(Boolean.FALSE);
        } else {
            backendPartner.setIsEmailNotify(metadata.getIsEmailNotify());
        }
        if (metadata.getIsSuccessNotify() == null) {
            backendPartner.setIsSuccessNotify(Boolean.FALSE);
        } else {
            backendPartner.setIsSuccessNotify(metadata.getIsSuccessNotify());
        }
        contact.setFirstName(metadata.getFirstName());
        contact.setLastName(metadata.getLastName());
        contact.setEmail(metadata.getEmail());
        contact.setPartner(backendPartner);
        backendPartner.setContact(contact);
        backendPartner.setIsActive(Boolean.valueOf(true));
        if (backendPartner.getType().equals((Object)PartnerType.SELF)) {
            backendPartner.setIsTenant(Boolean.TRUE);
        } else {
            backendPartner.setIsTenant(metadata.isIsTenant() == null ? Boolean.FALSE : metadata.isIsTenant());
        }
        ArrayList<ContainerProperty> properties = backendPartner.getProperties();
        if (properties == null) {
            properties = new ArrayList<ContainerProperty>();
        }
        if ((metaProperties = metadata.getProperties()) != null && metaProperties.getEntries() != null) {
            for (Partner.Properties.Entry e : metadata.getProperties().getEntries()) {
                ContainerProperty property = new ContainerProperty(e.getKey(), e.getValue());
                property.setContext(backendPartner.getContext());
                properties.add(property);
            }
        }
        backendPartner.setProperties(properties);
        backendPartner.getContext().setProperties(properties);
        return backendPartner;
    }

    public static ValueParameter convertFilterToValueParameter(String filter) throws BadRequestException {
        if (filter == null) {
            return null;
        }
        String[] params = filter.split(":");
        if (params.length != 3) {
            throw new BadRequestException("invalid filter. filter should be search_by:operator:search_value.");
        }
        String fieldName = params[0];
        String operator = params[1];
        String value = params[2];
        PartnerSearchColumn searchColumn = PartnerSearchColumn.parse((String)fieldName);
        if (searchColumn == null || !PartnerServiceHelper.validColumn(searchColumn)) {
            throw new BadRequestException("invalid field. support select by " + supportedSearchField);
        }
        if (!supportedOperatorMap.containsKey(operator)) {
            throw new BadRequestException("invalid operator. support operater " + supportedOperatorMap.keySet());
        }
        return new ValueParameter(searchColumn.getEntityField(), searchColumn.getType(), (Object)value, supportedOperatorMap.get(operator), true);
    }

    private static boolean validColumn(PartnerSearchColumn searchColumn) {
        return supportedSearchField.contains(searchColumn);
    }

    public static boolean validatePartner(Partner metadata, Long partnerId) throws BadRequestException {
        ArrayList<String> errorList = new ArrayList<String>();
        if (metadata.getName() == null) {
            errorList.add("Partner name is not provided. ");
        }
        if (metadata.getProviderId() == null) {
            errorList.add("Provider Id is not provided. ");
        }
        if (metadata.getType() == null) {
            errorList.add("Type is not provided. ");
        }
        if (errorList.isEmpty()) {
            if (metadata.getName().trim().length() == 0) {
                errorList.add("Partner name cannot be empty. ");
            }
            if (metadata.getProviderId().trim().length() == 0) {
                errorList.add("Provider Id cannot be empty. ");
            }
            if (metadata.getType().trim().length() == 0) {
                errorList.add("Type cannot be empty. ");
            }
        }
        if (errorList.isEmpty()) {
            Partner.Properties properties;
            String lookupKey;
            String errorMsg;
            if (metadata.getName().trim().length() > 25) {
                errorList.add("Partner name cannot exceed 25 characters. ");
            }
            if (Pattern.matches(".*[/].*", metadata.getName().trim())) {
                errorList.add("Partner name cannot contain any of the following characters: [/] ");
            }
            if (!PartnerServiceHelper.validatePartnerByName(metadata, partnerId)) {
                errorList.add("Partner with the same Name already exists. ");
            }
            if (metadata.getProviderId().trim().length() > 25) {
                errorList.add("Provider Id cannot exceed 25 characters. ");
            }
            if (Pattern.matches(".*[/].*", metadata.getProviderId().trim())) {
                errorList.add("Provider Id cannot contain any of the following characters: [/] ");
            }
            if (StringUtils.isNotBlank((String)(errorMsg = PartnerServiceHelper.validatePartnerByProviderId(metadata, partnerId)))) {
                errorList.add(errorMsg);
            }
            if (metadata.getFirstName() != null) {
                if (metadata.getFirstName().trim().length() > 25) {
                    errorList.add("The contact's first name cannot exceed 25 characters. ");
                }
                if (Pattern.matches(".*\\d.*", metadata.getFirstName().trim())) {
                    errorList.add("The contact's first name cannot contain numerical characters. ");
                }
            }
            if (metadata.getLastName() != null) {
                if (metadata.getLastName().trim().length() > 25) {
                    errorList.add("The contact's last name cannot exceed 25 characters. ");
                }
                if (Pattern.matches(".*\\d.*", metadata.getLastName().trim())) {
                    errorList.add("The contact's last name cannot contain numerical characters. ");
                }
            }
            if (metadata.getEmail() != null) {
                if (metadata.getEmail().trim().length() > 50) {
                    errorList.add("The contact's email cannot exceed 50 characters. ");
                }
                if (!metadata.getEmail().trim().isEmpty()) {
                    try {
                        new InternetAddress(metadata.getEmail(), true);
                    }
                    catch (Exception exception) {
                        errorList.add("The contact's email is invalid. ");
                    }
                }
            }
            if ((Boolean.TRUE.equals(metadata.getIsEmailNotify()) || Boolean.TRUE.equals(metadata.getIsSuccessNotify())) && StringUtils.isEmpty((String)metadata.getEmail())) {
                errorList.add("The contact's email is required when Email Notification is selected.");
            }
            if (StringUtils.isNotBlank((String)(lookupKey = metadata.getLookupKey()))) {
                if ((lookupKey = lookupKey.trim()).length() > 25) {
                    errorList.add("Lookup Key cannot exceed 25 characters. ");
                }
                if (!PartnerServiceHelper.validatePartnerByLookupKey(lookupKey, partnerId)) {
                    errorList.add("Partner with the same Lookup Key already exists. ");
                }
            }
            if ((properties = metadata.getProperties()) != null) {
                List<Partner.Properties.Entry> entries = properties.getEntries();
                HashSet<String> duplicateProperties = new HashSet<String>();
                if (entries != null && !entries.isEmpty()) {
                    int i = 0;
                    while (i < entries.size() - 1) {
                        int j = i + 1;
                        while (j < entries.size()) {
                            if (!duplicateProperties.contains(entries.get(i).getKey()) && entries.get(i).getKey().equalsIgnoreCase(entries.get(j).getKey())) {
                                duplicateProperties.add(entries.get(i).getKey());
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
                if (!duplicateProperties.isEmpty()) {
                    String error = "Property names should be unique. Found multiple properties with names: ";
                    for (String entry : duplicateProperties) {
                        error = String.valueOf(error) + "[" + entry + "] ";
                    }
                    errorList.add(error);
                }
                boolean checkKeys = true;
                boolean checkValues = true;
                for (Partner.Properties.Entry e : metadata.getProperties().getEntries()) {
                    if (checkKeys && e.getKey().trim().length() > 25) {
                        errorList.add("Property Name cannot exceed 25 characters. ");
                        checkKeys = false;
                    }
                    if (e.getValue().trim().length() > 250) {
                        errorList.add("Property Value cannot exceed 250 characters.");
                        checkValues = false;
                    }
                    if (!checkKeys && checkValues) break;
                }
            }
            if (metadata.isIsTenant() != null && metadata.isIsTenant().booleanValue() && !PartnerType.SELF.name().equalsIgnoreCase(metadata.getType())) {
                try {
                    String licVal = PartnerServiceHelper.getLicenseManager().getProperty("wholesale");
                    if (licVal != null) {
                        Long licLimit = Long.parseLong(licVal);
                        boolean prev = false;
                        if (partnerId != null) {
                            prev = PartnerServiceHelper.getPartnerManagement().isPartnerTenant(partnerId.longValue());
                        }
                        if (!prev && licLimit != 0L && (long)PartnerServiceHelper.getPartnerManagement().getNumberOfTenants() >= licLimit) {
                            errorList.add("Number of Tenants exceeded license limit of " + licLimit);
                        }
                    } else {
                        errorList.add("No license for Tenants");
                    }
                }
                catch (Exception e) {
                    errorList.add("Error getting license info: " + e.getMessage());
                }
            }
        }
        if (!errorList.isEmpty()) {
            throw new BadRequestException(errorList);
        }
        return true;
    }

    private static boolean validatePartnerByName(Partner metadata, Long partnerId) {
        if (metadata.getName() == null || metadata.getName().isEmpty() || metadata.getName().trim().length() == 0) {
            return false;
        }
        com.tandbergtv.watchpoint.pmm.entities.Partner namePartner = PartnerServiceHelper.getPartnerManagement().getPartnerByName(metadata.getName().trim());
        return namePartner == null || partnerId != null && namePartner.getId() == partnerId.longValue();
    }

    private static String validatePartnerByProviderId(Partner metadata, Long partnerId) {
        String providerId = StringUtils.trim((String)metadata.getProviderId());
        return PartnerServiceHelper.getPartnerManagement().checkDuplicateProviderIdPartner(providerId, partnerId);
    }

    private static boolean validatePartnerByLookupKey(String lookupKey, Long partnerId) {
        com.tandbergtv.watchpoint.pmm.entities.Partner lookupKeyPartner = PartnerServiceHelper.getPartnerManagement().getPartnerByLookupKey(lookupKey);
        return lookupKeyPartner == null || partnerId != null && lookupKeyPartner.getId() == partnerId.longValue();
    }

    private static IPartnerManagement getPartnerManagement() {
        if (Objects.isNull(partnerManager)) {
            partnerManager = (IPartnerManagement)ServiceRegistry.getDefault().lookup(IPartnerManagement.class);
        }
        return partnerManager;
    }

    private static ILicenseManager getLicenseManager() {
        if (Objects.isNull(neptuneLicenseManager)) {
            neptuneLicenseManager = (ILicenseManager)InjectionUtil.injectInstance((String)"cms/LicenseManager/local", ILicenseManager.class);
        }
        return neptuneLicenseManager;
    }
}

