/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.site;

import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.cms.sites.core.entities.LogicalSite;
import com.ericsson.cms.sites.core.entities.SitePartner;
import com.ericsson.cms.sites.core.entities.TrackingSite;
import com.ericsson.cms.sites.core.entities.mediapath.MediapathDistributionSite;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.cms.services.resources.Errors;
import com.tandbergtv.cms.services.resources.ResourceList;
import com.tandbergtv.cms.services.resources.Site;
import com.tandbergtv.cms.services.site.ISiteService;
import com.tandbergtv.cms.services.site.SiteListDetail;
import com.tandbergtv.cms.services.site.SiteServiceHelper;
import com.tandbergtv.cms.services.site.SiteValidator;
import com.tandbergtv.cms.services.validation.Messages;
import com.tandbergtv.cms.util.EndpointsAuthorizationUtil;
import com.tandbergtv.cms.util.ResponseBuilderWrapper;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.InitialContext;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.TransactionManager;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.mapped.Configuration;
import org.codehaus.jettison.mapped.MappedNamespaceConvention;
import org.codehaus.jettison.mapped.MappedXMLStreamReader;
import org.codehaus.jettison.mapped.MappedXMLStreamWriter;

public class SiteService
implements ISiteService {
    private static final String DEFAULT_MEDIA = "application/xml";
    private static final String JSON_MEDIA = "application/json";
    private static final Logger logger = Logger.getLogger((String)ISiteService.class.getName());
    private static final String PERMISSION_SITES_CREATE = "Sites_Create";
    private static final String PERMISSION_SITES_DELETE = "Sites_Delete";
    private static final String PERMISSION_SITES_UPDATE = "Sites_Modify";
    private static final String PERMISSION_SITES_VIEW = "Sites_View";
    private static final String DISTRIBUTION_SITE = "distributionSite";
    private static final String INVALID_CONTENT_TYPE_ERROR = "Invalid Content Type.";
    private static final String SITES_VALIDATION_SITEID_NOT_FOUND = "Sites.validation.siteId.notFound";
    private static final String SITES_VALIDATION_SITEID = "Sites.validation.siteId";
    private static final String DATABASE_ERROR = "An error has occured while trying to read from the database.";
    private static final String UNAUTHORIZED_ERROR = "Caller is unauthorized to execute operation.";
    private static final String SITE_ALREADY_EXISTES = "Site with that name already exists.";
    private SiteServiceHelper helper = null;
    private ISiteManager siteManager = (ISiteManager)InjectionUtil.injectInstance((String)"cms/SiteManager/local", ISiteManager.class);
    private SiteValidator validator = null;
    ObjectMapper mapper = new ObjectMapper();
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ Annotation ajc$anno$4;
    private static /* synthetic */ Annotation ajc$anno$5;
    private static /* synthetic */ Annotation ajc$anno$6;
    private static /* synthetic */ Annotation ajc$anno$7;
    private static /* synthetic */ Annotation ajc$anno$8;
    private static /* synthetic */ Annotation ajc$anno$9;
    private static /* synthetic */ Annotation ajc$anno$10;
    private static /* synthetic */ Annotation ajc$anno$11;
    private static /* synthetic */ Annotation ajc$anno$12;
    private static /* synthetic */ Annotation ajc$anno$13;
    private static /* synthetic */ Annotation ajc$anno$14;

    @Override
    @Transactional
    public Response associateChildSite(HttpServletRequest servletRequest, String authorizationHeader, String contentType, String accept, String siteId, ResourceList resourceList, Request request, UriInfo uriInfo, SecurityContext sec) {
        HttpServletRequest httpServletRequest = servletRequest;
        String string = authorizationHeader;
        String string2 = contentType;
        String string3 = accept;
        String string4 = siteId;
        ResourceList resourceList2 = resourceList;
        Request request2 = request;
        UriInfo uriInfo2 = uriInfo;
        SecurityContext securityContext = sec;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = SiteService.class.getDeclaredMethod("associateChildSite", HttpServletRequest.class, String.class, String.class, String.class, String.class, ResourceList.class, Request.class, UriInfo.class, SecurityContext.class).getAnnotation(Transactional.class);
        }
        return (Response)SiteService.associateChildSite_aroundBody1$advice(this, httpServletRequest, string, string2, string3, string4, resourceList2, request2, uriInfo2, securityContext, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public Response associateChildSite(HttpServletRequest servletRequest, String authorizationHeader, String contentType, String accept, String siteId, String jsonString, Request request, UriInfo uriInfo, SecurityContext sec) {
        HttpServletRequest httpServletRequest = servletRequest;
        String string = authorizationHeader;
        String string2 = contentType;
        String string3 = accept;
        String string4 = siteId;
        String string5 = jsonString;
        Request request2 = request;
        UriInfo uriInfo2 = uriInfo;
        SecurityContext securityContext = sec;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = SiteService.class.getDeclaredMethod("associateChildSite", HttpServletRequest.class, String.class, String.class, String.class, String.class, String.class, Request.class, UriInfo.class, SecurityContext.class).getAnnotation(Transactional.class);
        }
        return (Response)SiteService.associateChildSite_aroundBody3$advice(this, httpServletRequest, string, string2, string3, string4, string5, request2, uriInfo2, securityContext, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    public Response createChildSite(HttpServletRequest servletRequest, String authorizationHeader, String contentType, String accept, String siteId, Request request, UriInfo uriInfo, SecurityContext sec, Site metadata) {
        ResponseBuilderWrapper builderWrapper = new ResponseBuilderWrapper(null);
        Errors errors = new Errors();
        com.ericsson.cms.sites.core.entities.Site site = null;
        this.helper = new SiteServiceHelper();
        this.validator = new SiteValidator();
        String mediaType = this.getMediaType(contentType, accept);
        if (!this.validContentType(contentType, accept)) {
            errors.getErrors().add(INVALID_CONTENT_TYPE_ERROR);
            builderWrapper.setResponseBuilder(Response.status((Response.Status)Response.Status.BAD_REQUEST));
            builderWrapper.entity(errors);
        } else {
            try {
                builderWrapper.setResponseBuilder(EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builderWrapper.getResponseBuilder(), PERMISSION_SITES_CREATE));
            }
            catch (Exception exception) {
                errors.getErrors().add(UNAUTHORIZED_ERROR);
                builderWrapper.setResponseBuilder(Response.status((Response.Status)Response.Status.UNAUTHORIZED));
                builderWrapper.entity(errors);
            }
        }
        if (builderWrapper.getResponseBuilder() != null) {
            return builderWrapper.build();
        }
        try {
            site = this.doCreateChildSite(metadata, siteId, builderWrapper, errors, mediaType);
        }
        catch (Exception e) {
            errors.getErrors().add(DATABASE_ERROR);
            logger.error((Object)e);
            builderWrapper.setResponseBuilder(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR));
        }
        if (builderWrapper.getResponseBuilder() != null) {
            if (errors.getErrors().size() > 0) {
                builderWrapper.entity(errors);
            }
        } else {
            builderWrapper.setResponseBuilder(Response.ok((Object)this.convertResponseSite(site, uriInfo)));
        }
        return builderWrapper.build();
    }

    @Override
    public Response createChildSite(HttpServletRequest servletRequest, String authorizationHeader, String contentType, String accept, String siteId, Request request, UriInfo uriInfo, SecurityContext sec, String jsonString) {
        ResponseBuilderWrapper builderWrapper = new ResponseBuilderWrapper(null);
        Errors errors = new Errors();
        com.ericsson.cms.sites.core.entities.Site site = null;
        this.helper = new SiteServiceHelper();
        this.validator = new SiteValidator();
        String mediaType = this.getMediaType(contentType, accept);
        if (!this.validContentType(contentType, accept)) {
            errors.getErrors().add(INVALID_CONTENT_TYPE_ERROR);
            builderWrapper.setResponseBuilder(Response.status((Response.Status)Response.Status.BAD_REQUEST));
            builderWrapper.entity(errors);
        } else {
            try {
                builderWrapper.setResponseBuilder(EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builderWrapper.getResponseBuilder(), PERMISSION_SITES_CREATE));
            }
            catch (Exception exception) {
                errors.getErrors().add(UNAUTHORIZED_ERROR);
                builderWrapper.setResponseBuilder(Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(mediaType));
                builderWrapper.entity(errors);
            }
        }
        if (builderWrapper.getResponseBuilder() != null) {
            return builderWrapper.build();
        }
        try {
            Site childSite;
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Site.class});
            this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.mapper.configure(DeserializationFeature.UNWRAP_ROOT_VALUE, true);
            this.mapper.configure(MapperFeature.USE_ANNOTATIONS, false);
            this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            JSONObject obj = new JSONObject(jsonString);
            HashMap<String, String> xmlToJsonNamespaces = new HashMap<String, String>();
            xmlToJsonNamespaces.put("http://satv.ericsson.org/cms/services", "");
            Configuration config = new Configuration(xmlToJsonNamespaces);
            MappedNamespaceConvention con = new MappedNamespaceConvention(config);
            MappedXMLStreamReader xmlStreamReader = new MappedXMLStreamReader(obj, con);
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            if (obj.has(DISTRIBUTION_SITE)) {
                JAXBElement element = unmarshaller.unmarshal((XMLStreamReader)xmlStreamReader, com.tandbergtv.cms.services.resources.DistributionSite.class);
                childSite = (Site)element.getValue();
            } else {
                childSite = (Site)unmarshaller.unmarshal((XMLStreamReader)xmlStreamReader);
            }
            site = this.doCreateChildSite(childSite, siteId, builderWrapper, errors, mediaType);
        }
        catch (Exception e) {
            errors.getErrors().add(DATABASE_ERROR);
            logger.error((Object)e);
            builderWrapper.setResponseBuilder(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(mediaType));
        }
        if (builderWrapper.getResponseBuilder() != null) {
            if (errors.getErrors().size() > 0) {
                builderWrapper.entity(errors).type(JSON_MEDIA);
            }
        } else {
            builderWrapper.setResponseBuilder(Response.ok((Object)this.convertResponseSite(site, uriInfo)).type(JSON_MEDIA));
        }
        return builderWrapper.build();
    }

    @Transactional
    private com.ericsson.cms.sites.core.entities.Site doCreateChildSite(Site childSite, String siteId, ResponseBuilderWrapper builderWrapper, Errors errors, String mediaType) {
        Site site = childSite;
        String string = siteId;
        ResponseBuilderWrapper responseBuilderWrapper = builderWrapper;
        Errors errors2 = errors;
        String string2 = mediaType;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = SiteService.class.getDeclaredMethod("doCreateChildSite", Site.class, String.class, ResponseBuilderWrapper.class, Errors.class, String.class).getAnnotation(Transactional.class);
        }
        return (com.ericsson.cms.sites.core.entities.Site)SiteService.doCreateChildSite_aroundBody5$advice(this, site, string, responseBuilderWrapper, errors2, string2, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    public Response createSite(HttpServletRequest servletRequest, String authorizationHeader, String contentType, String accept, Request request, UriInfo uriInfo, SecurityContext sec, Site metadata) {
        Response.ResponseBuilder builder = null;
        Errors errors = new Errors();
        com.ericsson.cms.sites.core.entities.Site siteTosave = null;
        this.helper = new SiteServiceHelper();
        this.validator = new SiteValidator();
        if (!this.validContentType(contentType, accept)) {
            errors.getErrors().add(INVALID_CONTENT_TYPE_ERROR);
            builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
            builder.entity((Object)errors);
        } else if (!this.validator.isValidRequest(metadata)) {
            errors.getErrors().addAll(this.validator.getValidationErrors());
            builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
            builder.entity((Object)errors);
        } else {
            try {
                builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builder, PERMISSION_SITES_CREATE);
            }
            catch (Exception exception) {
                errors.getErrors().add(UNAUTHORIZED_ERROR);
                builder = Response.status((Response.Status)Response.Status.UNAUTHORIZED);
                builder.entity((Object)errors);
            }
        }
        if (builder != null) {
            return builder.build();
        }
        try {
            if (!this.validator.isValidPartner(metadata, null)) {
                errors.getErrors().addAll(this.validator.getValidationErrors());
                builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
            } else {
                siteTosave = this.helper.convertSite(metadata);
                builder = this.doCreateSite(metadata, siteTosave, errors);
            }
        }
        catch (Exception e) {
            errors.getErrors().add(DATABASE_ERROR);
            logger.error((Object)e);
            builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (builder != null) {
            if (errors.getErrors().size() > 0) {
                builder.entity((Object)errors);
            }
        } else {
            builder = Response.ok((Object)this.convertResponseSite(siteTosave, uriInfo));
        }
        return builder.build();
    }

    @Override
    public Response createSite(HttpServletRequest servletRequest, String authorizationHeader, String contentType, String accept, Request request, UriInfo uriInfo, SecurityContext sec, String jsonString) {
        Response.ResponseBuilder builder = null;
        Errors errors = new Errors();
        com.ericsson.cms.sites.core.entities.Site siteTosave = null;
        this.helper = new SiteServiceHelper();
        this.validator = new SiteValidator();
        if (!this.validContentType(contentType, accept)) {
            errors.getErrors().add(INVALID_CONTENT_TYPE_ERROR);
            builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
            builder.entity((Object)errors);
        } else {
            try {
                builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builder, PERMISSION_SITES_CREATE);
            }
            catch (Exception exception) {
                errors.getErrors().add(UNAUTHORIZED_ERROR);
                builder = Response.status((Response.Status)Response.Status.UNAUTHORIZED);
                builder.entity((Object)errors);
            }
        }
        if (builder != null) {
            return builder.build();
        }
        try {
            Site site;
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Site.class});
            this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.mapper.configure(DeserializationFeature.UNWRAP_ROOT_VALUE, true);
            this.mapper.configure(MapperFeature.USE_ANNOTATIONS, false);
            this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            JSONObject obj = new JSONObject(jsonString);
            HashMap<String, String> xmlToJsonNamespaces = new HashMap<String, String>();
            xmlToJsonNamespaces.put("http://satv.ericsson.org/cms/services", "");
            Configuration config = new Configuration(xmlToJsonNamespaces);
            MappedNamespaceConvention con = new MappedNamespaceConvention(config);
            MappedXMLStreamReader xmlStreamReader = new MappedXMLStreamReader(obj, con);
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            if (obj.has(DISTRIBUTION_SITE)) {
                JAXBElement element = unmarshaller.unmarshal((XMLStreamReader)xmlStreamReader, com.tandbergtv.cms.services.resources.DistributionSite.class);
                site = (Site)element.getValue();
            } else {
                site = (Site)unmarshaller.unmarshal((XMLStreamReader)xmlStreamReader);
            }
            if (!this.validator.isValidRequest(site) || !this.validator.isValidPartner(site, null)) {
                errors.getErrors().addAll(this.validator.getValidationErrors());
                builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
            } else {
                siteTosave = this.helper.convertSite(site);
                builder = this.doCreateSite(site, siteTosave, errors);
            }
        }
        catch (Exception e) {
            errors.getErrors().add(DATABASE_ERROR);
            logger.error((Object)e);
            builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (builder != null) {
            if (errors.getErrors().size() > 0) {
                builder.entity((Object)errors).type(JSON_MEDIA);
            }
        } else {
            builder = Response.ok((Object)this.convertResponseSite(siteTosave, uriInfo)).type(JSON_MEDIA);
        }
        return builder.build();
    }

    @Transactional
    private Response.ResponseBuilder doCreateSite(Site site, com.ericsson.cms.sites.core.entities.Site siteTosave, Errors errors) {
        Site site2 = site;
        com.ericsson.cms.sites.core.entities.Site site3 = siteTosave;
        Errors errors2 = errors;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = SiteService.class.getDeclaredMethod("doCreateSite", Site.class, com.ericsson.cms.sites.core.entities.Site.class, Errors.class).getAnnotation(Transactional.class);
        }
        return (Response.ResponseBuilder)SiteService.doCreateSite_aroundBody7$advice(this, site2, site3, errors2, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public Response deleteChildSite(HttpServletRequest servletRequest, String authorizationHeader, String accept, String siteId, String childSiteId, Request request, UriInfo uriInfo, SecurityContext sec) {
        HttpServletRequest httpServletRequest = servletRequest;
        String string = authorizationHeader;
        String string2 = accept;
        String string3 = siteId;
        String string4 = childSiteId;
        Request request2 = request;
        UriInfo uriInfo2 = uriInfo;
        SecurityContext securityContext = sec;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = SiteService.class.getDeclaredMethod("deleteChildSite", HttpServletRequest.class, String.class, String.class, String.class, String.class, Request.class, UriInfo.class, SecurityContext.class).getAnnotation(Transactional.class);
        }
        return (Response)SiteService.deleteChildSite_aroundBody9$advice(this, httpServletRequest, string, string2, string3, string4, request2, uriInfo2, securityContext, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    public Response deleteSite(HttpServletRequest servletRequest, String authorizationHeader, String accept, String siteId, Request request, UriInfo uriInfo, SecurityContext sec) {
        String mediaType;
        Errors errors;
        Response.ResponseBuilder builder;
        block8: {
            builder = null;
            errors = new Errors();
            com.ericsson.cms.sites.core.entities.Site site = null;
            mediaType = this.defineMediaType(accept);
            try {
                builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builder, PERMISSION_SITES_DELETE);
                if (builder != null) {
                    return builder.build();
                }
                try {
                    site = this.siteManager.getSite(Integer.valueOf(siteId).intValue());
                    if (site == null) {
                        errors.getErrors().add("Site not found");
                        builder = Response.status((Response.Status)Response.Status.NOT_FOUND).type(mediaType);
                        break block8;
                    }
                    this.siteManager.delete(site.getId().intValue());
                }
                catch (Exception e) {
                    errors.getErrors().add(DATABASE_ERROR);
                    logger.error((Object)e);
                    builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(mediaType);
                }
            }
            catch (Exception exception) {
                errors.getErrors().add(UNAUTHORIZED_ERROR);
                builder = Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(mediaType);
            }
        }
        if (errors.getErrors().size() > 0) {
            builder.entity((Object)errors);
        } else {
            builder = Response.status((Response.Status)Response.Status.NO_CONTENT).type(mediaType);
        }
        return builder.build();
    }

    @Override
    @Transactional
    public Response getSite(HttpServletRequest servletRequest, String authorizationHeader, String accept, String siteId, Date lastModified, Request request, UriInfo uriInfo, SecurityContext sec) {
        HttpServletRequest httpServletRequest = servletRequest;
        String string = authorizationHeader;
        String string2 = accept;
        String string3 = siteId;
        Date date = lastModified;
        Request request2 = request;
        UriInfo uriInfo2 = uriInfo;
        SecurityContext securityContext = sec;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$5;
        if (annotation == null) {
            annotation = ajc$anno$5 = SiteService.class.getDeclaredMethod("getSite", HttpServletRequest.class, String.class, String.class, String.class, Date.class, Request.class, UriInfo.class, SecurityContext.class).getAnnotation(Transactional.class);
        }
        return (Response)SiteService.getSite_aroundBody11$advice(this, httpServletRequest, string, string2, string3, date, request2, uriInfo2, securityContext, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public Response getTypeList(HttpServletRequest servletRequest, String authorizationHeader, Date expires, String accept, Request request, String siteType, String detail, UriInfo uriInfo, SecurityContext sec) {
        HttpServletRequest httpServletRequest = servletRequest;
        String string = authorizationHeader;
        Date date = expires;
        String string2 = accept;
        Request request2 = request;
        String string3 = siteType;
        String string4 = detail;
        UriInfo uriInfo2 = uriInfo;
        SecurityContext securityContext = sec;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$6;
        if (annotation == null) {
            annotation = ajc$anno$6 = SiteService.class.getDeclaredMethod("getTypeList", HttpServletRequest.class, String.class, Date.class, String.class, Request.class, String.class, String.class, UriInfo.class, SecurityContext.class).getAnnotation(Transactional.class);
        }
        return (Response)SiteService.getTypeList_aroundBody13$advice(this, httpServletRequest, string, date, string2, request2, string3, string4, uriInfo2, securityContext, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public Response listSiteChildren(HttpServletRequest servletRequest, String authorizationHeader, String accept, String siteId, Request request, UriInfo uriInfo, SecurityContext sec) {
        HttpServletRequest httpServletRequest = servletRequest;
        String string = authorizationHeader;
        String string2 = accept;
        String string3 = siteId;
        Request request2 = request;
        UriInfo uriInfo2 = uriInfo;
        SecurityContext securityContext = sec;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$7;
        if (annotation == null) {
            annotation = ajc$anno$7 = SiteService.class.getDeclaredMethod("listSiteChildren", HttpServletRequest.class, String.class, String.class, String.class, Request.class, UriInfo.class, SecurityContext.class).getAnnotation(Transactional.class);
        }
        return (Response)SiteService.listSiteChildren_aroundBody15$advice(this, httpServletRequest, string, string2, string3, request2, uriInfo2, securityContext, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    public Response redirectTitleList(HttpServletRequest servletRequest, String authorizationHeader, HttpServletRequest request, String siteId) {
        String queryString = request.getQueryString();
        String url = request.getRequestURL().toString();
        int endIndex = url.indexOf("/sites");
        StringBuffer sb = new StringBuffer(url.subSequence(0, endIndex));
        sb.append("/titles?");
        sb.append(queryString);
        sb.append("&siteId=").append(siteId);
        try {
            return Response.seeOther((URI)new URI(sb.toString())).build();
        }
        catch (URISyntaxException uRISyntaxException) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @Override
    public Response updateSite(HttpServletRequest servletRequest, String authorizationHeader, String contentType, String accept, Date lastModified, String cascadeActivate, String siteId, Request request, UriInfo uriInfo, SecurityContext sec, Site site) {
        ResponseBuilderWrapper builderWrapper = new ResponseBuilderWrapper(null);
        Errors errors = new Errors();
        com.ericsson.cms.sites.core.entities.Site backSite = null;
        this.helper = new SiteServiceHelper();
        this.validator = new SiteValidator();
        if (!this.validContentType(contentType, accept)) {
            errors.getErrors().add(INVALID_CONTENT_TYPE_ERROR);
            builderWrapper.setResponseBuilder(Response.status((Response.Status)Response.Status.BAD_REQUEST));
            builderWrapper.entity(errors);
        } else if (StringUtils.isEmpty((String)siteId)) {
            errors.getErrors().add("Invalid siteId.");
            builderWrapper.setResponseBuilder(Response.status((Response.Status)Response.Status.BAD_REQUEST));
            builderWrapper.entity(errors);
        } else {
            try {
                builderWrapper.setResponseBuilder(EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builderWrapper.getResponseBuilder(), PERMISSION_SITES_UPDATE));
            }
            catch (Exception exception) {
                errors.getErrors().add(UNAUTHORIZED_ERROR);
                builderWrapper.setResponseBuilder(Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(DEFAULT_MEDIA));
                builderWrapper.entity(errors);
            }
        }
        if (builderWrapper.getResponseBuilder() != null) {
            return builderWrapper.build();
        }
        try {
            backSite = this.doUpdateSite(siteId, site, cascadeActivate, builderWrapper, errors, DEFAULT_MEDIA);
        }
        catch (Exception e) {
            errors.getErrors().add(DATABASE_ERROR);
            logger.error((Object)e);
            builderWrapper.setResponseBuilder(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR));
        }
        if (builderWrapper.getResponseBuilder() != null) {
            if (errors.getErrors().size() > 0) {
                builderWrapper.entity(errors).type(DEFAULT_MEDIA);
            }
        } else {
            builderWrapper.setResponseBuilder(Response.ok((Object)this.convertUpdateResponseSite(backSite, uriInfo)).type(DEFAULT_MEDIA));
        }
        return builderWrapper.build();
    }

    @Override
    public Response updateSite(HttpServletRequest servletRequest, String authorizationHeader, String contentType, String accept, Date lastModified, String cascadeActivate, String siteId, Request request, UriInfo uriInfo, SecurityContext sec, String siteString) {
        ResponseBuilderWrapper builderWrapper = new ResponseBuilderWrapper(null);
        Errors errors = new Errors();
        com.ericsson.cms.sites.core.entities.Site backSite = null;
        this.helper = new SiteServiceHelper();
        this.validator = new SiteValidator();
        if (!this.validContentType(contentType, accept)) {
            errors.getErrors().add(INVALID_CONTENT_TYPE_ERROR);
            builderWrapper.setResponseBuilder(Response.status((Response.Status)Response.Status.BAD_REQUEST));
            builderWrapper.entity(errors);
        } else if (StringUtils.isEmpty((String)siteId)) {
            errors.getErrors().add("Invalid siteId.");
            builderWrapper.setResponseBuilder(Response.status((Response.Status)Response.Status.BAD_REQUEST));
            builderWrapper.entity(errors);
        } else {
            try {
                builderWrapper.setResponseBuilder(EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builderWrapper.getResponseBuilder(), PERMISSION_SITES_UPDATE));
            }
            catch (Exception exception) {
                errors.getErrors().add(UNAUTHORIZED_ERROR);
                builderWrapper.setResponseBuilder(Response.status((Response.Status)Response.Status.UNAUTHORIZED));
                builderWrapper.entity(errors);
            }
        }
        if (builderWrapper.getResponseBuilder() != null) {
            return builderWrapper.build();
        }
        try {
            Site site;
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Site.class});
            this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.mapper.configure(DeserializationFeature.UNWRAP_ROOT_VALUE, true);
            this.mapper.configure(MapperFeature.USE_ANNOTATIONS, false);
            this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            JSONObject obj = new JSONObject(siteString);
            HashMap<String, String> xmlToJsonNamespaces = new HashMap<String, String>();
            xmlToJsonNamespaces.put("http://satv.ericsson.org/cms/services", "");
            Configuration config = new Configuration(xmlToJsonNamespaces);
            MappedNamespaceConvention con = new MappedNamespaceConvention(config);
            MappedXMLStreamReader xmlStreamReader = new MappedXMLStreamReader(obj, con);
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            if (obj.has(DISTRIBUTION_SITE)) {
                JAXBElement element = unmarshaller.unmarshal((XMLStreamReader)xmlStreamReader, com.tandbergtv.cms.services.resources.DistributionSite.class);
                site = (Site)element.getValue();
            } else {
                site = (Site)unmarshaller.unmarshal((XMLStreamReader)xmlStreamReader);
            }
            backSite = this.doUpdateSite(siteId, site, cascadeActivate, builderWrapper, errors, JSON_MEDIA);
        }
        catch (Exception e) {
            errors.getErrors().add(DATABASE_ERROR);
            logger.error((Object)e);
            builderWrapper.setResponseBuilder(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR));
        }
        if (builderWrapper.getResponseBuilder() != null) {
            if (errors.getErrors().size() > 0) {
                builderWrapper.entity(errors).type(JSON_MEDIA);
            }
        } else {
            builderWrapper.setResponseBuilder(Response.ok((Object)this.convertUpdateResponseSite(backSite, uriInfo)).type(JSON_MEDIA));
        }
        return builderWrapper.build();
    }

    @Transactional
    private com.ericsson.cms.sites.core.entities.Site doUpdateSite(String siteId, Site site, String cascadeActivate, ResponseBuilderWrapper builderWrapper, Errors errors, String mediaType) {
        String string = siteId;
        Site site2 = site;
        String string2 = cascadeActivate;
        ResponseBuilderWrapper responseBuilderWrapper = builderWrapper;
        Errors errors2 = errors;
        String string3 = mediaType;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$8;
        if (annotation == null) {
            annotation = ajc$anno$8 = SiteService.class.getDeclaredMethod("doUpdateSite", String.class, Site.class, String.class, ResponseBuilderWrapper.class, Errors.class, String.class).getAnnotation(Transactional.class);
        }
        return (com.ericsson.cms.sites.core.entities.Site)SiteService.doUpdateSite_aroundBody17$advice(this, string, site2, string2, responseBuilderWrapper, errors2, string3, transactionEnforcer, (Transactional)annotation, null);
    }

    private void activateSite(Site site, int siteId) {
        if (site.isActivated() != null) {
            if (site.isActivated().booleanValue()) {
                this.siteManager.activate(siteId);
            } else {
                this.siteManager.inactivate(siteId);
            }
        }
    }

    private void activateSite(com.ericsson.cms.sites.core.entities.Site backSite, Site site, String cascadeActivate) {
        if (cascadeActivate != null && !cascadeActivate.isEmpty()) {
            Boolean cascade = Boolean.valueOf(cascadeActivate);
            if (!cascade.booleanValue()) {
                if (site.isActivated() != null) {
                    if (site.isActivated().booleanValue()) {
                        this.siteManager.activateNoCascade(backSite.getId().intValue());
                    } else {
                        this.siteManager.inactivateNoCascade(backSite.getId().intValue());
                    }
                }
            } else {
                this.activateSite(site, backSite.getId());
            }
        } else if (site.isActivated() != null) {
            if (site.isActivated().booleanValue()) {
                this.siteManager.activateNoCascade(backSite.getId().intValue());
            } else {
                this.siteManager.inactivateNoCascade(backSite.getId().intValue());
            }
        }
    }

    @Transactional
    private Site convertResponceResourceList(com.ericsson.cms.sites.core.entities.Site site2, UriInfo request) {
        com.ericsson.cms.sites.core.entities.Site site = site2;
        UriInfo uriInfo = request;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$9;
        if (annotation == null) {
            annotation = ajc$anno$9 = SiteService.class.getDeclaredMethod("convertResponceResourceList", com.ericsson.cms.sites.core.entities.Site.class, UriInfo.class).getAnnotation(Transactional.class);
        }
        return (Site)SiteService.convertResponceResourceList_aroundBody19$advice(this, site, uriInfo, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    private Site convertResponseSite(com.ericsson.cms.sites.core.entities.Site site, UriInfo request) {
        com.ericsson.cms.sites.core.entities.Site site2 = site;
        UriInfo uriInfo = request;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$10;
        if (annotation == null) {
            annotation = ajc$anno$10 = SiteService.class.getDeclaredMethod("convertResponseSite", com.ericsson.cms.sites.core.entities.Site.class, UriInfo.class).getAnnotation(Transactional.class);
        }
        return (Site)SiteService.convertResponseSite_aroundBody21$advice(this, site2, uriInfo, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    private Site convertResponseSite(com.ericsson.cms.sites.core.entities.Site site, UriInfo request, SiteListDetail siteListDetail) {
        com.ericsson.cms.sites.core.entities.Site site2 = site;
        UriInfo uriInfo = request;
        SiteListDetail siteListDetail2 = siteListDetail;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$11;
        if (annotation == null) {
            annotation = ajc$anno$11 = SiteService.class.getDeclaredMethod("convertResponseSite", com.ericsson.cms.sites.core.entities.Site.class, UriInfo.class, SiteListDetail.class).getAnnotation(Transactional.class);
        }
        return (Site)SiteService.convertResponseSite_aroundBody23$advice(this, site2, uriInfo, siteListDetail2, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    private Site convertUpdateResponseSite(com.ericsson.cms.sites.core.entities.Site site, UriInfo request) {
        com.ericsson.cms.sites.core.entities.Site site2 = site;
        UriInfo uriInfo = request;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$12;
        if (annotation == null) {
            annotation = ajc$anno$12 = SiteService.class.getDeclaredMethod("convertUpdateResponseSite", com.ericsson.cms.sites.core.entities.Site.class, UriInfo.class).getAnnotation(Transactional.class);
        }
        return (Site)SiteService.convertUpdateResponseSite_aroundBody25$advice(this, site2, uriInfo, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    private List<com.ericsson.cms.sites.core.entities.Site> getAllLogicalSites() {
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$13;
        if (annotation == null) {
            annotation = ajc$anno$13 = SiteService.class.getDeclaredMethod("getAllLogicalSites", new Class[0]).getAnnotation(Transactional.class);
        }
        return (List)SiteService.getAllLogicalSites_aroundBody27$advice(this, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    private List<com.ericsson.cms.sites.core.entities.Site> getAllMediapathSites() {
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$14;
        if (annotation == null) {
            annotation = ajc$anno$14 = SiteService.class.getDeclaredMethod("getAllMediapathSites", new Class[0]).getAnnotation(Transactional.class);
        }
        return (List)SiteService.getAllMediapathSites_aroundBody29$advice(this, transactionEnforcer, (Transactional)annotation, null);
    }

    private List<DistributionSite> getDistSitesOnly(List<DistributionSite> allDistSites) {
        ArrayList<DistributionSite> sites = new ArrayList<DistributionSite>();
        if (allDistSites != null) {
            for (DistributionSite site : allDistSites) {
                if (site instanceof MediapathDistributionSite) continue;
                sites.add(site);
            }
        }
        return sites;
    }

    private String getMediaType(String contentType, String accept) {
        if (accept != null) {
            return accept;
        }
        if (contentType != null) {
            return contentType;
        }
        return null;
    }

    private void setHref(Site siteTo, UriInfo request) {
        String href = request.getBaseUri() + request.getPath().substring(1);
        siteTo.setHref(href);
    }

    private boolean validContentType(String contentType, String accept) {
        return contentType != null || accept != null;
    }

    private String defineMediaType(String accept) {
        if (accept != null && (accept.equalsIgnoreCase(JSON_MEDIA) || accept.equalsIgnoreCase(DEFAULT_MEDIA))) {
            return accept;
        }
        return DEFAULT_MEDIA;
    }

    private static final /* synthetic */ Response associateChildSite_aroundBody0(SiteService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, String contentType, String accept, String siteId, ResourceList resourceList, Request request, UriInfo uriInfo, SecurityContext sec) {
        Response.ResponseBuilder builder = null;
        Errors errors = new Errors();
        ajc$this.helper = new SiteServiceHelper();
        ajc$this.validator = new SiteValidator();
        if (!ajc$this.validContentType(contentType, accept)) {
            errors.getErrors().add(INVALID_CONTENT_TYPE_ERROR);
            builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
            builder.entity((Object)errors);
        } else {
            block16: {
                try {
                    builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builder, PERMISSION_SITES_UPDATE);
                    if (builder != null) {
                        return builder.build();
                    }
                    try {
                        if (siteId != null && !siteId.isEmpty() && ajc$this.validator.isValidInteger(siteId)) {
                            com.ericsson.cms.sites.core.entities.Site backSite = ajc$this.siteManager.getSite(Integer.valueOf(siteId).intValue());
                            if (backSite == null) {
                                errors.getErrors().add(Messages.getMessage(SITES_VALIDATION_SITEID_NOT_FOUND));
                                builder = Response.status((Response.Status)Response.Status.NOT_FOUND);
                            } else {
                                HashSet<Integer> trackingSiteIds = new HashSet<Integer>();
                                List<Site> trackingList = resourceList.getSites();
                                if (trackingList != null) {
                                    for (Site site : trackingList) {
                                        String idStr = ajc$this.helper.getIdFromHref(site.getHref());
                                        if (idStr == null || !ajc$this.validator.isValidInteger(idStr)) continue;
                                        trackingSiteIds.add(Integer.valueOf(idStr));
                                    }
                                    if (!ajc$this.validator.isValidAssociationRequest(Integer.valueOf(siteId), trackingSiteIds)) {
                                        errors.getErrors().addAll(ajc$this.validator.getValidationErrors());
                                        builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
                                        builder.entity((Object)errors);
                                    } else {
                                        ajc$this.siteManager.associateTrackingSites(trackingSiteIds, Integer.valueOf(siteId).intValue());
                                    }
                                }
                            }
                            break block16;
                        }
                        errors.getErrors().add(Messages.getMessage(SITES_VALIDATION_SITEID));
                        builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
                    }
                    catch (Exception e) {
                        errors.getErrors().add(DATABASE_ERROR);
                        logger.error((Object)e);
                        builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
                    }
                }
                catch (Exception exception) {
                    errors.getErrors().add(UNAUTHORIZED_ERROR);
                    builder = Response.status((Response.Status)Response.Status.UNAUTHORIZED);
                }
            }
            if (errors.getErrors().size() > 0) {
                builder.entity((Object)errors);
            } else {
                builder = Response.ok((Object)resourceList);
            }
        }
        return builder.build();
    }

    private static final /* synthetic */ Object associateChildSite_aroundBody1$advice(SiteService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, String contentType, String accept, String siteId, ResourceList resourceList, Request request, UriInfo uriInfo, SecurityContext sec, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return SiteService.associateChildSite_aroundBody0(ajc$this, servletRequest, authorizationHeader, contentType, accept, siteId, resourceList, request, uriInfo, sec);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Response object = SiteService.associateChildSite_aroundBody0(ajc$this, servletRequest, authorizationHeader, contentType, accept, siteId, resourceList, request, uriInfo, sec);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Response associateChildSite_aroundBody2(SiteService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, String contentType, String accept, String siteId, String jsonString, Request request, UriInfo uriInfo, SecurityContext sec) {
        Response.ResponseBuilder builder = null;
        Errors errors = new Errors();
        ResourceList list = new ResourceList();
        ajc$this.helper = new SiteServiceHelper();
        ajc$this.validator = new SiteValidator();
        String mediaType = ajc$this.getMediaType(contentType, accept);
        if (!ajc$this.validContentType(contentType, accept)) {
            errors.getErrors().add(INVALID_CONTENT_TYPE_ERROR);
            builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
            builder.entity((Object)errors);
        } else {
            try {
                builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builder, PERMISSION_SITES_UPDATE);
                if (builder != null) {
                    return builder.build();
                }
                try {
                    JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ResourceList.class});
                    JSONObject obj = new JSONObject(jsonString);
                    HashMap<String, String> xmlToJsonNamespaces = new HashMap<String, String>();
                    xmlToJsonNamespaces.put("http://satv.ericsson.org/cms/services", "");
                    Configuration config = new Configuration(xmlToJsonNamespaces);
                    MappedNamespaceConvention con = new MappedNamespaceConvention(config);
                    MappedXMLStreamReader xmlStreamReader = new MappedXMLStreamReader(obj, con);
                    Unmarshaller unmarshaller = jc.createUnmarshaller();
                    ResourceList resourceList = (ResourceList)unmarshaller.unmarshal((XMLStreamReader)xmlStreamReader);
                    JSONObject resList = (JSONObject)obj.get("resourceList");
                    JSONArray sites = resList.getJSONArray("site");
                    HashSet<Integer> trackingSiteIds = new HashSet<Integer>();
                    int i = 0;
                    while (i < sites.length()) {
                        String idStr;
                        JSONObject jsonSite = (JSONObject)sites.get(i);
                        String href = (String)jsonSite.get("href");
                        if (href != null && (idStr = ajc$this.helper.getIdFromHref(href)) != null && ajc$this.validator.isValidInteger(idStr)) {
                            trackingSiteIds.add(Integer.valueOf(idStr));
                        }
                        ++i;
                    }
                    if (resourceList != null && siteId != null && ajc$this.validator.isValidInteger(siteId)) {
                        com.ericsson.cms.sites.core.entities.Site backSite = ajc$this.siteManager.getSite(Integer.valueOf(siteId).intValue());
                        if (backSite == null) {
                            errors.getErrors().add(Messages.getMessage(SITES_VALIDATION_SITEID_NOT_FOUND));
                            builder = Response.status((Response.Status)Response.Status.NOT_FOUND).type(mediaType);
                        } else if (!ajc$this.validator.isValidAssociationRequest(Integer.valueOf(siteId), trackingSiteIds)) {
                            errors.getErrors().addAll(ajc$this.validator.getValidationErrors());
                            builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
                            builder.entity((Object)errors);
                        } else {
                            ajc$this.siteManager.associateTrackingSites(trackingSiteIds, Integer.valueOf(siteId).intValue());
                            com.ericsson.cms.sites.core.entities.Site site = ajc$this.siteManager.getSite(Integer.valueOf(siteId).intValue());
                            Set siteList = site.getSiteChildren();
                            if (siteList != null) {
                                for (com.ericsson.cms.sites.core.entities.Site site2 : siteList) {
                                    list.getSites().add(ajc$this.convertResponceResourceList(site2, uriInfo));
                                }
                            }
                        }
                    } else {
                        errors.getErrors().add(Messages.getMessage(SITES_VALIDATION_SITEID));
                        builder = Response.status((Response.Status)Response.Status.BAD_REQUEST).type(mediaType);
                    }
                }
                catch (Exception e) {
                    errors.getErrors().add(DATABASE_ERROR);
                    logger.error((Object)e);
                    builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
                }
            }
            catch (Exception exception) {
                errors.getErrors().add(UNAUTHORIZED_ERROR);
                builder = Response.status((Response.Status)Response.Status.UNAUTHORIZED);
            }
            if (errors.getErrors().size() > 0) {
                builder.entity((Object)errors).type(JSON_MEDIA);
            } else {
                builder = Response.ok((Object)list).type(JSON_MEDIA);
            }
        }
        return builder.build();
    }

    private static final /* synthetic */ Object associateChildSite_aroundBody3$advice(SiteService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, String contentType, String accept, String siteId, String jsonString, Request request, UriInfo uriInfo, SecurityContext sec, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return SiteService.associateChildSite_aroundBody2(ajc$this, servletRequest, authorizationHeader, contentType, accept, siteId, jsonString, request, uriInfo, sec);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Response object = SiteService.associateChildSite_aroundBody2(ajc$this, servletRequest, authorizationHeader, contentType, accept, siteId, jsonString, request, uriInfo, sec);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ com.ericsson.cms.sites.core.entities.Site doCreateChildSite_aroundBody4(SiteService ajc$this, Site childSite, String siteId, ResponseBuilderWrapper builderWrapper, Errors errors, String mediaType) {
        com.ericsson.cms.sites.core.entities.Site site = null;
        if (StringUtils.isEmpty((String)siteId) || !ajc$this.validator.isValidInteger(siteId)) {
            errors.getErrors().add(Messages.getMessage(SITES_VALIDATION_SITEID));
            builderWrapper.setResponseBuilder(Response.status((Response.Status)Response.Status.BAD_REQUEST));
        } else if (childSite != null) {
            com.ericsson.cms.sites.core.entities.Site backSite = ajc$this.siteManager.getSite(Integer.valueOf(siteId).intValue());
            if (backSite == null) {
                errors.getErrors().add("Parent Site not found");
                builderWrapper.setResponseBuilder(Response.status((Response.Status)Response.Status.NOT_FOUND));
            } else if (!(ajc$this.validator.isValidRequest(childSite) && ajc$this.validator.isValidCreateChildRequest(Integer.valueOf(siteId), childSite) && ajc$this.validator.isValidPartner(childSite, null))) {
                errors.getErrors().addAll(ajc$this.validator.getValidationErrors());
                builderWrapper.setResponseBuilder(Response.status((Response.Status)Response.Status.BAD_REQUEST));
            } else {
                site = ajc$this.helper.convertSite(childSite);
                com.ericsson.cms.sites.core.entities.Site existingSite = ajc$this.siteManager.getSiteByName(site.getName());
                if (existingSite != null) {
                    errors.getErrors().add(SITE_ALREADY_EXISTES);
                    builderWrapper.setResponseBuilder(Response.status((Response.Status)Response.Status.BAD_REQUEST));
                } else {
                    if (site instanceof TrackingSite && (backSite instanceof DistributionSite || backSite instanceof MediapathDistributionSite)) {
                        ajc$this.siteManager.createTrackingSite((TrackingSite)site, Integer.valueOf(siteId));
                    } else if ((site instanceof DistributionSite || site instanceof MediapathDistributionSite) && backSite instanceof LogicalSite) {
                        SitePartner partner = ajc$this.helper.createSitePartner(childSite);
                        ajc$this.siteManager.createDistributionSite((DistributionSite)site, Integer.valueOf(siteId), partner);
                    }
                    ajc$this.activateSite(childSite, site.getId());
                    ajc$this.helper.associatePlugins(site, childSite);
                }
            }
        }
        return site;
    }

    private static final /* synthetic */ Object doCreateChildSite_aroundBody5$advice(SiteService ajc$this, Site childSite, String siteId, ResponseBuilderWrapper builderWrapper, Errors errors, String mediaType, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return SiteService.doCreateChildSite_aroundBody4(ajc$this, childSite, siteId, builderWrapper, errors, mediaType);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            com.ericsson.cms.sites.core.entities.Site object = SiteService.doCreateChildSite_aroundBody4(ajc$this, childSite, siteId, builderWrapper, errors, mediaType);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Response.ResponseBuilder doCreateSite_aroundBody6(SiteService ajc$this, Site site, com.ericsson.cms.sites.core.entities.Site siteTosave, Errors errors) {
        com.ericsson.cms.sites.core.entities.Site existingSite = ajc$this.siteManager.getSiteByName(siteTosave.getName());
        if (existingSite != null) {
            errors.getErrors().add(SITE_ALREADY_EXISTES);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST);
        }
        if (siteTosave instanceof TrackingSite) {
            errors.getErrors().add("Tracking Site must be created as a child site.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST);
        }
        ajc$this.siteManager.save(siteTosave);
        ajc$this.helper.setPartner(siteTosave, site);
        ajc$this.activateSite(site, siteTosave.getId());
        ajc$this.helper.associatePlugins(siteTosave, site);
        ajc$this.helper.notifyUpdate(siteTosave);
        return null;
    }

    private static final /* synthetic */ Object doCreateSite_aroundBody7$advice(SiteService ajc$this, Site site, com.ericsson.cms.sites.core.entities.Site siteTosave, Errors errors, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return SiteService.doCreateSite_aroundBody6(ajc$this, site, siteTosave, errors);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Response.ResponseBuilder object = SiteService.doCreateSite_aroundBody6(ajc$this, site, siteTosave, errors);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Response deleteChildSite_aroundBody8(SiteService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, String accept, String siteId, String childSiteId, Request request, UriInfo uriInfo, SecurityContext sec) {
        String mediaType;
        Errors errors;
        Response.ResponseBuilder builder;
        block13: {
            builder = null;
            errors = new Errors();
            com.ericsson.cms.sites.core.entities.Site parentSite = null;
            mediaType = ajc$this.defineMediaType(accept);
            try {
                builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builder, PERMISSION_SITES_DELETE);
                if (builder != null) {
                    return builder.build();
                }
                try {
                    parentSite = ajc$this.siteManager.getSite(Integer.valueOf(siteId).intValue());
                    if (parentSite == null) {
                        errors.getErrors().add("Parent Site not found");
                        builder = Response.status((Response.Status)Response.Status.NOT_FOUND).type(mediaType);
                        break block13;
                    }
                    com.ericsson.cms.sites.core.entities.Site childSite = ajc$this.siteManager.getSite(Integer.valueOf(childSiteId).intValue());
                    if (childSite == null) {
                        errors.getErrors().add("Child Site not found");
                        builder = Response.status((Response.Status)Response.Status.NOT_FOUND).type(mediaType);
                        break block13;
                    }
                    if (childSite instanceof TrackingSite && parentSite instanceof DistributionSite) {
                        if (((TrackingSite)childSite).getParents().size() > 1) {
                            ajc$this.siteManager.dissociateTrackingSite(childSite.getId().intValue(), parentSite.getId().intValue());
                        } else {
                            ajc$this.siteManager.delete(childSite.getId().intValue());
                        }
                        break block13;
                    }
                    if (childSite instanceof DistributionSite && parentSite instanceof LogicalSite) {
                        ajc$this.siteManager.delete(childSite.getId().intValue());
                        break block13;
                    }
                    errors.getErrors().add("Cannot delete site. Sites might not be associated");
                    builder = Response.status((Response.Status)Response.Status.NOT_FOUND).type(mediaType);
                }
                catch (Exception e) {
                    errors.getErrors().add(DATABASE_ERROR);
                    logger.error((Object)e);
                    builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(mediaType);
                }
            }
            catch (Exception exception) {
                errors.getErrors().add(UNAUTHORIZED_ERROR);
                builder = Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(mediaType);
            }
        }
        if (errors.getErrors().size() > 0) {
            builder.entity((Object)errors).type(mediaType);
        } else {
            builder = Response.status((Response.Status)Response.Status.NO_CONTENT).type(mediaType);
        }
        return builder.build();
    }

    private static final /* synthetic */ Object deleteChildSite_aroundBody9$advice(SiteService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, String accept, String siteId, String childSiteId, Request request, UriInfo uriInfo, SecurityContext sec, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return SiteService.deleteChildSite_aroundBody8(ajc$this, servletRequest, authorizationHeader, accept, siteId, childSiteId, request, uriInfo, sec);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Response object = SiteService.deleteChildSite_aroundBody8(ajc$this, servletRequest, authorizationHeader, accept, siteId, childSiteId, request, uriInfo, sec);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Response getSite_aroundBody10(SiteService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, String accept, String siteId, Date lastModified, Request request, UriInfo uriInfo, SecurityContext sec) {
        Errors errors;
        Response.ResponseBuilder builder;
        block8: {
            com.ericsson.cms.sites.core.entities.Site site = null;
            Site siteTo = null;
            builder = null;
            errors = new Errors();
            ajc$this.helper = new SiteServiceHelper();
            String mediaType = ajc$this.defineMediaType(accept);
            try {
                builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builder, PERMISSION_SITES_VIEW);
                if (builder != null) {
                    return builder.build();
                }
                try {
                    site = ajc$this.siteManager.getSite(Integer.valueOf(siteId).intValue());
                    if (site != null) {
                        siteTo = ajc$this.helper.convertFromBackendSite(site, uriInfo);
                        ajc$this.setHref(siteTo, uriInfo);
                        builder = Response.ok((Object)siteTo).type(mediaType);
                        break block8;
                    }
                    errors.getErrors().add("Site not found");
                    builder = Response.status((Response.Status)Response.Status.NOT_FOUND).type(mediaType);
                }
                catch (NumberFormatException numberFormatException) {
                    errors.getErrors().add("Invalid siteId");
                    builder = Response.status((Response.Status)Response.Status.BAD_REQUEST).type(mediaType);
                }
                catch (Exception e) {
                    errors.getErrors().add(e.getLocalizedMessage());
                    builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(mediaType);
                }
            }
            catch (Exception exception) {
                errors.getErrors().add(UNAUTHORIZED_ERROR);
                builder = Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(mediaType);
            }
        }
        if (errors.getErrors().size() > 0) {
            builder.entity((Object)errors);
        }
        return builder.build();
    }

    private static final /* synthetic */ Object getSite_aroundBody11$advice(SiteService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, String accept, String siteId, Date lastModified, Request request, UriInfo uriInfo, SecurityContext sec, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return SiteService.getSite_aroundBody10(ajc$this, servletRequest, authorizationHeader, accept, siteId, lastModified, request, uriInfo, sec);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Response object = SiteService.getSite_aroundBody10(ajc$this, servletRequest, authorizationHeader, accept, siteId, lastModified, request, uriInfo, sec);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Response getTypeList_aroundBody12(SiteService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, Date expires, String accept, Request request, String siteType, String detail, UriInfo uriInfo, SecurityContext sec) {
        Response.ResponseBuilder builder;
        block23: {
            builder = null;
            ResourceList list = new ResourceList();
            Errors errors = new Errors();
            ajc$this.helper = new SiteServiceHelper();
            SiteListDetail siteListDetail = null;
            try {
                siteListDetail = SiteListDetail.valueOf(detail);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                errors.getErrors().add("Invalid 'detail' parameter");
                builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
                builder.entity((Object)errors);
                return builder.build();
            }
            String mediaType = ajc$this.defineMediaType(accept);
            try {
                builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builder, PERMISSION_SITES_VIEW);
                if (builder != null) {
                    return builder.build();
                }
                try {
                    if (siteType != null && !siteType.isEmpty()) {
                        if (siteType.equalsIgnoreCase("distribution")) {
                            Date startTime = new Date();
                            List allDistSites = ajc$this.siteManager.getAllDistributionSites();
                            List<DistributionSite> distSites = ajc$this.getDistSitesOnly(allDistSites);
                            Date endTime = new Date();
                            logger.debug((Object)("Time to retrieve all sites from db - time: " + (endTime.getTime() - startTime.getTime()) + "; siteCount: " + distSites.size()));
                            startTime = new Date();
                            for (com.ericsson.cms.sites.core.entities.Site site : distSites) {
                                list.getSites().add(ajc$this.convertResponseSite(site, uriInfo, siteListDetail));
                            }
                            endTime = new Date();
                            logger.debug((Object)("Time to process sites and access lazy loaded properties - time: " + (endTime.getTime() - startTime.getTime()) + "; siteCount: " + distSites.size()));
                        } else if (siteType.equalsIgnoreCase("cmssender")) {
                            Date startTime = new Date();
                            List<com.ericsson.cms.sites.core.entities.Site> mediapathList = ajc$this.getAllMediapathSites();
                            Date endTime = new Date();
                            logger.debug((Object)("Time to retrieve all sites from db - time: " + (endTime.getTime() - startTime.getTime()) + "; siteCount: " + mediapathList.size()));
                            startTime = new Date();
                            for (com.ericsson.cms.sites.core.entities.Site site : mediapathList) {
                                list.getSites().add(ajc$this.convertResponseSite(site, uriInfo, siteListDetail));
                            }
                            endTime = new Date();
                            logger.debug((Object)("Time to process sites and access lazy loaded properties - time: " + (endTime.getTime() - startTime.getTime()) + "; siteCount: " + mediapathList.size()));
                        } else if (siteType.equalsIgnoreCase("logical")) {
                            Date startTime = new Date();
                            List<com.ericsson.cms.sites.core.entities.Site> logicalList = ajc$this.getAllLogicalSites();
                            Date endTime = new Date();
                            logger.debug((Object)("Time to retrieve all sites from db - time: " + (endTime.getTime() - startTime.getTime()) + "; siteCount: " + logicalList.size()));
                            startTime = new Date();
                            for (com.ericsson.cms.sites.core.entities.Site site : logicalList) {
                                list.getSites().add(ajc$this.convertResponseSite(site, uriInfo, siteListDetail));
                            }
                            endTime = new Date();
                            logger.debug((Object)("Time to process sites and access lazy loaded properties - time: " + (endTime.getTime() - startTime.getTime()) + "; siteCount: " + logicalList.size()));
                        } else if (siteType.equalsIgnoreCase("tracking")) {
                            Date startTime = new Date();
                            List trackingList = ajc$this.siteManager.getAllTrackingSites();
                            Date endTime = new Date();
                            logger.debug((Object)("Time to retrieve all sites from db - time: " + (endTime.getTime() - startTime.getTime()) + "; siteCount: " + trackingList.size()));
                            startTime = new Date();
                            for (com.ericsson.cms.sites.core.entities.Site site : trackingList) {
                                list.getSites().add(ajc$this.convertResponseSite(site, uriInfo, siteListDetail));
                            }
                            endTime = new Date();
                            logger.debug((Object)("Time to process sites and access lazy loaded properties - time: " + (endTime.getTime() - startTime.getTime()) + "; siteCount: " + trackingList.size()));
                        }
                    } else {
                        Date startTime = new Date();
                        List siteList = ajc$this.siteManager.getAllSites();
                        Date endTime = new Date();
                        logger.debug((Object)("Time to retrieve all sites from db - time: " + (endTime.getTime() - startTime.getTime()) + "; siteCount: " + siteList.size()));
                        startTime = new Date();
                        if (siteList != null) {
                            for (com.ericsson.cms.sites.core.entities.Site site : siteList) {
                                if (siteListDetail != null && siteListDetail.equals((Object)SiteListDetail.treeSummary) && (site instanceof TrackingSite || site instanceof DistributionSite) && !site.getSiteParents().isEmpty()) continue;
                                list.getSites().add(ajc$this.convertResponseSite(site, uriInfo, siteListDetail));
                            }
                        }
                        endTime = new Date();
                        logger.debug((Object)("Time to process sites and access lazy loaded properties - time: " + (endTime.getTime() - startTime.getTime()) + "; siteCount: " + (siteList == null ? "null" : Integer.valueOf(siteList.size()))));
                    }
                    if (mediaType.toLowerCase().startsWith(JSON_MEDIA)) {
                        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ResourceList.class});
                        HashMap<String, String> xmlToJsonNamespaces = new HashMap<String, String>();
                        xmlToJsonNamespaces.put("http://satv.ericsson.org/cms/services", "");
                        xmlToJsonNamespaces.put("http://www.w3.org/2001/XMLSchema-instance", "");
                        Configuration configuration = new Configuration(xmlToJsonNamespaces);
                        configuration.setSupressAtAttributes(true);
                        MappedNamespaceConvention con = new MappedNamespaceConvention(configuration);
                        StringWriter writer = new StringWriter();
                        MappedXMLStreamWriter xmlStreamWriter = new MappedXMLStreamWriter(con, (Writer)writer);
                        Marshaller marshaller = jc.createMarshaller();
                        marshaller.marshal((Object)list, (XMLStreamWriter)xmlStreamWriter);
                        builder = Response.ok((Object)writer.toString()).type(JSON_MEDIA);
                        break block23;
                    }
                    builder = Response.ok((Object)list).type(mediaType);
                }
                catch (Exception e) {
                    errors.getErrors().add(DATABASE_ERROR);
                    logger.error((Object)e);
                    builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(mediaType);
                }
            }
            catch (Exception exception) {
                errors.getErrors().add(UNAUTHORIZED_ERROR);
                builder = Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(mediaType);
            }
        }
        return builder.build();
    }

    private static final /* synthetic */ Object getTypeList_aroundBody13$advice(SiteService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, Date expires, String accept, Request request, String siteType, String detail, UriInfo uriInfo, SecurityContext sec, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return SiteService.getTypeList_aroundBody12(ajc$this, servletRequest, authorizationHeader, expires, accept, request, siteType, detail, uriInfo, sec);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Response object = SiteService.getTypeList_aroundBody12(ajc$this, servletRequest, authorizationHeader, expires, accept, request, siteType, detail, uriInfo, sec);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Response listSiteChildren_aroundBody14(SiteService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, String accept, String siteId, Request request, UriInfo uriInfo, SecurityContext sec) {
        Response.ResponseBuilder builder;
        block8: {
            builder = null;
            ResourceList list = new ResourceList();
            ajc$this.helper = new SiteServiceHelper();
            String mediaType = ajc$this.defineMediaType(accept);
            Errors errors = new Errors();
            try {
                builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builder, PERMISSION_SITES_VIEW);
                if (builder != null) {
                    return builder.build();
                }
                try {
                    com.ericsson.cms.sites.core.entities.Site site = ajc$this.siteManager.getSite(Integer.valueOf(siteId).intValue());
                    Set siteList = site.getSiteChildren();
                    if (siteList != null) {
                        for (com.ericsson.cms.sites.core.entities.Site site2 : siteList) {
                            list.getSites().add(ajc$this.convertResponseSite(site2, uriInfo));
                        }
                    }
                    if (mediaType.startsWith(JSON_MEDIA)) {
                        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ResourceList.class});
                        HashMap<String, String> xmlToJsonNamespaces = new HashMap<String, String>();
                        xmlToJsonNamespaces.put("http://satv.ericsson.org/cms/services", "");
                        xmlToJsonNamespaces.put("http://www.w3.org/2001/XMLSchema-instance", "");
                        Configuration config = new Configuration(xmlToJsonNamespaces);
                        config.setSupressAtAttributes(true);
                        MappedNamespaceConvention con = new MappedNamespaceConvention(config);
                        StringWriter writer = new StringWriter();
                        MappedXMLStreamWriter xmlStreamWriter = new MappedXMLStreamWriter(con, (Writer)writer);
                        Marshaller marshaller = jc.createMarshaller();
                        marshaller.marshal((Object)list, (XMLStreamWriter)xmlStreamWriter);
                        builder = Response.ok((Object)writer.toString()).type(JSON_MEDIA);
                        break block8;
                    }
                    builder = Response.ok((Object)list).type(mediaType);
                }
                catch (Exception e) {
                    errors.getErrors().add(DATABASE_ERROR);
                    logger.error((Object)e);
                    builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(mediaType);
                }
            }
            catch (Exception exception) {
                errors.getErrors().add(UNAUTHORIZED_ERROR);
                builder = Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(mediaType);
            }
        }
        return builder.build();
    }

    private static final /* synthetic */ Object listSiteChildren_aroundBody15$advice(SiteService ajc$this, HttpServletRequest servletRequest, String authorizationHeader, String accept, String siteId, Request request, UriInfo uriInfo, SecurityContext sec, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return SiteService.listSiteChildren_aroundBody14(ajc$this, servletRequest, authorizationHeader, accept, siteId, request, uriInfo, sec);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Response object = SiteService.listSiteChildren_aroundBody14(ajc$this, servletRequest, authorizationHeader, accept, siteId, request, uriInfo, sec);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ com.ericsson.cms.sites.core.entities.Site doUpdateSite_aroundBody16(SiteService ajc$this, String siteId, Site site, String cascadeActivate, ResponseBuilderWrapper builderWrapper, Errors errors, String mediaType) {
        com.ericsson.cms.sites.core.entities.Site backSite = ajc$this.siteManager.getSite(Integer.valueOf(siteId).intValue());
        if (backSite == null) {
            errors.getErrors().add(Messages.getMessage(SITES_VALIDATION_SITEID_NOT_FOUND));
            builderWrapper.setResponseBuilder(Response.status((Response.Status)Response.Status.NOT_FOUND));
        } else if (!backSite.getName().equalsIgnoreCase(site.getName()) && ajc$this.siteManager.getSiteByName(site.getName()) != null) {
            errors.getErrors().add(SITE_ALREADY_EXISTES);
            builderWrapper.setResponseBuilder(Response.status((Response.Status)Response.Status.BAD_REQUEST));
        } else if (!ajc$this.validator.isValidType(site, backSite)) {
            errors.getErrors().add("Invalid Site Type");
            builderWrapper.setResponseBuilder(Response.status((Response.Status)Response.Status.BAD_REQUEST));
        } else if (!ajc$this.validator.isValidRequest(site) || !ajc$this.validator.isValidPartner(site, backSite)) {
            errors.getErrors().addAll(ajc$this.validator.getValidationErrors());
            builderWrapper.setResponseBuilder(Response.status((Response.Status)Response.Status.BAD_REQUEST));
        } else if (ajc$this.validator.hasDependsOn(site) && ajc$this.validator.isCyclicDependency(Integer.valueOf(siteId), site)) {
            errors.getErrors().addAll(ajc$this.validator.getValidationErrors());
            builderWrapper.setResponseBuilder(Response.status((Response.Status)Response.Status.BAD_REQUEST));
        } else {
            ajc$this.helper.updateSite(site, backSite);
            ajc$this.siteManager.save(backSite);
            ajc$this.helper.updatePartner(backSite, site);
            ajc$this.activateSite(backSite, site, cascadeActivate);
            ajc$this.helper.associatePlugins(backSite, site);
            ajc$this.helper.notifyUpdate(backSite);
        }
        return backSite;
    }

    private static final /* synthetic */ Object doUpdateSite_aroundBody17$advice(SiteService ajc$this, String siteId, Site site, String cascadeActivate, ResponseBuilderWrapper builderWrapper, Errors errors, String mediaType, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return SiteService.doUpdateSite_aroundBody16(ajc$this, siteId, site, cascadeActivate, builderWrapper, errors, mediaType);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            com.ericsson.cms.sites.core.entities.Site object = SiteService.doUpdateSite_aroundBody16(ajc$this, siteId, site, cascadeActivate, builderWrapper, errors, mediaType);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Site convertResponceResourceList_aroundBody18(SiteService ajc$this, com.ericsson.cms.sites.core.entities.Site site2, UriInfo request) {
        Site siteTo = new Site();
        String slash = "/";
        if (request.getPath().endsWith("/")) {
            slash = "";
        }
        String href = request.getBaseUri() + request.getPath().substring(1) + slash + site2.getId();
        siteTo.setHref(href);
        return siteTo;
    }

    private static final /* synthetic */ Object convertResponceResourceList_aroundBody19$advice(SiteService ajc$this, com.ericsson.cms.sites.core.entities.Site site2, UriInfo request, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return SiteService.convertResponceResourceList_aroundBody18(ajc$this, site2, request);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Site object = SiteService.convertResponceResourceList_aroundBody18(ajc$this, site2, request);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Object convertResponseSite_aroundBody21$advice(SiteService ajc$this, com.ericsson.cms.sites.core.entities.Site site, UriInfo request, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ajc$this.convertResponseSite(site, request, SiteListDetail.full);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Site object = ajc$this.convertResponseSite(site, request, SiteListDetail.full);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Site convertResponseSite_aroundBody22(SiteService ajc$this, com.ericsson.cms.sites.core.entities.Site site, UriInfo request, SiteListDetail siteListDetail) {
        Site siteTo = ajc$this.helper.convertFromBackendSite(site, request, siteListDetail);
        String slash = "/";
        if (request.getPath().endsWith("/")) {
            slash = "";
        }
        String href = request.getBaseUri() + request.getPath().substring(1) + slash + site.getId();
        siteTo.setHref(href);
        return siteTo;
    }

    private static final /* synthetic */ Object convertResponseSite_aroundBody23$advice(SiteService ajc$this, com.ericsson.cms.sites.core.entities.Site site, UriInfo request, SiteListDetail siteListDetail, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return SiteService.convertResponseSite_aroundBody22(ajc$this, site, request, siteListDetail);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Site object = SiteService.convertResponseSite_aroundBody22(ajc$this, site, request, siteListDetail);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Site convertUpdateResponseSite_aroundBody24(SiteService ajc$this, com.ericsson.cms.sites.core.entities.Site site, UriInfo request) {
        Site siteTo = ajc$this.helper.convertFromBackendSite(site, request);
        String href = request.getBaseUri() + request.getPath().substring(1);
        siteTo.setHref(href);
        return siteTo;
    }

    private static final /* synthetic */ Object convertUpdateResponseSite_aroundBody25$advice(SiteService ajc$this, com.ericsson.cms.sites.core.entities.Site site, UriInfo request, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return SiteService.convertUpdateResponseSite_aroundBody24(ajc$this, site, request);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Site object = SiteService.convertUpdateResponseSite_aroundBody24(ajc$this, site, request);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getAllLogicalSites_aroundBody26(SiteService ajc$this) {
        ArrayList<com.ericsson.cms.sites.core.entities.Site> logicalSites = new ArrayList<com.ericsson.cms.sites.core.entities.Site>();
        List topSites = ajc$this.siteManager.getTopLevelSites();
        for (com.ericsson.cms.sites.core.entities.Site site : topSites) {
            if (!(site instanceof LogicalSite)) continue;
            logicalSites.add(site);
        }
        return logicalSites;
    }

    private static final /* synthetic */ Object getAllLogicalSites_aroundBody27$advice(SiteService ajc$this, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return SiteService.getAllLogicalSites_aroundBody26(ajc$this);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = SiteService.getAllLogicalSites_aroundBody26(ajc$this);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getAllMediapathSites_aroundBody28(SiteService ajc$this) {
        ArrayList<com.ericsson.cms.sites.core.entities.Site> sites = new ArrayList<com.ericsson.cms.sites.core.entities.Site>();
        List topSites = ajc$this.siteManager.getAllDistributionSites();
        for (com.ericsson.cms.sites.core.entities.Site site : topSites) {
            if (!(site instanceof MediapathDistributionSite)) continue;
            sites.add(site);
        }
        return sites;
    }

    private static final /* synthetic */ Object getAllMediapathSites_aroundBody29$advice(SiteService ajc$this, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return SiteService.getAllMediapathSites_aroundBody28(ajc$this);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = SiteService.getAllMediapathSites_aroundBody28(ajc$this);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

