/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.site;

import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.ISitePartnerManager;
import com.ericsson.cms.sites.core.ResourceAndTemplateUtils;
import com.ericsson.cms.sites.core.entities.ActionOnFailureOption;
import com.ericsson.cms.sites.core.entities.DistributionOption;
import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.cms.sites.core.entities.LogicalSite;
import com.ericsson.cms.sites.core.entities.SitePartner;
import com.ericsson.cms.sites.core.entities.SiteType;
import com.ericsson.cms.sites.core.entities.mediapath.MediapathDistributionSite;
import com.ericsson.cms.sites.dependency.ISitesDepCacheService;
import com.ericsson.cms.sites.distribution.TemplateInfo;
import com.ericsson.cms.sites.distribution.TemplateVariable;
import com.ericsson.cms.sites.export.ExportPlugin;
import com.ericsson.cms.sites.export.ISiteExportManager;
import com.ericsson.cms.sites.monitoring.plugins.IStatusPluginManager;
import com.ericsson.cms.sites.monitoring.plugins.StatusPluginType;
import com.tandbergtv.cms.contentmgmt.service.specification.IAssetSpecificationManager;
import com.tandbergtv.cms.services.resources.CmsSenderSite;
import com.tandbergtv.cms.services.resources.DistributionSite;
import com.tandbergtv.cms.services.resources.LookupKeysType;
import com.tandbergtv.cms.services.resources.Partner;
import com.tandbergtv.cms.services.resources.Site;
import com.tandbergtv.cms.services.resources.TrackingSite;
import com.tandbergtv.cms.services.site.SiteServiceHelper;
import com.tandbergtv.cms.services.validation.Messages;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.entities.ContainerType;
import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SiteValidator {
    private IStatusPluginManager statusPluginManager = (IStatusPluginManager)InjectionUtil.injectInstance((String)"cms/StatusPluginManager/local", IStatusPluginManager.class);
    private ISiteManager siteManager = (ISiteManager)InjectionUtil.injectInstance((String)"cms/SiteManager/local", ISiteManager.class);
    private IAssetSpecificationManager specManager = (IAssetSpecificationManager)InjectionUtil.injectInstance((String)"cms/AssetSpecificationManager/local", IAssetSpecificationManager.class);
    private ISiteExportManager exportManager = (ISiteExportManager)InjectionUtil.injectInstance((String)"cms/SiteExportManager/local", ISiteExportManager.class);
    private ISitePartnerManager sitePartnerManager = (ISitePartnerManager)InjectionUtil.injectInstance((String)"cms/SitePartnerManager/local", ISitePartnerManager.class);
    private SiteServiceHelper helper = new SiteServiceHelper();
    private List<String> errorMessages = null;
    private ISitesDepCacheService sitesDepSvc = (ISitesDepCacheService)InjectionUtil.injectInstance((String)"cms/SitesDepCacheService/local", ISitesDepCacheService.class);
    ICacheService<IContainer> containerCache = (ICacheService)ServiceRegistry.getDefault().lookup("Container Cache");

    private boolean isValidDeploymentPlugin(Site site) {
        String deplPluginId;
        Collection deploymentPlugins = this.statusPluginManager.getPlugins(StatusPluginType.DEPLOYMENT_STATUS);
        return !(site instanceof com.tandbergtv.cms.services.resources.DistributionSite ? ((com.tandbergtv.cms.services.resources.DistributionSite)site).getDeploymentStatusPlugin() != null && !((com.tandbergtv.cms.services.resources.DistributionSite)site).getDeploymentStatusPlugin().isEmpty() && (deplPluginId = this.helper.getPluginId(deploymentPlugins, ((com.tandbergtv.cms.services.resources.DistributionSite)site).getDeploymentStatusPlugin())) == null : site instanceof TrackingSite && ((TrackingSite)site).getDeploymentStatusPlugin() != null && !((TrackingSite)site).getDeploymentStatusPlugin().isEmpty() && (deplPluginId = this.helper.getPluginId(deploymentPlugins, ((TrackingSite)site).getDeploymentStatusPlugin())) == null);
    }

    private boolean isValidDistributionPlugin(Site site) {
        String distPluginId;
        Collection distPlugins = this.statusPluginManager.getPlugins(StatusPluginType.DISTRIBUTION_STATUS);
        return !(site instanceof com.tandbergtv.cms.services.resources.DistributionSite) || ((com.tandbergtv.cms.services.resources.DistributionSite)site).getDistributionStatusPlugin() == null || ((com.tandbergtv.cms.services.resources.DistributionSite)site).getDistributionStatusPlugin().isEmpty() || (distPluginId = this.helper.getPluginId(distPlugins, ((com.tandbergtv.cms.services.resources.DistributionSite)site).getDistributionStatusPlugin())) != null;
    }

    public boolean isValidRequest(Site site) {
        List<String> formatingMessages;
        List<String> failedRequiredFields;
        this.errorMessages = new ArrayList<String>();
        boolean check = true;
        if (!this.isValidDistributionPlugin(site)) {
            check = false;
            this.errorMessages.add("Invalid distribution plugin");
        }
        if (!this.isValidDeploymentPlugin(site)) {
            this.errorMessages.add("Invalid deployment plugin");
            check = false;
        }
        if ((failedRequiredFields = this.checkRequiredFields(site)) != null && !failedRequiredFields.isEmpty()) {
            this.errorMessages.addAll(failedRequiredFields);
            check = false;
        }
        if ((formatingMessages = this.checkFormatingErrors(site)) != null && !formatingMessages.isEmpty()) {
            this.errorMessages.addAll(formatingMessages);
            check = false;
        }
        return check;
    }

    private List<String> checkFormatingErrors(Site site) {
        ArrayList<String> failedFields = new ArrayList<String>();
        if (site.getName() != null && !site.getName().isEmpty() && site.getName().length() > 50) {
            failedFields.add(Messages.getMessage("Sites.format.nameLength"));
        }
        if (site.getExternalID() != null && !site.getExternalID().isEmpty() && site.getExternalID().length() > 100) {
            failedFields.add(Messages.getMessage("Sites.format.externalIdLength"));
        }
        if (site.getDescription() != null && !site.getDescription().isEmpty() && site.getDescription().length() > 255) {
            failedFields.add(Messages.getMessage("Sites.format.description"));
        }
        if (site instanceof com.tandbergtv.cms.services.resources.DistributionSite) {
            if (((com.tandbergtv.cms.services.resources.DistributionSite)site).getAlertDelayPeriod() != null && !((com.tandbergtv.cms.services.resources.DistributionSite)site).getAlertDelayPeriod().isEmpty() && !this.isValidInteger(((com.tandbergtv.cms.services.resources.DistributionSite)site).getAlertDelayPeriod())) {
                failedFields.add(Messages.getMessage("Sites.format.distributionAlert"));
            }
            if (((com.tandbergtv.cms.services.resources.DistributionSite)site).getAssociatedGroup() != null && !((com.tandbergtv.cms.services.resources.DistributionSite)site).getAssociatedGroup().isEmpty() && (((com.tandbergtv.cms.services.resources.DistributionSite)site).getAssociatedResource() == null || ((com.tandbergtv.cms.services.resources.DistributionSite)site).getAssociatedResource().isEmpty())) {
                failedFields.add(Messages.getMessage("Sites.requiredField.associatedResource"));
            }
            if (((com.tandbergtv.cms.services.resources.DistributionSite)site).getAssociatedResource() != null && !((com.tandbergtv.cms.services.resources.DistributionSite)site).getAssociatedResource().isEmpty()) {
                if (!this.isValidInteger(((com.tandbergtv.cms.services.resources.DistributionSite)site).getAssociatedResource())) {
                    failedFields.add(Messages.getMessage("Sites.format.associatedResource"));
                }
                if (((com.tandbergtv.cms.services.resources.DistributionSite)site).getAssociatedGroup() == null || ((com.tandbergtv.cms.services.resources.DistributionSite)site).getAssociatedGroup().isEmpty()) {
                    failedFields.add(Messages.getMessage("Sites.format.associatedGroupEmptyWithResource"));
                }
            }
            Partner partner = ((com.tandbergtv.cms.services.resources.DistributionSite)site).getPartner();
            this.checkPartner(failedFields, partner, site);
            if (site.getExternalID() != null && !site.getExternalID().isEmpty() && this.isExternalSiteIdAlreadyUsed(site.getExternalID(), SiteType.DISTRIBUTION)) {
                failedFields.add(Messages.getMessage("Sites.validation.externalIdUniqueForDiffTypes"));
            }
            if (((com.tandbergtv.cms.services.resources.DistributionSite)site).getMetadataFormat() != null && !this.isValidMetadataFormat(((com.tandbergtv.cms.services.resources.DistributionSite)site).getMetadataFormat())) {
                failedFields.add(Messages.getMessage("Sites.validation.invalidMetadataFormat"));
            }
            if (((com.tandbergtv.cms.services.resources.DistributionSite)site).getLookupKeys() != null && !this.isValidLookupKey(((com.tandbergtv.cms.services.resources.DistributionSite)site).getLookupKeys())) {
                failedFields.add(Messages.getMessage("Sites.validation.invalidLookUpKeys"));
            }
            if (((com.tandbergtv.cms.services.resources.DistributionSite)site).getActionOnFailure() != null && !((com.tandbergtv.cms.services.resources.DistributionSite)site).getActionOnFailure().isEmpty() && !this.validActionOnFailureOption(((com.tandbergtv.cms.services.resources.DistributionSite)site).getActionOnFailure())) {
                failedFields.add(Messages.getMessage("Sites.validation.invalidActionOnFailure"));
            }
            if (((com.tandbergtv.cms.services.resources.DistributionSite)site).getAttempts() != null && !((com.tandbergtv.cms.services.resources.DistributionSite)site).getAttempts().isEmpty() && !this.validIntegerRange(((com.tandbergtv.cms.services.resources.DistributionSite)site).getAttempts(), 0, 10)) {
                failedFields.add(Messages.getMessage("Sites.format.attempts"));
            }
            if (((com.tandbergtv.cms.services.resources.DistributionSite)site).getWaitTimeToRetry() != null && !((com.tandbergtv.cms.services.resources.DistributionSite)site).getWaitTimeToRetry().isEmpty() && !this.validIntegerRange(((com.tandbergtv.cms.services.resources.DistributionSite)site).getWaitTimeToRetry(), 0, 10)) {
                failedFields.add(Messages.getMessage("Sites.format.waitTimeToRetry"));
            }
        } else if (site instanceof com.tandbergtv.cms.services.resources.LogicalSite) {
            Partner partner = ((com.tandbergtv.cms.services.resources.LogicalSite)site).getPartner();
            this.checkPartner(failedFields, partner, site);
            if (site.getExternalID() != null && !site.getExternalID().isEmpty() && this.isExternalSiteIdAlreadyUsed(site.getExternalID(), SiteType.LOGICAL)) {
                failedFields.add(Messages.getMessage("Sites.validation.externalIdUniqueForDiffTypes"));
            }
        } else if (site instanceof TrackingSite) {
            if (((TrackingSite)site).getAlertDelayPeriod() != null && !((TrackingSite)site).getAlertDelayPeriod().isEmpty() && !this.isValidInteger(((TrackingSite)site).getAlertDelayPeriod())) {
                failedFields.add(Messages.getMessage("Sites.format.deploymentAlert"));
            }
            if (site.getExternalID() != null && !site.getExternalID().isEmpty() && this.isExternalSiteIdAlreadyUsed(site.getExternalID(), SiteType.TRACKING)) {
                failedFields.add(Messages.getMessage("Sites.validation.externalIdUniqueForDiffTypes"));
            }
        }
        return failedFields;
    }

    private boolean isValidLookupKey(LookupKeysType lookupKeys) {
        boolean check = true;
        List<String> inputKeys = lookupKeys.getLookupKeies();
        List keys = this.specManager.getAllLookupKeys();
        if (inputKeys != null && keys != null) {
            for (String input : inputKeys) {
                if (this.keyPresent(input, keys)) continue;
                check = false;
            }
        }
        return check;
    }

    private boolean keyPresent(String input, List<String> keys) {
        for (String key : keys) {
            if (!key.equalsIgnoreCase(input)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidMetadataFormat(String metadataFormat) {
        boolean check = false;
        Collection specs = this.specManager.getSpecsWithFromTTVTranslator();
        if (specs != null) {
            for (Specification spec : specs) {
                if (!spec.getName().equalsIgnoreCase(metadataFormat)) continue;
                check = true;
            }
        }
        return check;
    }

    private void checkPartner(List<String> failedFields, Partner partner, Site site) {
        if (partner != null) {
            List<Partner.Properties.Entry> entries;
            if (partner.getEmail() != null && !partner.getEmail().isEmpty()) {
                if (partner.getEmail().length() > 50) {
                    failedFields.add(Messages.getMessage("Sites.format.partner.email"));
                }
                if (!partner.getEmail().contains("@") || !partner.getEmail().contains(".")) {
                    failedFields.add(Messages.getMessage("Sites.format.partner.emailInvalidChar"));
                }
            }
            if (partner.getFirstName() != null && !partner.getFirstName().isEmpty()) {
                if (partner.getFirstName().length() > 25) {
                    failedFields.add(Messages.getMessage("Sites.format.partner.first"));
                }
                if (this.containsDigit(partner.getFirstName())) {
                    failedFields.add(Messages.getMessage("Sites.format.partner.firstNumeric"));
                }
            }
            if (partner.getLastName() != null && !partner.getLastName().isEmpty()) {
                if (partner.getLastName().length() > 25) {
                    failedFields.add(Messages.getMessage("Sites.format.partner.last"));
                }
                if (this.containsDigit(partner.getLastName())) {
                    failedFields.add(Messages.getMessage("Sites.format.partner.lastNumeric"));
                }
            }
            Partner.Properties props = partner.getProperties();
            HashSet<String> keySet = new HashSet<String>();
            if (props != null && (entries = props.getEntries()) != null && !entries.isEmpty()) {
                for (Partner.Properties.Entry entry : entries) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    keySet.add(key);
                    if (key != null && !key.isEmpty()) {
                        if (key.length() > 100) {
                            failedFields.add(Messages.getMessage("Sites.format.partner.propertyName"));
                        }
                    } else {
                        failedFields.add(Messages.getMessage("Sites.format.partner.propertyNameEmpty"));
                    }
                    if (value != null && !value.isEmpty()) {
                        if (value.length() <= 250) continue;
                        failedFields.add(Messages.getMessage("Sites.format.partner.propertyValue"));
                        continue;
                    }
                    failedFields.add(Messages.getMessage("Sites.format.partner.propertyValueEmpty"));
                }
            }
        }
    }

    public final boolean containsDigit(String s) {
        boolean containsDigit = false;
        if (s != null) {
            char[] cArray = s.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                containsDigit = Character.isDigit(c);
                if (containsDigit) break;
                ++n2;
            }
        }
        return containsDigit;
    }

    private List<String> checkRequiredFields(Site site) {
        ArrayList<String> failedFields = new ArrayList<String>();
        if (site instanceof com.tandbergtv.cms.services.resources.DistributionSite) {
            if (((com.tandbergtv.cms.services.resources.DistributionSite)site).getLookupKeys() != null) {
                if (((com.tandbergtv.cms.services.resources.DistributionSite)site).getLookupKeys().getLookupKeies() == null || ((com.tandbergtv.cms.services.resources.DistributionSite)site).getLookupKeys().getLookupKeies().isEmpty()) {
                    failedFields.add(Messages.getMessage("Sites.requiredField.fileLookUpKey"));
                }
            } else {
                failedFields.add(Messages.getMessage("Sites.requiredField.fileLookUpKey"));
            }
            if (((com.tandbergtv.cms.services.resources.DistributionSite)site).getMetadataFormat() == null || ((com.tandbergtv.cms.services.resources.DistributionSite)site).getMetadataFormat().isEmpty()) {
                failedFields.add(Messages.getMessage("Sites.requiredField.metadataFormat"));
            }
            if (((com.tandbergtv.cms.services.resources.DistributionSite)site).getDistributionOption() == null || ((com.tandbergtv.cms.services.resources.DistributionSite)site).getDistributionOption().isEmpty()) {
                failedFields.add(Messages.getMessage("Sites.requiredField.distributionOption"));
            } else if (!this.validDistOption(((com.tandbergtv.cms.services.resources.DistributionSite)site).getDistributionOption())) {
                failedFields.add(Messages.getMessage("Sites.validation.inValidDistOption"));
            } else if (((com.tandbergtv.cms.services.resources.DistributionSite)site).getDistributionOption().equalsIgnoreCase(DistributionOption.DEPENDSON.name())) {
                if (!this.isDependsOnSitesExist(((com.tandbergtv.cms.services.resources.DistributionSite)site).getDependsOnSites())) {
                    failedFields.add(Messages.getMessage("Sites.requiredField.dependsOnSites"));
                } else if (!this.isDependsOnSitesValid(((com.tandbergtv.cms.services.resources.DistributionSite)site).getDependsOnSites())) {
                    failedFields.add(Messages.getMessage("Sites.validation.invalidDependsOnSites"));
                }
            }
            if (((com.tandbergtv.cms.services.resources.DistributionSite)site).getDistributionConfiguration() == null || ((com.tandbergtv.cms.services.resources.DistributionSite)site).getDistributionConfiguration().isEmpty()) {
                failedFields.add(Messages.getMessage("Sites.requiredField.distributionConfiguration"));
            }
            if (((com.tandbergtv.cms.services.resources.DistributionSite)site).getAlertDelayPeriod() == null || ((com.tandbergtv.cms.services.resources.DistributionSite)site).getAlertDelayPeriod().isEmpty()) {
                failedFields.add(Messages.getMessage("Sites.requiredField.distributionTimeoutPeriod"));
            }
            if (this.validDistConfig(site)) {
                if (!this.requiredDistributionParamsPresent(site)) {
                    failedFields.add(Messages.getMessage("Sites.requiredField.distributionParameter"));
                }
                if (((com.tandbergtv.cms.services.resources.DistributionSite)site).getAssociatedGroup() != null && !((com.tandbergtv.cms.services.resources.DistributionSite)site).getAssociatedGroup().isEmpty() && !this.validAssociatedGroup(site, ((com.tandbergtv.cms.services.resources.DistributionSite)site).getAssociatedGroup())) {
                    failedFields.add(Messages.getMessage("Sites.validation.inValidAssociatedGroup"));
                }
            } else {
                failedFields.add(Messages.getMessage("Sites.validation.inValidDistConfig"));
            }
            if (((com.tandbergtv.cms.services.resources.DistributionSite)site).getExportConfiguration() != null && !((com.tandbergtv.cms.services.resources.DistributionSite)site).getExportConfiguration().isEmpty() && !this.validExportConfig(((com.tandbergtv.cms.services.resources.DistributionSite)site).getExportConfiguration(), ((com.tandbergtv.cms.services.resources.DistributionSite)site).getExportConfParams())) {
                failedFields.add(Messages.getMessage("Sites.validation.inValidExportConfig"));
            }
            if (this.checkMissingRetryConfiguration(site)) {
                failedFields.add(Messages.getMessage("Sites.validation.invalidRetry"));
            }
        } else if (site instanceof TrackingSite && (((TrackingSite)site).getAlertDelayPeriod() == null || ((TrackingSite)site).getAlertDelayPeriod().isEmpty())) {
            failedFields.add(Messages.getMessage("Sites.requiredField.deploymentTimeoutPeriod"));
        }
        if (site.getName() == null || site.getName().isEmpty()) {
            failedFields.add(Messages.getMessage("Sites.requiredField.Name"));
        }
        if (site.getExternalID() == null || site.getExternalID().isEmpty()) {
            failedFields.add(Messages.getMessage("Sites.requiredField.externalId"));
        }
        return failedFields;
    }

    private boolean checkMissingRetryConfiguration(Site site) {
        boolean missingAction = ((com.tandbergtv.cms.services.resources.DistributionSite)site).getActionOnFailure() == null || ((com.tandbergtv.cms.services.resources.DistributionSite)site).getActionOnFailure().isEmpty();
        boolean missingAttempts = ((com.tandbergtv.cms.services.resources.DistributionSite)site).getAttempts() == null || ((com.tandbergtv.cms.services.resources.DistributionSite)site).getAttempts().isEmpty();
        boolean missingWaitTime = ((com.tandbergtv.cms.services.resources.DistributionSite)site).getWaitTimeToRetry() == null || ((com.tandbergtv.cms.services.resources.DistributionSite)site).getWaitTimeToRetry().isEmpty();
        boolean result = false;
        if (missingAction) {
            result = true;
        }
        if (missingAttempts) {
            result = true;
        }
        if (missingWaitTime) {
            result = true;
        }
        if (missingAction && missingAttempts && missingWaitTime) {
            result = false;
        }
        return result;
    }

    private boolean validActionOnFailureOption(String actionOnFailure) {
        return actionOnFailure.equalsIgnoreCase(ActionOnFailureOption.RETRY.name());
    }

    private boolean validIntegerRange(String attempts, int min, int max) {
        try {
            Integer x = Integer.parseInt(attempts);
            return x >= min && x <= max;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean validDistOption(String distributionOption) {
        return distributionOption.equalsIgnoreCase(DistributionOption.IMMEDIATE.name()) || distributionOption.equalsIgnoreCase(DistributionOption.MANUAL.name()) || distributionOption.equalsIgnoreCase(DistributionOption.TIMED.name()) || distributionOption.equalsIgnoreCase(DistributionOption.DEPENDSON.name());
    }

    private boolean isDependsOnSitesExist(DistributionSite.DependsOnSites dependsOnSites) {
        return dependsOnSites != null && !dependsOnSites.getDependsOnSite().isEmpty();
    }

    private boolean isDependsOnSitesValid(DistributionSite.DependsOnSites dependsOnSites) {
        List<DistributionSite.DependsOnSites.DependsOnSite> dependentSites = dependsOnSites.getDependsOnSite();
        for (DistributionSite.DependsOnSites.DependsOnSite depSite : dependentSites) {
            com.ericsson.cms.sites.core.entities.Site site = this.siteManager.getSite(depSite.getId());
            if (site == null) {
                return false;
            }
            if (site.getType() == SiteType.DISTRIBUTION) continue;
            return false;
        }
        return true;
    }

    public boolean isCyclicDependency(Integer siteId, Site site) {
        boolean isCyclic = false;
        DistributionSite.DependsOnSites dependsOnSites = ((com.tandbergtv.cms.services.resources.DistributionSite)site).getDependsOnSites();
        if (this.isDependsOnSitesExist(dependsOnSites)) {
            List<DistributionSite.DependsOnSites.DependsOnSite> dependentSites = dependsOnSites.getDependsOnSite();
            List nonUsableSites = this.sitesDepSvc.getNonUsableSitesForDependOn(siteId);
            for (DistributionSite.DependsOnSites.DependsOnSite depSite : dependentSites) {
                if (siteId.intValue() == depSite.getId()) {
                    this.errorMessages.add("The site can not be depend on itself.");
                    isCyclic = true;
                }
                if (!nonUsableSites.contains(depSite.getId())) continue;
                this.errorMessages.add("The current site has a dependency on site Id " + depSite.getId() + ", so " + "it can not be selected as a dependent site.");
                isCyclic = true;
            }
        } else {
            this.errorMessages.add(Messages.getMessage("Sites.requiredField.dependsOnSites"));
            isCyclic = true;
        }
        return isCyclic;
    }

    public boolean hasDependsOn(Site site) {
        return (site instanceof com.tandbergtv.cms.services.resources.DistributionSite || site instanceof CmsSenderSite) && ((com.tandbergtv.cms.services.resources.DistributionSite)site).getDistributionOption().equalsIgnoreCase(DistributionOption.DEPENDSON.name());
    }

    private boolean validExportConfig(String exportConfiguration, DistributionSite.ExportConfParams exportConfParams) {
        boolean check = false;
        Set plugins = this.exportManager.getAllPlugins();
        if (plugins != null) {
            for (ExportPlugin plugin : plugins) {
                if (!plugin.getName().equalsIgnoreCase(exportConfiguration)) continue;
                if (exportConfParams != null) {
                    List<DistributionSite.ExportConfParams.Entry> entries = exportConfParams.getEntries();
                    for (DistributionSite.ExportConfParams.Entry entry : entries) {
                        if (this.configParamPresent(entry.getKey(), plugin.getParamNames())) continue;
                        return false;
                    }
                    check = true;
                    continue;
                }
                check = true;
            }
        }
        return check;
    }

    private boolean configParamPresent(String key, List<String> paramNames) {
        if (paramNames != null) {
            for (String name : paramNames) {
                if (!key.equalsIgnoreCase(name)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean validAssociatedGroup(Site site, String associatedGroupName) {
        List groupList;
        boolean check = false;
        String templateName = ((com.tandbergtv.cms.services.resources.DistributionSite)site).getDistributionConfiguration();
        if (templateName != null && !templateName.isEmpty() && (groupList = ResourceAndTemplateUtils.getAllGroupNamesByTemplate((String)templateName)) != null && !groupList.isEmpty()) {
            for (String groupName : groupList) {
                if (!groupName.equalsIgnoreCase(associatedGroupName)) continue;
                check = true;
            }
        }
        return check;
    }

    private boolean validDistConfig(Site site) {
        boolean check = false;
        Set templatesInfo = this.siteManager.getDistributionTemplatesInfo();
        if (templatesInfo != null) {
            for (TemplateInfo templateInfo : templatesInfo) {
                if (((com.tandbergtv.cms.services.resources.DistributionSite)site).getDistributionConfiguration() == null || ((com.tandbergtv.cms.services.resources.DistributionSite)site).getDistributionConfiguration().isEmpty() || !((com.tandbergtv.cms.services.resources.DistributionSite)site).getDistributionConfiguration().equalsIgnoreCase(templateInfo.getTemplateName())) continue;
                check = true;
            }
        }
        return check;
    }

    private boolean requiredDistributionParamsPresent(Site site) {
        Set templatesInfo = this.siteManager.getDistributionTemplatesInfo();
        if (templatesInfo != null) {
            for (TemplateInfo templateInfo : templatesInfo) {
                Map requiredVariables;
                if (((com.tandbergtv.cms.services.resources.DistributionSite)site).getDistributionConfiguration() == null || ((com.tandbergtv.cms.services.resources.DistributionSite)site).getDistributionConfiguration().isEmpty() || !((com.tandbergtv.cms.services.resources.DistributionSite)site).getDistributionConfiguration().equalsIgnoreCase(templateInfo.getTemplateName()) || (requiredVariables = templateInfo.getRequiredVariables()) == null) continue;
                for (Map.Entry requiredVariable : requiredVariables.entrySet()) {
                    String cfr_ignored_0 = (String)requiredVariable.getKey();
                    TemplateVariable templateVariable = (TemplateVariable)requiredVariable.getValue();
                    String mappedName = templateVariable.getMappedName();
                    if (((com.tandbergtv.cms.services.resources.DistributionSite)site).getDistConfParams() != null && !((com.tandbergtv.cms.services.resources.DistributionSite)site).getDistConfParams().getEntries().isEmpty()) {
                        List<DistributionSite.DistConfParams.Entry> entries = ((com.tandbergtv.cms.services.resources.DistributionSite)site).getDistConfParams().getEntries();
                        if (this.distParamsSpecified(entries, mappedName)) continue;
                        return false;
                    }
                    return false;
                }
            }
        }
        return true;
    }

    private boolean distParamsSpecified(List<DistributionSite.DistConfParams.Entry> entries, String mappedName) {
        boolean found = false;
        for (DistributionSite.DistConfParams.Entry entry : entries) {
            if (!entry.getKey().equalsIgnoreCase(mappedName) || entry.getValue() == null || entry.getValue().isEmpty()) continue;
            found = true;
        }
        return found;
    }

    public Collection<? extends String> getValidationErrors() {
        return this.errorMessages;
    }

    public boolean isValidInteger(String input) {
        try {
            Integer x = Integer.parseInt(input);
            return x >= 0 && x <= Integer.MAX_VALUE;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isExternalSiteIdAlreadyUsed(String externalSiteId, SiteType type) {
        return this.siteManager.isExternalSiteIdAlreadyUsed(externalSiteId, type);
    }

    public boolean isValidAssociationRequest(Integer distSiteId, Set<Integer> trackingSiteIds) {
        this.errorMessages = new ArrayList<String>();
        boolean check = true;
        com.ericsson.cms.sites.core.entities.Site distSite = this.siteManager.getSite(distSiteId.intValue());
        if (distSite != null && !(distSite instanceof DistributionSite)) {
            this.errorMessages.add(Messages.getMessage("Sites.association.invalidParentSite"));
            check = false;
        }
        for (Integer trackingId : trackingSiteIds) {
            com.ericsson.cms.sites.core.entities.Site trackingSite = this.siteManager.getSite(trackingId.intValue());
            if (trackingSite != null) {
                if (trackingSite instanceof com.ericsson.cms.sites.core.entities.TrackingSite) continue;
                this.errorMessages.add(Messages.getMessage("Sites.association.invalidTrackingSite"));
                check = false;
                continue;
            }
            this.errorMessages.add(Messages.getMessage("Sites.association.trackingSiteNotFound " + trackingId));
            check = false;
        }
        return check;
    }

    public boolean isValidCreateChildRequest(Integer parentSiteId, Site metadata) {
        com.ericsson.cms.sites.core.entities.Site site;
        this.errorMessages = new ArrayList<String>();
        boolean check = true;
        if (!(parentSiteId == null || metadata == null || (site = this.siteManager.getSite(parentSiteId.intValue())) == null || site instanceof LogicalSite && metadata instanceof com.tandbergtv.cms.services.resources.DistributionSite || site instanceof DistributionSite && metadata instanceof TrackingSite)) {
            this.errorMessages.add(Messages.getMessage("Sites.createChild.invalidParentChildCombination"));
            check = false;
        }
        return check;
    }

    public boolean isValidPartner(Site site, com.ericsson.cms.sites.core.entities.Site backSite) {
        boolean check = true;
        Partner partner = null;
        SitePartner associatedPartner = null;
        this.errorMessages = new ArrayList<String>();
        if (site instanceof com.tandbergtv.cms.services.resources.DistributionSite) {
            partner = ((com.tandbergtv.cms.services.resources.DistributionSite)site).getPartner();
        } else if (site instanceof com.tandbergtv.cms.services.resources.LogicalSite) {
            partner = ((com.tandbergtv.cms.services.resources.LogicalSite)site).getPartner();
        }
        if (backSite != null) {
            associatedPartner = this.sitePartnerManager.get(backSite.getId().intValue());
        }
        if (partner != null) {
            IContainer container;
            if (partner.getProviderId() != null && !partner.getProviderId().isEmpty()) {
                if (partner.getProviderId().length() > 25) {
                    this.errorMessages.add(Messages.getMessage("Sites.format.partner.providerId"));
                    check = false;
                }
                for (Serializable key : this.containerCache.getKeys()) {
                    String providerId;
                    container = (IContainer)this.containerCache.get(key);
                    if (container.getContainerType() != ContainerType.PARTNER || (providerId = ((com.tandbergtv.watchpoint.pmm.entities.Partner)container).getProviderId()) == null || !providerId.trim().equals(partner.getProviderId().trim())) continue;
                    if (associatedPartner == null) {
                        if (partner.getContextId() != null && !partner.getContextId().equals("")) continue;
                        this.errorMessages.add("Partner with the same Provider Id already exists.");
                        check = false;
                        break;
                    }
                    if (container.getContainerId() == associatedPartner.getContextId()) continue;
                    this.errorMessages.add("Partner with the same Provider Id already exists.");
                    check = false;
                    break;
                }
            }
            if (partner.getLookupKey() != null && !partner.getLookupKey().isEmpty()) {
                if (partner.getLookupKey().length() > 25) {
                    this.errorMessages.add(Messages.getMessage("Sites.format.partner.lookUpKey"));
                    check = false;
                }
                for (Serializable key : this.containerCache.getKeys()) {
                    container = (IContainer)this.containerCache.get(key);
                    if (container.getContainerLookupKey() == null || !container.getContainerLookupKey().trim().equals(partner.getLookupKey().trim())) continue;
                    if (associatedPartner == null) {
                        if (partner.getContextId() != null && !partner.getContextId().equals("")) continue;
                        this.errorMessages.add("Partner with the same lookup key already exists.");
                        check = false;
                        break;
                    }
                    if (container.getContainerId() == associatedPartner.getContextId()) continue;
                    this.errorMessages.add("Partner with the same lookup key already exists.");
                    check = false;
                    break;
                }
            }
        }
        return check;
    }

    public boolean isValidType(Site site, com.ericsson.cms.sites.core.entities.Site backSite) {
        if (site != null && backSite != null) {
            if (site instanceof com.tandbergtv.cms.services.resources.LogicalSite && backSite instanceof LogicalSite) {
                return true;
            }
            if (site instanceof CmsSenderSite && backSite instanceof MediapathDistributionSite) {
                return true;
            }
            if (site instanceof com.tandbergtv.cms.services.resources.DistributionSite && backSite instanceof DistributionSite && !(site instanceof CmsSenderSite) && !(backSite instanceof MediapathDistributionSite)) {
                return true;
            }
            if (site instanceof TrackingSite && backSite instanceof com.ericsson.cms.sites.core.entities.TrackingSite) {
                return true;
            }
        }
        return false;
    }
}

