/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.titles;

import com.ericsson.cms.categorymgmt.entity.CatCategory;
import com.ericsson.cms.categorymgmt.service.ICategoryManager;
import com.tandbergtv.cms.services.AuthorizationException;
import com.tandbergtv.cms.services.titles.ICategoryService;
import com.tandbergtv.cms.services.titles.JsonMarshaller;
import com.tandbergtv.cms.services.titles.ResponseUtil;
import com.tandbergtv.cms.services.titles.TitleListParameterBuilder;
import com.tandbergtv.cms.services.titles.XmlMarshaller;
import com.tandbergtv.cms.util.EndpointsAuthorizationUtil;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.EJBAccessException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;

public class CategoryService
implements ICategoryService {
    private static final Logger logger = Logger.getLogger(CategoryService.class);
    private ICategoryManager categoryManager = (ICategoryManager)InjectionUtil.injectInstance((String)"cms/CategoryManager/local", ICategoryManager.class);
    private JsonMarshaller jsonMarshaller = new JsonMarshaller();
    private XmlMarshaller xmlMarshaller = new XmlMarshaller();

    @Override
    public Response getCategories(HttpServletRequest servletReq, Request request, String authorizationHeader) {
        try {
            Response.ResponseBuilder builder = null;
            builder = EndpointsAuthorizationUtil.authorizePermissions(servletReq, builder, "CategoryManager_View");
            if (builder != null) {
                return builder.build();
            }
            TitleListParameterBuilder paramBld = new TitleListParameterBuilder();
            paramBld.setMediaType(request);
            List categories = this.categoryManager.listCategories();
            logger.debug((Object)("categories: " + categories));
            LinkedHashMap<Long, List<CatCategory>> groupedCategories = new LinkedHashMap<Long, List<CatCategory>>();
            for (CatCategory category : categories) {
                if (category.getId().equals(category.getParentId())) continue;
                if (groupedCategories.get(category.getParentId()) == null) {
                    groupedCategories.put(category.getParentId(), new ArrayList());
                }
                ((List)groupedCategories.get(category.getParentId())).add(category);
            }
            List<CategoryResponse> categoriesResponse = this.buildResponseTree(groupedCategories);
            String output = paramBld.getMediaType().equals((Object)MediaType.APPLICATION_JSON_TYPE) ? this.jsonMarshaller.getCategoriesAsJson(categoriesResponse) : this.xmlMarshaller.getCategoriesAsXml(categoriesResponse);
            return Response.status((Response.Status)Response.Status.OK).header("Cache-Control", (Object)"NO-CACHE").type(paramBld.getMediaType()).entity((Object)output).build();
        }
        catch (IllegalArgumentException e) {
            return ResponseUtil.createBadRequestResponse(e.getMessage());
        }
        catch (AuthorizationException authorizationException) {
            return ResponseUtil.createUnauthorizedResponse();
        }
        catch (EJBAccessException eJBAccessException) {
            return ResponseUtil.createUnauthorizedResponse();
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof IllegalArgumentException) {
                return ResponseUtil.createBadRequestResponse(ex.getMessage());
            }
            logger.error((Object)"error happened", (Throwable)ex);
            return ResponseUtil.createInternalServerErrorResponse(ex.getMessage());
        }
    }

    private List<CategoryResponse> buildResponseTree(Map<Long, List<CatCategory>> groupedCategories) {
        return this.buildResponseTree(groupedCategories, 0L, "");
    }

    private List<CategoryResponse> buildResponseTree(Map<Long, List<CatCategory>> groupedCategories, Long currentNode, String currentPath) {
        ArrayList<CategoryResponse> categories = new ArrayList<CategoryResponse>();
        if (groupedCategories.get(currentNode) != null) {
            for (CatCategory category : groupedCategories.get(currentNode)) {
                CategoryResponse catRes = new CategoryResponse();
                catRes.name = category.getName();
                catRes.path = currentPath == "" ? catRes.name : String.valueOf(currentPath) + "/" + catRes.name;
                catRes.children = this.buildResponseTree(groupedCategories, category.getId(), catRes.path);
                categories.add(catRes);
            }
        }
        return categories;
    }

    public static class CategoryResponse {
        public String name;
        public String path;
        public List<CategoryResponse> children = new ArrayList<CategoryResponse>();
    }
}

