/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.titles;

import com.ericsson.cms.criteria.FieldType;
import com.tandbergtv.cms.services.titles.FieldAlias;
import com.tandbergtv.cms.services.titles.TitleServiceNG;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class FieldAliases {
    private static final Logger logger = Logger.getLogger(FieldAliases.class);
    private static FieldAliases singleton;
    private Map<String, FieldAlias> aliases = new HashMap<String, FieldAlias>();

    private FieldAliases() {
        InputStream is = TitleServiceNG.class.getResourceAsStream("/TitleServiceFieldAliases.dat");
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#") || line.trim().isEmpty()) continue;
                String[] parts = line.split(",");
                if (parts.length != 3) {
                    logger.warn((Object)("Invalid line in TitleServiceFieldAliases.dat: " + line));
                    continue;
                }
                String alias = parts[0].trim();
                FieldType fieldType = FieldType.valueOf((String)parts[1].trim());
                String field = parts[2].trim();
                this.aliases.put(alias, new FieldAlias(fieldType, field));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not load field aliases.", ex);
        }
    }

    public static synchronized FieldAliases getInstance() {
        if (singleton == null) {
            singleton = new FieldAliases();
        }
        return singleton;
    }

    public boolean containsAlias(String key) {
        return this.aliases.containsKey(key);
    }

    public FieldAlias getFieldAlias(String key) {
        return this.aliases.get(key);
    }
}

