/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.titles;

import com.ericsson.neptune.security.authprovider.AuthProviderClient;
import com.ericsson.neptune.security.util.SSLUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.net.ssl.HttpsURLConnection;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInput;

public class FileUploadUtil {
    private static final Logger logger = Logger.getLogger(FileUploadUtil.class);
    private static final String BASE_UPLOAD_PATH = "uploadedAssets";
    private static final String CONTENT_LOCATION_SETTINGS_GROUP = "com.ericsson.cms.pmm.pmm";
    private static final String REST_BASE_URL = "https://app:8443/cms/services/settings/";
    protected AuthProviderClient providerClient = new AuthProviderClient();

    private String getBaseUploadPath() throws Exception {
        try {
            String json = this.makeRequest(CONTENT_LOCATION_SETTINGS_GROUP);
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode node = (JsonNode)objectMapper.readValue(json, JsonNode.class);
            JsonNode uploadedAssets = node.get(BASE_UPLOAD_PATH);
            if (uploadedAssets != null) {
                return uploadedAssets.asText();
            }
            throw new Exception("Could not find neptune settings for uploadedAssets");
        }
        catch (Exception ex) {
            logger.error((Object)"Error parsing neptune settings response", (Throwable)ex);
            throw ex;
        }
    }

    private String makeRequest(String restUrl) throws IOException {
        URL url = new URL(REST_BASE_URL + restUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (conn instanceof HttpsURLConnection) {
            ((HttpsURLConnection)conn).setSSLSocketFactory(SSLUtil.getInstance().getSslSocketFactory());
        }
        conn.setDoOutput(true);
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Accept", "application/json");
        conn.connect();
        String validationResponse = this.providerClient.readRequestResponse(conn);
        if (conn.getResponseCode() != 200 || validationResponse == null || validationResponse.isEmpty()) {
            logger.error((Object)("Got invalid response from neptune with status " + conn.getResponseCode() + " and response " + validationResponse));
            return "";
        }
        return validationResponse;
    }

    public File uploadFile(String providerId, long titleId, long assetId, MultipartFormDataInput input) {
        File file = null;
        for (InputPart part : input.getParts()) {
            String fileName = this.getFileName((MultivaluedMap<String, String>)part.getHeaders());
            try {
                InputStream inputStream = (InputStream)part.getBody(InputStream.class, null);
                byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
                fileName = this.createFilePath(providerId, titleId, assetId, fileName);
                file = this.createFile(bytes, fileName);
                logger.debug((Object)("File " + fileName + " saved with success."));
            }
            catch (IOException e) {
                logger.error((Object)("Unable to save the file " + fileName));
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    private String createFilePath(String providerId, long titleId, long assetId, String fileName) throws Exception {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        String timeStamp = format.format(new Date());
        String filePath = Paths.get(this.getBaseUploadPath().trim(), providerId, String.valueOf(titleId), String.valueOf(assetId), String.valueOf(timeStamp), fileName).toString();
        File file = new File(filePath);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
        }
        return filePath;
    }

    private String getFileName(MultivaluedMap<String, String> header) {
        String[] contentDisposition;
        String[] stringArray = contentDisposition = ((String)header.getFirst((Object)"Content-Disposition")).split(";");
        int n = contentDisposition.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            if (filename.trim().startsWith("filename")) {
                String[] name = filename.split("=");
                String finalFileName = name[1].trim().replaceAll("\"", "");
                return finalFileName;
            }
            ++n2;
        }
        return "unknown";
    }

    private File createFile(byte[] content, String filename) throws IOException {
        File file = new File(filename);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream fop = new FileOutputStream(file);
        fop.write(content);
        fop.flush();
        fop.close();
        return file;
    }
}

