/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.titles;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class HrefHelper {
    private static final Logger LOGGER = Logger.getLogger(HrefHelper.class);

    public static String buildGetHref(HttpServletRequest request, Long titleId) {
        String currentUrl = request.getRequestURL().toString();
        StringBuffer sb = new StringBuffer(currentUrl.substring(0, currentUrl.indexOf("/services/titles")));
        sb.append("/services/titles/");
        sb.append(titleId);
        return sb.toString();
    }

    public String buildFirstPosterHref(long titleId) {
        StringBuffer sb = new StringBuffer();
        sb.append(titleId);
        sb.append("/thumbnail");
        return sb.toString();
    }

    public static String buildSiteHref(Integer siteId, HttpServletRequest request) {
        String currentUrl = request.getRequestURL().toString();
        StringBuffer sb = new StringBuffer(currentUrl.substring(0, currentUrl.indexOf("/services/titles")));
        sb.append("/services/sites/");
        sb.append(siteId);
        return sb.toString();
    }

    public static String buildServiceHref(HttpServletRequest request, String uri) {
        String currentUrl = request.getRequestURL().toString();
        StringBuffer sb = new StringBuffer(currentUrl.substring(0, currentUrl.indexOf("/services/")));
        sb.append("/services/");
        sb.append(uri);
        return sb.toString();
    }

    public static String buildHrefToPageStub(HttpServletRequest request, int count, String detail, String sort, String order, String modifiedAfter, List<Integer> siteIds, List<String> filters, String fields) {
        StringBuffer sb = new StringBuffer(request.getRequestURL().toString());
        sb.append("?count=").append(count);
        sb.append("&detail=").append(detail);
        sb.append("&sort=").append(sort);
        sb.append("&order=").append(order);
        if (siteIds != null) {
            for (Integer siteId : siteIds) {
                sb.append("&siteId=").append(siteId);
            }
        }
        if (modifiedAfter != null && !modifiedAfter.isEmpty()) {
            sb.append("&").append("modifiedAfter=").append(modifiedAfter);
        }
        if (filters != null && !filters.isEmpty()) {
            for (String filter : filters) {
                if (StringUtils.isBlank((String)filter)) continue;
                sb.append("&filter=");
                try {
                    sb.append(URLEncoder.encode(filter, "utf-8"));
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.warn((Object)"Encode title list api url error", (Throwable)e);
                    sb.append(URLEncoder.encode(filter));
                }
            }
        }
        if (!StringUtils.isBlank((String)fields)) {
            sb.append("&fields=").append(fields);
        }
        sb.append("&start=");
        return sb.toString();
    }

    public static String buildHrefToPageStub(HttpServletRequest request, int count, String detail, String fields) {
        StringBuffer sb = new StringBuffer(request.getRequestURL().toString());
        sb.append("?count=").append(count);
        sb.append("&detail=").append(detail);
        if (!StringUtils.isBlank((String)fields)) {
            sb.append("&fields=").append(fields);
        }
        sb.append("&start=");
        return sb.toString();
    }

    public static String buildUserHref(String userName, HttpServletRequest request) {
        String currentUrl = request.getRequestURL().toString();
        StringBuffer sb = new StringBuffer(currentUrl.substring(0, currentUrl.indexOf("/services/titles")));
        sb.append("/cms/services/users/");
        sb.append(userName);
        return sb.toString();
    }
}

