/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.titles;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class ImageUtil {
    private static final Logger logger = Logger.getLogger(ImageUtil.class);
    private static final int PORTRAIT_IMG_WIDTH_LARGE = 180;
    private static final int PORTRAIT_IMG_HEIGHT_LARGE = 250;
    private static final int PORTRAIT_IMG_WIDTH_MEDIUM = 55;
    private static final int PORTRAIT_IMG_HEIGHT_MEDIUM = 77;
    private static final int LANDSCAPE_IMG_WIDTH_LARGE = 200;
    private static final int LANDSCAPE_IMG_HEIGHT_LARGE = 150;
    private static final int LANDSCAPE_IMG_WIDTH_MEDIUM = 75;
    private static final int LANDSCAPE_IMG_HEIGHT_MEDIUM = 56;
    private static final String THUMBNAIL_FILE_PREFIX = "thumbnail_file_for_portal";
    private final String size;
    private final String originalPostFilePath;
    private boolean canReadImage = false;
    private double scale;
    private int actual_width;
    private int actual_height;
    private BufferedImage originalImage;
    private String imageFormat;
    private String saveFolderPath;

    public ImageUtil(String size, String originalPostFilePath) {
        this.size = size;
        this.originalPostFilePath = originalPostFilePath;
        File originalImageFile = new File(originalPostFilePath);
        this.saveFolderPath = originalImageFile.getParent();
        try {
            this.originalImage = ImageIO.read(originalImageFile);
        }
        catch (IOException e) {
            logger.error((Object)"can not read image from original poster file", (Throwable)e);
        }
        if (this.originalImage == null) {
            return;
        }
        this.initialize();
        this.canReadImage = true;
    }

    private void initialize() {
        int target_height;
        int target_width;
        int original_width = this.originalImage.getWidth();
        int original_height = this.originalImage.getHeight();
        if (original_height > original_width) {
            if (this.size.equalsIgnoreCase("large")) {
                target_width = 180;
                target_height = 250;
            } else {
                target_width = 55;
                target_height = 77;
            }
        } else if (this.size.equalsIgnoreCase("large")) {
            target_width = 200;
            target_height = 150;
        } else {
            target_width = 75;
            target_height = 56;
        }
        this.scale = this.determineImageScale(original_width, original_height, target_width, target_height);
        this.actual_width = (int)(this.scale * (double)original_width);
        this.actual_height = (int)(this.scale * (double)original_height);
        this.imageFormat = this.getImageFileFormat(this.originalPostFilePath);
    }

    private String getImageFileFormat(String filePath) {
        String imageFormatType = FilenameUtils.getExtension((String)filePath);
        ImageInputStream iis = null;
        try {
            try {
                File file = new File(filePath);
                iis = ImageIO.createImageInputStream(file);
                Iterator<ImageReader> iter = ImageIO.getImageReaders(iis);
                if (iter.hasNext()) {
                    ImageReader reader = iter.next();
                    imageFormatType = reader.getFormatName();
                }
            }
            catch (IOException e) {
                logger.error((Object)e);
                try {
                    iis.close();
                }
                catch (IOException e2) {
                    logger.error((Object)e2);
                }
            }
        }
        finally {
            try {
                iis.close();
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
        return imageFormatType;
    }

    public boolean isCanReadImage() {
        return this.canReadImage;
    }

    public synchronized File generateResizedFile() {
        String resizedFilePath = this.getResizedImageFilePath();
        File resizedFile = new File(resizedFilePath);
        File originalImageFile = new File(this.originalPostFilePath);
        if (this.resizeByImageMagick(this.actual_width, this.actual_height, this.originalPostFilePath, resizedFilePath)) {
            return resizedFile;
        }
        if (this.resizeByInterPolation(resizedFile, originalImageFile)) {
            return resizedFile;
        }
        return null;
    }

    public String getResizedImageFilePath() {
        String fileName = "thumbnail_file_for_portal_" + this.size + "." + this.imageFormat;
        return String.valueOf(this.saveFolderPath) + File.separator + fileName;
    }

    public String getStoredOriginMd5FilePath() {
        String fileName = "thumbnail_file_for_portal_md5.txt";
        return String.valueOf(this.saveFolderPath) + File.separator + fileName;
    }

    private double determineImageScale(int sourceWidth, int sourceHeight, int targetWidth, int targetHeight) {
        double scalex = (double)targetWidth / (double)sourceWidth;
        double scaley = (double)targetHeight / (double)sourceHeight;
        return Math.min(scalex, scaley);
    }

    private boolean resizeByInterPolation(File resizedFile, File originalImageFile) {
        BufferedImage resizedImage = new BufferedImage(this.actual_width, this.actual_height, this.originalImage.getType());
        resizedImage = this.scale > 1.0 ? this.getUpScaledInstance(this.originalImage, this.originalImage.getType(), this.actual_width, this.actual_height) : this.getDownScaledInstance(this.originalImage, this.actual_width, this.actual_height);
        try {
            ImageIO.write((RenderedImage)resizedImage, this.imageFormat, resizedFile);
        }
        catch (IOException e) {
            logger.error((Object)"can not write resized image into resized file", (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean resizeByImageMagick(int actual_width, int actual_height, String original, String resized) {
        String command = "convert -resize %sX%s %s %s";
        command = String.format(command, String.valueOf(actual_width), String.valueOf(actual_height), original, resized);
        return this.executeCommand(command);
    }

    private boolean executeCommand(String command) {
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(command);
            return p.waitFor() == 0;
        }
        catch (Exception e) {
            logger.error((Object)"Error occured during converting image.", (Throwable)e);
            return false;
        }
    }

    private BufferedImage getUpScaledInstance(BufferedImage source, int type, int width, int height) {
        BufferedImage dest = new BufferedImage(width, height, type);
        double scalex = (double)width / (double)source.getWidth();
        double scaley = (double)height / (double)source.getHeight();
        int y = 0;
        while (y < height) {
            int sourcey = y * source.getHeight() / dest.getHeight();
            double ydiff = this.scale(y, scaley) - (double)sourcey;
            int x = 0;
            while (x < width) {
                int sourcex = x * source.getWidth() / dest.getWidth();
                double xdiff = this.scale(x, scalex) - (double)sourcex;
                int x1 = Math.min(source.getWidth() - 1, sourcex + 1);
                int y1 = Math.min(source.getHeight() - 1, sourcey + 1);
                int rgb1 = this.getRGBInterpolation(source.getRGB(sourcex, sourcey), source.getRGB(x1, sourcey), xdiff);
                int rgb2 = this.getRGBInterpolation(source.getRGB(sourcex, y1), source.getRGB(x1, y1), xdiff);
                int rgb = this.getRGBInterpolation(rgb1, rgb2, ydiff);
                dest.setRGB(x, y, rgb);
                ++x;
            }
            ++y;
        }
        return dest;
    }

    private double scale(int point, double scale) {
        return (double)point / scale;
    }

    private int getRGBInterpolation(int value1, int value2, double distance) {
        int alpha1 = (value1 & 0xFF000000) >>> 24;
        int red1 = (value1 & 0xFF0000) >> 16;
        int green1 = (value1 & 0xFF00) >> 8;
        int blue1 = value1 & 0xFF;
        int alpha2 = (value2 & 0xFF000000) >>> 24;
        int red2 = (value2 & 0xFF0000) >> 16;
        int green2 = (value2 & 0xFF00) >> 8;
        int blue2 = value2 & 0xFF;
        int rgb = (int)((double)alpha1 * (1.0 - distance) + (double)alpha2 * distance) << 24 | (int)((double)red1 * (1.0 - distance) + (double)red2 * distance) << 16 | (int)((double)green1 * (1.0 - distance) + (double)green2 * distance) << 8 | (int)((double)blue1 * (1.0 - distance) + (double)blue2 * distance);
        return rgb;
    }

    private BufferedImage getDownScaledInstance(BufferedImage img, int targetWidth, int targetHeight) {
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage ret = img;
        int w = img.getWidth();
        int h = img.getHeight();
        do {
            if (w > targetWidth) {
                if ((w /= 2) < targetWidth) {
                    w = targetWidth;
                }
            } else {
                w = targetWidth;
            }
            if (h > targetHeight) {
                if ((h /= 2) < targetHeight) {
                    h = targetHeight;
                }
            } else {
                h = targetHeight;
            }
            BufferedImage tmp = new BufferedImage(w, h, type);
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.drawImage(ret, 0, 0, w, h, null);
            g2.dispose();
            ret = tmp;
        } while (w != targetWidth || h != targetHeight);
        return ret;
    }
}

