/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.titles;

import com.ericsson.cms.criteria.SearchColumn;
import com.ericsson.cms.search.TitleSearchResult;
import com.tandbergtv.cms.services.data.CMSTitle;
import com.tandbergtv.cms.services.data.Site;
import com.tandbergtv.cms.services.data.TrackingSite;
import com.tandbergtv.cms.services.titles.CategoryService;
import com.tandbergtv.cms.services.titles.HrefHelper;
import com.tandbergtv.cms.services.titles.ListDetail;
import com.tandbergtv.cms.services.titles.SearchColumnExt;
import com.tandbergtv.cms.services.titles.TitleServiceNG;
import com.tandbergtv.cms.util.ContentClassUtil;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class JsonMarshaller {
    private HrefHelper hrefHelper = new HrefHelper();
    private static final Logger logger = Logger.getLogger(JsonMarshaller.class);
    private static final String CONTENT_CLASS = "contentClassId";
    private static final String CONTENT_CLASS_TYPE = "contentClassType";

    public String createPurgeErrorJson(Map<Title, Exception> result) throws Exception {
        JSONArray arr = new JSONArray();
        for (Map.Entry<Title, Exception> entry : result.entrySet()) {
            JSONObject title = new JSONObject();
            title.append("titleId", (Object)entry.getKey().getId());
            title.append("error", (Object)entry.getValue().getLocalizedMessage());
            arr.put((Object)title);
        }
        return arr.toString();
    }

    public String getCategoriesAsJson(List<CategoryService.CategoryResponse> categoriesResponse) throws JSONException {
        JSONObject result = new JSONObject();
        JSONObject resourceList = new JSONObject();
        JSONArray categoriesJSON = new JSONArray();
        this.createNode(categoriesJSON, categoriesResponse);
        resourceList.put("categories", (Object)categoriesJSON);
        result.put("resourceList", (Object)resourceList);
        return result.toString();
    }

    public void createNode(JSONArray parentNode, List<CategoryService.CategoryResponse> categoriesResponse) throws JSONException {
        int i = 0;
        while (i < categoriesResponse.size()) {
            JSONObject currentNode = new JSONObject();
            parentNode.put((Object)currentNode);
            CategoryService.CategoryResponse categoryResponse = categoriesResponse.get(i);
            currentNode.put("name", (Object)categoryResponse.name);
            currentNode.put("path", (Object)categoryResponse.path);
            JSONArray childrenNode = new JSONArray();
            if (categoryResponse != null) {
                this.createNode(childrenNode, categoryResponse.children);
            }
            currentNode.put("children", (Object)childrenNode);
            ++i;
        }
    }

    public String getResultsAsJson(List<TitleServiceNG.SiteTitleCount> siteCountSummary) throws JSONException {
        JSONObject result = new JSONObject();
        JSONArray siteTitleCountList = new JSONArray();
        int i = 0;
        while (i < siteCountSummary.size()) {
            JSONObject currentNode = new JSONObject();
            siteTitleCountList.put((Object)currentNode);
            TitleServiceNG.SiteTitleCount siteTitleCount = siteCountSummary.get(i);
            currentNode.put("type", (Object)siteTitleCount.type);
            currentNode.put("href", (Object)siteTitleCount.siteHref);
            currentNode.put("name", (Object)siteTitleCount.name);
            currentNode.put("titleCount", (Object)siteTitleCount.titleCount);
            JSONObject titleNode = new JSONObject();
            titleNode.put("href", (Object)siteTitleCount.titleHref);
            currentNode.put("titles", (Object)titleNode);
            ++i;
        }
        result.put("resourceList", (Object)siteTitleCountList);
        return result.toString();
    }

    public String getResultsAsJson(TitleSearchResult searchResults, HttpServletRequest request, List<SearchColumn> searchColumns, int start, int count, String hrefStub, ListDetail ld) throws JSONException {
        JSONObject result = new JSONObject();
        JSONObject resourceList = new JSONObject();
        result.put("resourceList", (Object)resourceList);
        resourceList.put("start", start);
        resourceList.put("count", searchResults.getRows().size());
        Map<Long, String> contentClassTypes = ContentClassUtil.getContentClassTypes();
        long total = searchResults.getCount();
        if (ld == ListDetail.portal) {
            resourceList.put("total", total);
        }
        if (start > 0) {
            resourceList.put("first", (Object)(String.valueOf(hrefStub) + "0"));
            long prevStart = start - count;
            if (prevStart < 0L) {
                prevStart = 0L;
            } else if (prevStart >= total) {
                prevStart = total - (long)count;
            }
            resourceList.put("prev", (Object)(String.valueOf(hrefStub) + prevStart));
        }
        if (searchResults.hasMoreResults()) {
            int nextPageStart = start + count;
            resourceList.put("next", (Object)(String.valueOf(hrefStub) + nextPageStart));
        }
        JSONArray cmsTitles = new JSONArray();
        resourceList.put("cmsTitle", (Object)cmsTitles);
        int j = 0;
        while (j < searchResults.getRows().size()) {
            String posterHref;
            JSONObject cmsTitle = new JSONObject();
            cmsTitles.put((Object)cmsTitle);
            TitleSearchResult.SearchRow row = (TitleSearchResult.SearchRow)searchResults.getRows().get(j);
            String href = HrefHelper.buildGetHref(request, row.getId());
            cmsTitle.put("href", (Object)href);
            if (ld == ListDetail.portal && (posterHref = this.hrefHelper.buildFirstPosterHref(row.getId())) != null) {
                JSONObject servicePath = new JSONObject();
                servicePath.put("servicePath", (Object)posterHref);
                cmsTitle.put("thumbnail", (Object)servicePath);
            }
            this.addFields(cmsTitle, row, searchColumns, contentClassTypes, ld);
            ++j;
        }
        return result.toString();
    }

    public static String getSiteTitlesResultAsJson(List<CMSTitle> siteTitles, HttpServletRequest request, String type) {
        try {
            JSONObject json = new JSONObject();
            JSONObject resourceList = new JSONObject();
            resourceList.put("cmsTitle", (Object)JsonMarshaller.createCMSTitleList(siteTitles, request, type));
            json.put("resourceList", (Object)resourceList);
            return json.toString();
        }
        catch (JSONException e) {
            logger.error((Object)"Error when composing JSON response", (Throwable)e);
            return "";
        }
    }

    private static JSONArray createCMSTitleList(List<CMSTitle> siteTitles, HttpServletRequest request, String type) throws JSONException {
        JSONArray cmsTitle = new JSONArray();
        if (siteTitles == null || siteTitles.isEmpty()) {
            return cmsTitle;
        }
        for (CMSTitle siteTitle : siteTitles) {
            cmsTitle.put((Object)JsonMarshaller.createCMSTitleObject(request, siteTitle, type));
        }
        return cmsTitle;
    }

    private static JSONObject createCMSTitleObject(HttpServletRequest request, CMSTitle siteTitle, String type) throws JSONException {
        JSONArray tsl;
        JSONObject title = new JSONObject();
        title.put("href", (Object)HrefHelper.buildGetHref(request, siteTitle.getId()));
        title.put("distributionStatus", (Object)siteTitle.getDistributionStatus());
        title.put("site", (Object)JsonMarshaller.createSiteObject(request, siteTitle.getSite()));
        if (StringUtils.equals((String)"all", (String)type) && (tsl = JsonMarshaller.createTrackingSiteList(request, siteTitle.getTrackingSite())) != null) {
            title.put("trackingSite", (Object)tsl);
        }
        return title;
    }

    private static JSONArray createTrackingSiteList(HttpServletRequest request, List<TrackingSite> trackingSites) throws JSONException {
        JSONArray trackingSite = new JSONArray();
        if (trackingSites == null || trackingSites.isEmpty()) {
            return trackingSite;
        }
        for (TrackingSite ts : trackingSites) {
            trackingSite.put((Object)JsonMarshaller.createTrackingSiteObjct(request, ts));
        }
        return trackingSite;
    }

    private static JSONObject createTrackingSiteObjct(HttpServletRequest request, TrackingSite ts) throws JSONException {
        JSONObject tsObj = new JSONObject();
        if (ts != null) {
            tsObj.put("href", (Object)HrefHelper.buildSiteHref(ts.getId(), request));
            tsObj.put("id", ts.getId());
            tsObj.put("name", (Object)ts.getName());
            tsObj.put("status", (Object)ts.getStatus());
        }
        return tsObj;
    }

    private static JSONObject createSiteObject(HttpServletRequest request, Site site) throws JSONException {
        JSONObject sObj = new JSONObject();
        if (site != null) {
            sObj.put("href", (Object)HrefHelper.buildSiteHref(site.getId(), request));
            sObj.put("id", (Object)site.getId());
            sObj.put("name", (Object)site.getName());
        }
        return sObj;
    }

    private void addFields(JSONObject cmsTitle, TitleSearchResult.SearchRow row, List<SearchColumn> searchColumns, Map<Long, String> contentClassTypes, ListDetail ld) throws JSONException {
        int size = row.getFields().size();
        int index = 0;
        while (index < size) {
            String name = ((SearchColumnExt)searchColumns.get(index)).getDisplayName();
            String dataType = searchColumns.get(index).getDataType();
            String value = row.getFirstValueAsString(index);
            if (!value.isEmpty()) {
                if (((SearchColumnExt)searchColumns.get(index)).isMultiValue()) {
                    Object obj = row.getValue(index);
                    JSONArray jsonValues = new JSONArray();
                    if (obj instanceof List) {
                        List objectValues = (List)obj;
                        for (Object objectValue : objectValues) {
                            jsonValues.put(objectValue);
                        }
                    } else {
                        jsonValues.put(obj);
                    }
                    cmsTitle.put(name, (Object)jsonValues);
                } else if (name.startsWith("/ECMFSpec/")) {
                    JSONArray fields = cmsTitle.optJSONArray("extFields");
                    if (fields == null) {
                        fields = new JSONArray();
                        cmsTitle.put("extFields", (Object)fields);
                    }
                    JSONObject field = new JSONObject();
                    field.put("name", (Object)name);
                    field.put("value", this.convertType(value, dataType));
                    fields.put((Object)field);
                } else if (ld == ListDetail.portal && searchColumns.get(index).getFieldName().equalsIgnoreCase(CONTENT_CLASS)) {
                    cmsTitle.put(CONTENT_CLASS_TYPE, (Object)contentClassTypes.get(Long.valueOf(value)));
                } else {
                    cmsTitle.put(name, this.convertType(value, dataType));
                }
            }
            ++index;
        }
    }

    private Object convertType(String value, String dataType) {
        if (dataType.equals("boolean")) {
            return Boolean.valueOf(value);
        }
        if (dataType.equals("integer")) {
            return Integer.parseInt(value);
        }
        if (dataType.equals("float")) {
            return Float.valueOf(Float.parseFloat(value));
        }
        return value;
    }

    public static String buildSiteJson(Set<com.ericsson.cms.sites.core.entities.Site> sitesTargeted, HttpServletRequest request) {
        if (sitesTargeted.isEmpty()) {
            return "{\"resourceList\":\"\"}";
        }
        StringBuffer sb = new StringBuffer("{\"resourceList\": {\"site\" :");
        if (sitesTargeted.size() > 1) {
            sb.append("[");
        }
        Iterator<com.ericsson.cms.sites.core.entities.Site> iterator = sitesTargeted.iterator();
        while (iterator.hasNext()) {
            sb.append("{\"@href\": \"");
            JsonMarshaller.encodeJson(HrefHelper.buildSiteHref(iterator.next().getId(), request), sb);
            sb.append("\"}");
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        if (sitesTargeted.size() > 1) {
            sb.append("]");
        }
        sb.append("}}");
        return sb.toString();
    }

    public static void encodeJson(String value, StringBuffer sb) {
        char[] cArray = value.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    break;
                }
                case '\\': {
                    sb.append("\\\\");
                    break;
                }
                case '\t': {
                    sb.append("\\\t");
                    break;
                }
                case '\r': {
                    sb.append("\\\r");
                    break;
                }
                case '\n': {
                    sb.append("\\\n");
                    break;
                }
                case '\b': {
                    sb.append("\\\b");
                    break;
                }
                case '\f': {
                    sb.append("\\\f");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++n2;
        }
    }

    public static String buildDueJson(long[] results) {
        return String.format("{ \"dueStatusSummary\" : {\"ready\": %d, \"committed\": %d, \"failed\": %d} }", results[0], results[1], results[2]);
    }
}

