/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.titles;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Relation;
import java.util.Map;

public class TitleUtil {
    public static boolean isValidateAgainstMap(Map<Long, String> assetMap, Asset asset) {
        long assetId = asset.getId();
        String assetType = asset.getAssetType();
        String mapAssetType = assetMap.get(assetId);
        if (!(assetId <= 0L || mapAssetType != null && assetType.equals(mapAssetType))) {
            return false;
        }
        for (Relation r : asset.getRelations()) {
            Asset targetAsset = r.getTargetAsset();
            if (TitleUtil.isValidateAgainstMap(assetMap, targetAsset)) continue;
            return false;
        }
        return true;
    }

    public static void getAllAssetIds(Map<Long, String> assetMap, Asset asset) {
        assetMap.put(asset.getId(), asset.getAssetType());
        for (Relation r : asset.getRelations()) {
            Asset targetAsset = r.getTargetAsset();
            if (assetMap.containsKey(targetAsset.getId())) continue;
            TitleUtil.getAllAssetIds(assetMap, targetAsset);
        }
    }
}

