/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.titles;

import com.ericsson.neptune.security.NeptunePrincipal;
import com.tandbergtv.cms.services.resources.Errors;
import com.tandbergtv.cms.services.titles.ITitlesService;
import com.tandbergtv.cms.services.titles.wpcl.AbstractTitlesServiceMessageBuilder;
import com.tandbergtv.cms.services.titles.wpcl.IngestTitleMessageBuilder;
import com.tandbergtv.cms.services.titles.wpcl.PostIngestMessageBuilder;
import com.tandbergtv.cms.util.EndpointsAuthorizationUtil;
import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationMessage;
import com.tandbergtv.watchpoint.pmm.entities.ISavedTitle;
import com.tandbergtv.watchpoint.pmm.entities.ITitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.TitleActionSource;
import com.tandbergtv.watchpoint.pmm.title.ingest.ITitleIngester;
import com.tandbergtv.watchpoint.pmm.util.WorkflowCreationSender;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.IMessage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;

public class TitlesService
implements ITitlesService {
    private static final String ASYNC_KEY_PARAMETER = "asyncKey";
    private static final String METADATA_DIR_PROPERTY = "metadata.dir";
    private static final String USE_CLASSIC_INGEST_MODE_PROPERTY = "use.classic.ingest.mode";
    private static final int MAX_LENGTH = 100000;
    private static final String PERMISSION_TITLE_CREATE = "AssetManagement_Create";
    private static final String PERMISSION_TITLE_UPDATE = "AssetManagement_Modify";
    private ITitleIngester titleIngester = null;
    private static final String CONFIGURATION_SERVICE = "cms/ConfigurationService/local";
    private static final String SETTINGS_GROUP = "com.ericsson.cms.contentmgmt.ingest.webservice";
    private static final Logger logger = Logger.getLogger((String)TitlesService.class.getName());
    private static final String NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL = "neptune_sso_oauth2_principal";

    /*
     * Loose catch block
     */
    @Override
    public Response ingestMetadata(HttpServletRequest servletRequest, String authorizationHeader, String providerId, String contentClass, UriInfo uriInfo, InputStream metadataInputStream) {
        NeptunePrincipal principal;
        block5: {
            Response.ResponseBuilder builder = null;
            Errors errors = new Errors();
            principal = (NeptunePrincipal)servletRequest.getAttribute(NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL);
            builder = EndpointsAuthorizationUtil.authorizePermissions(servletRequest, builder, PERMISSION_TITLE_CREATE, PERMISSION_TITLE_UPDATE);
            if (builder == null) break block5;
            return builder.build();
            {
                catch (Exception exception) {
                    errors.getErrors().add("Error trying to ingest metadata.");
                    builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
                    builder.entity((Object)errors);
                    return builder.build();
                }
            }
        }
        try {
            Map<String, String> additionalParameters = this.extractQueryArgs(uriInfo);
            return this.ingestMetadata(providerId, metadataInputStream, contentClass, additionalParameters, principal.getUserName());
        }
        catch (Exception e) {
            logger.error((Object)"Error trying to ingest metadata", (Throwable)e);
            throw new WebApplicationException(this.newErrorResponse(e));
        }
    }

    @Override
    public Response ingestMetadata(HttpServletRequest servletRequest, String authorizationHeader, String providerId, UriInfo uriInfo, InputStream metadataInputStream) {
        return this.ingestMetadata(servletRequest, authorizationHeader, providerId, null, uriInfo, metadataInputStream);
    }

    private Map<String, String> extractQueryArgs(UriInfo uriInfo) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String name : uriInfo.getQueryParameters().keySet()) {
            result.put(name, (String)uriInfo.getQueryParameters().getFirst((Object)name));
        }
        return result;
    }

    private Response ingestMetadata(String providerId, InputStream metadataInputStream, String contentClass, Map<String, String> additionalParameters, String username) {
        PostIngestMessageBuilder postIngestMessageBuilder;
        String metadataFilePath = this.saveMetadataFile(providerId, metadataInputStream);
        String asyncKey = this.generateAsyncKey();
        if (this.useClassicMode()) {
            IngestTitleMessageBuilder ingestMessageBuilder = new IngestTitleMessageBuilder(providerId, contentClass, metadataFilePath, additionalParameters, asyncKey);
            this.sendMessage(ingestMessageBuilder);
            return this.newMetadataIngestionResponse(asyncKey);
        }
        try {
            ISavedTitle savedTitle = this.titleIngester().ingestMetadata(metadataFilePath, providerId, contentClass, this.newTitleActionSource(username));
            List validationMessages = this.titleIngester().validate(savedTitle.getTitle());
            Long titleId = this.getTitleId(savedTitle);
            String titleStatus = this.getTitleStatus(savedTitle);
            boolean validationSuccess = !this.validationFailed(validationMessages);
            String validationMessage = this.joinValidationMessages(validationMessages);
            postIngestMessageBuilder = new PostIngestMessageBuilder(titleId, titleStatus, providerId, contentClass, metadataFilePath, additionalParameters, asyncKey, validationSuccess, validationMessage);
        }
        catch (TitleValidationException e) {
            postIngestMessageBuilder = new PostIngestMessageBuilder(null, null, providerId, contentClass, metadataFilePath, additionalParameters, asyncKey, false, this.joinValidationMessages(e.getMessages()));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        this.sendMessage(postIngestMessageBuilder);
        return this.newMetadataIngestionResponse(postIngestMessageBuilder);
    }

    private boolean validationFailed(List<TitleValidationMessage> validationMessages) {
        if (validationMessages != null) {
            int i = 0;
            while (i < validationMessages.size()) {
                TitleValidationMessage m = validationMessages.get(i);
                if (m.getType().equals((Object)TitleValidationMessage.Type.Error)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private Long getTitleId(ISavedTitle savedTitle) {
        if (savedTitle == null || savedTitle.getTitle() == null) {
            return null;
        }
        return savedTitle.getTitle().getId();
    }

    private String getTitleStatus(ISavedTitle savedTitle) {
        if (savedTitle == null || savedTitle.getTitle() == null || savedTitle.getTitle().getStatus() == null) {
            return null;
        }
        return savedTitle.getTitle().getStatus().toString();
    }

    private Response newMetadataIngestionResponse(PostIngestMessageBuilder postIngestMessageBuilder) {
        MetadataIngestResponseBuilder builder = new MetadataIngestResponseBuilder();
        Map<String, String> msgParams = postIngestMessageBuilder.getParameters();
        for (String name : msgParams.keySet()) {
            builder.addParameter(name, msgParams.get(name));
        }
        return builder.ok(202);
    }

    private String joinValidationMessages(List<TitleValidationMessage> validationMessages) {
        ArrayList<String> strMessages = new ArrayList<String>();
        for (TitleValidationMessage m : validationMessages) {
            strMessages.add(m.getMessage());
        }
        String message = TitlesService.join(strMessages, "\n");
        if (message != null && message.length() > 99997) {
            return String.valueOf(message.substring(0, 99997)) + "...";
        }
        return message;
    }

    public static String join(Collection<?> collection, String delimiter) {
        StringBuilder sb = new StringBuilder();
        Iterator<?> it = collection.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    private ITitleActionSource newTitleActionSource(String username) {
        return new TitleActionSource("Content Management", "Metadata Ingest Service", username);
    }

    private Response newMetadataIngestionResponse(String asyncKey) {
        MetadataIngestResponseBuilder builder = new MetadataIngestResponseBuilder();
        builder.addParameter(ASYNC_KEY_PARAMETER, asyncKey);
        return builder.ok(202);
    }

    private void sendMessage(AbstractTitlesServiceMessageBuilder messageBuilder) {
        try {
            IMessage msg = messageBuilder.build();
            logger.info((Object)("Sending mensage:" + msg.getPayload().getContent()));
            WorkflowCreationSender.send((IMessage)msg);
        }
        catch (Exception e) {
            logger.error((Object)"Error trying to send an ingest metadata wpcl message", (Throwable)e);
            throw new WebApplicationException(this.newErrorResponse(e));
        }
    }

    private Response newErrorResponse(Exception e) {
        return new MetadataIngestResponseBuilder().error(e);
    }

    private String saveMetadataFile(String providerId, InputStream metadataInputStream) {
        String filePath = this.newFilePathForMetadata(providerId);
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            try {
                int c;
                in = new BufferedInputStream(metadataInputStream);
                out = new BufferedOutputStream(new FileOutputStream(filePath));
                while ((c = in.read()) != -1) {
                    out.write(c);
                }
            }
            catch (IOException e) {
                logger.error((Object)"Error trying to ingest metadata", (Throwable)e);
                throw new WebApplicationException(this.newErrorResponse(e));
            }
        }
        catch (Throwable throwable) {
            this.close(in);
            this.close(out);
            throw throwable;
        }
        this.close(in);
        this.close(out);
        return filePath;
    }

    private void close(InputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"Error trying to ingest metadata", (Throwable)e);
            throw new WebApplicationException(this.newErrorResponse(e));
        }
    }

    private void close(OutputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"Error trying to ingest metadata", (Throwable)e);
            throw new WebApplicationException(this.newErrorResponse(e));
        }
    }

    private String newFilePathForMetadata(String providerId) {
        try {
            Map settings = this.getSettingsService().getProperties(SETTINGS_GROUP);
            String baseMetadataDir = (String)settings.get(METADATA_DIR_PROPERTY);
            String dirPath = String.valueOf(baseMetadataDir) + "/" + providerId + "/";
            File dir = new File(dirPath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String filePath = String.valueOf(dirPath) + "metadata_" + Calendar.getInstance().getTimeInMillis() + ".xml";
            new File(filePath).createNewFile();
            return filePath;
        }
        catch (IOException e) {
            logger.error((Object)"Error creating file for metadata xml", (Throwable)e);
            throw new WebApplicationException(this.newErrorResponse(e));
        }
    }

    private boolean useClassicMode() {
        Map settings = this.getSettingsService().getProperties(SETTINGS_GROUP);
        String mode = (String)settings.get(USE_CLASSIC_INGEST_MODE_PROPERTY);
        if (mode == null) {
            return false;
        }
        return Boolean.TRUE.toString().equals(mode.toLowerCase());
    }

    private String generateAsyncKey() {
        return UUID.randomUUID().toString();
    }

    private ITitleIngester titleIngester() {
        if (this.titleIngester == null) {
            this.titleIngester = (ITitleIngester)ServiceRegistry.getDefault().lookup(ITitleIngester.class);
        }
        return this.titleIngester;
    }

    public IConfigurationService getSettingsService() {
        return (IConfigurationService)InjectionUtil.injectInstance((String)CONFIGURATION_SERVICE);
    }

    private class MetadataIngestResponseBuilder {
        private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        private List<Parameter> parameters = new ArrayList<Parameter>();
        private static final int HTTP_RESPONSE_ACEPTED = 202;

        public void addParameter(String name, String value) {
            this.parameters.add(new Parameter(name, value));
        }

        public Response ok(int status) {
            return Response.ok((Object)this.buildResponseBody()).status(202).build();
        }

        public Response error(Exception e) {
            return Response.serverError().entity((Object)e.getCause()).build();
        }

        private String buildResponseBody() {
            StringBuilder sb = new StringBuilder();
            sb.append(XML_HEADER);
            for (Parameter p : this.parameters) {
                sb.append("\n");
                sb.append("<");
                sb.append(p.name);
                sb.append(">");
                sb.append(p.value);
                sb.append("</");
                sb.append(p.name);
                sb.append(">");
            }
            return sb.toString();
        }

        private class Parameter {
            String name;
            String value;

            public Parameter(String name, String value) {
                this.name = name;
                this.value = value == null ? "" : value;
            }
        }
    }
}

