/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.util;

import com.ericsson.cms.search.TitleSearchResult;
import com.tandbergtv.cms.services.titles.HrefHelper;
import com.tandbergtv.cms.services.titles.SearchHelper;
import com.tandbergtv.cms.title.search.entities.TitleSearch;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.neptune.util.GlobalDateFormatUtil;
import com.tandbergtv.watchpoint.pmm.entities.PartnerUser;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.workflow.api.model.process.Process;
import com.tandbergtv.workflow.api.model.process.ProcessStatus;
import com.tandbergtv.workflow.api.model.resource.Resource;
import com.tandbergtv.workflow.api.model.resource.ResourceGroup;
import java.io.StringWriter;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConversionUtil {
    private static final String LABEL_NA = "N/A";
    public static final String RESOURCE_LIST = "resourceList";
    private static final String WORKORDERS = "workorders";
    private static final String WORKORDER = "workorder";
    private static final String NAME = "name";
    private static final String ID = "id";
    private static final String HREF = "href";
    private static final String TITLE_ID = "titleId";
    private static final String START_TIME = "startTime";
    private static final String END_TIME = "endTime";
    private static final String STATUS = "status";
    private static final String RESOURCES = "resources";
    private static final String RESOURCE = "resource";
    private static final String OPERATIONAL_STATE = "operationalState";
    private static final String ADMIN_STATE = "adminState";
    private static final String RESOURCE_TYPE = "resourceType";
    private static final String RESOURCE_GROUPS = "resourceGroups";
    private static final String RESOURCE_GROUP = "resourceGroup";
    private static final String ERROR_TIME = "errorTime";
    private static final String ERROR_COMMENT = "errorComment";
    private static final String ERROR_TYPE = "errorType";
    private static final String CURRENT_TASK = "currentTask";
    public static final String START = "start";
    public static final String COUNT = "count";
    public static final String TOTAL = "total";
    public static final String FIRST = "first";
    public static final String PREVIOUS = "prev";
    public static final String NEXT = "next";
    public static final String LAST = "last";
    public static final String TITLE_SEARCH = "savedSearch";
    public static final String TITLE_SEARCH_SHARED = "shared";
    public static final String TITLE_SEARCH_OWNER = "owner";
    public static final String XML_DECLARATION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    public static final String CMS_TITLE = "cmsTitle";
    public static final String TITLE_NAME = "titleName";
    public static final String USER_NAME = "userName";
    public static final String USER = "user";

    public static Node createChild(String tagName, Object value, Document doc) {
        Element e = doc.createElement(tagName);
        e.appendChild(doc.createTextNode(String.valueOf(value)));
        return e;
    }

    public static Document getWorkorderListDoc(List<Process> result, UriBuilder baseUrl) throws Exception {
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = db.newDocument();
        Element root = doc.createElement(RESOURCE_LIST);
        doc.appendChild(root);
        for (Process r : result) {
            Element wo = doc.createElement(WORKORDER);
            wo.appendChild(ConversionUtil.createChild(NAME, r.getTemplate(), doc));
            wo.appendChild(ConversionUtil.createChild(ID, r.getId(), doc));
            String var = r.getTitleId();
            if (var != null) {
                wo.appendChild(ConversionUtil.createChild(TITLE_ID, var, doc));
            }
            wo.appendChild(ConversionUtil.createChild(START_TIME, ConversionUtil.formatTime(r.getStartDate()), doc));
            wo.appendChild(ConversionUtil.createChild(END_TIME, r.getEndDate() == null ? LABEL_NA : ConversionUtil.formatTime(r.getEndDate()), doc));
            wo.appendChild(ConversionUtil.createChild(STATUS, r.getStatus(), doc));
            if (ProcessStatus.valueOf((String)r.getStatus()) == ProcessStatus.ERROR) {
                wo.appendChild(ConversionUtil.createChild(CURRENT_TASK, r.getCurrent(), doc));
                wo.appendChild(ConversionUtil.createChild(ERROR_COMMENT, r.getErrorMessage(), doc));
                wo.appendChild(ConversionUtil.createChild(ERROR_TYPE, r.getErrorCategory(), doc));
                wo.appendChild(ConversionUtil.createChild(ERROR_TIME, ConversionUtil.formatTime(r.getErrorDate()), doc));
            }
            root.appendChild(wo);
        }
        return doc;
    }

    public static String serialize(Document doc) throws Exception {
        StringWriter sw = new StringWriter();
        StreamResult sr = new StreamResult(sw);
        TransformerFactory.newInstance().newTransformer().transform(new DOMSource(doc), sr);
        return sw.toString();
    }

    public static JSONObject getJSONforWorkorders(List<Process> result, UriBuilder baseUrl) throws JSONException {
        JSONObject obj = new JSONObject();
        JSONObject list = new JSONObject();
        obj.put(RESOURCE_LIST, (Object)list);
        JSONArray arr = new JSONArray();
        for (Process r : result) {
            JSONObject wo = new JSONObject();
            wo.put(NAME, (Object)r.getTemplate());
            wo.put(ID, (Object)r.getId());
            String var = r.getTitleId();
            if (var != null) {
                wo.put(TITLE_ID, (Object)var);
            }
            wo.put(START_TIME, (Object)ConversionUtil.formatTime(r.getStartDate()));
            wo.put(END_TIME, (Object)(r.getEndDate() == null ? LABEL_NA : ConversionUtil.formatTime(r.getEndDate())));
            wo.put(STATUS, (Object)r.getStatus());
            if (ProcessStatus.valueOf((String)r.getStatus()) == ProcessStatus.ERROR) {
                wo.put(CURRENT_TASK, (Object)r.getCurrent());
                wo.put(ERROR_COMMENT, (Object)r.getErrorMessage());
                wo.put(ERROR_TYPE, (Object)r.getErrorCategory());
                wo.put(ERROR_TIME, (Object)ConversionUtil.formatTime(r.getErrorDate()));
            }
            arr.put((Object)wo);
        }
        list.put(WORKORDERS, (Object)arr);
        return obj;
    }

    private static String formatTime(Date date) {
        if (date != null) {
            return GlobalDateFormatUtil.formatDateTime((Date)date, (String)"yyyy-MM-dd HH:mm:ss:SSS");
        }
        return "";
    }

    public static String getXMLforResources(List<Resource> resources) throws Exception {
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = db.newDocument();
        Element root = doc.createElement(RESOURCES);
        doc.appendChild(root);
        for (Resource r : resources) {
            Element resource = doc.createElement(RESOURCE);
            resource.appendChild(ConversionUtil.createChild(NAME, r.getName(), doc));
            resource.appendChild(ConversionUtil.createChild(OPERATIONAL_STATE, r.getState(), doc));
            resource.appendChild(ConversionUtil.createChild(ADMIN_STATE, r.getAdminState(), doc));
            resource.appendChild(ConversionUtil.createChild(RESOURCE_TYPE, r.getResourceType(), doc));
            Element groups = doc.createElement(RESOURCE_GROUPS);
            for (ResourceGroup rg : r.getGroups()) {
                groups.appendChild(ConversionUtil.createChild(RESOURCE_GROUP, rg.getName(), doc));
            }
            resource.appendChild(groups);
            root.appendChild(resource);
        }
        return ConversionUtil.serialize(doc);
    }

    public static String getJSONforResources(List<Resource> resources) throws JSONException {
        JSONArray arr = new JSONArray();
        for (Resource r : resources) {
            JSONObject resource = new JSONObject();
            resource.put(NAME, (Object)r.getName());
            resource.put(OPERATIONAL_STATE, (Object)r.getState());
            resource.put(ADMIN_STATE, (Object)r.getAdminState());
            resource.put(RESOURCE_TYPE, (Object)r.getResourceType());
            JSONArray groups = new JSONArray();
            for (ResourceGroup rg : r.getGroups()) {
                groups.put((Object)rg.getName());
            }
            resource.put(RESOURCE_GROUPS, (Object)groups);
            arr.put((Object)resource);
        }
        return arr.toString();
    }

    public static JSONObject getJSONforTitleSearchList(List<TitleSearch> titleSearchList, HttpServletRequest request) throws JSONException {
        JSONObject json = new JSONObject();
        JSONArray searchesJson = new JSONArray();
        for (TitleSearch titleSearch : titleSearchList) {
            JSONObject searchJson = new JSONObject();
            searchJson.put(HREF, (Object)HrefHelper.buildServiceHref(request, "titles/savedSearches/" + titleSearch.getTitleSearchId()));
            searchJson.put(NAME, (Object)titleSearch.getName());
            searchJson.put(TITLE_SEARCH_OWNER, (Object)titleSearch.getUserName());
            searchJson.put(TITLE_SEARCH_SHARED, (Object)titleSearch.getShared());
            searchesJson.put((Object)searchJson);
        }
        json.put(RESOURCE_LIST, (Object)searchesJson);
        return json;
    }

    public static Document getXMLforTitleSearchList(List<TitleSearch> titleSearchList, HttpServletRequest request) throws ParserConfigurationException {
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = db.newDocument();
        Element root = doc.createElement(RESOURCE_LIST);
        doc.appendChild(root);
        for (TitleSearch titleSearch : titleSearchList) {
            Element searchElement = doc.createElement(TITLE_SEARCH);
            searchElement.setAttribute(HREF, HrefHelper.buildServiceHref(request, "titles/savedSearches/" + titleSearch.getTitleSearchId()));
            searchElement.appendChild(ConversionUtil.createChild(NAME, titleSearch.getName(), doc));
            searchElement.appendChild(ConversionUtil.createChild(TITLE_SEARCH_OWNER, titleSearch.getUserName(), doc));
            searchElement.appendChild(ConversionUtil.createChild(TITLE_SEARCH_SHARED, titleSearch.getShared(), doc));
            root.appendChild(searchElement);
        }
        return doc;
    }

    public static String getOfferReferencesXML(HttpServletRequest request, Title offer) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(XML_DECLARATION);
        sb.append("<resourceList>");
        Map<Long, String> searchMap = ConversionUtil.getReferencedTitlesMap(offer);
        List<Long> refTitleIds = ConversionUtil.getReferencedTitles(offer);
        for (Long titleId : refTitleIds) {
            String href = HrefHelper.buildGetHref(request, (long)titleId);
            sb.append("<cmsTitle href=\"");
            sb.append(href).append("\">");
            sb.append("<titleName>");
            String titleName = searchMap.get(titleId);
            sb.append(titleName);
            sb.append("</titleName>");
            sb.append("</cmsTitle>");
        }
        sb.append("</resourceList>");
        return sb.toString();
    }

    public static String getOfferReferencesJSON(HttpServletRequest request, Title offer) throws Exception {
        JSONObject obj = new JSONObject();
        JSONObject list = new JSONObject();
        obj.put(RESOURCE_LIST, (Object)list);
        Map<Long, String> searchMap = ConversionUtil.getReferencedTitlesMap(offer);
        List<Long> refTitleIds = ConversionUtil.getReferencedTitles(offer);
        JSONArray arr = new JSONArray();
        for (Long titleId : refTitleIds) {
            JSONObject wo = new JSONObject();
            String href = HrefHelper.buildGetHref(request, (long)titleId);
            wo.put(HREF, (Object)href);
            String titleName = searchMap.get(titleId);
            wo.put(TITLE_NAME, (Object)titleName);
            arr.put((Object)wo);
        }
        list.put(CMS_TITLE, (Object)arr);
        return obj.toString();
    }

    public static List<Long> getReferencedTitles(Title offer) {
        Asset rootAsset = offer.getAsset();
        List titleIdList = ((Group)rootAsset).getReferencedTitleIds();
        return titleIdList;
    }

    private static Map<Long, String> getReferencedTitlesMap(Title offer) {
        List<TitleSearchResult.SearchRow> result = SearchHelper.getReferencedTitlesForOffer(offer);
        HashMap<Long, String> searchMap = new HashMap<Long, String>();
        for (TitleSearchResult.SearchRow sr : result) {
            Long titleId = Long.valueOf(sr.getValue(0).toString());
            String titleName = sr.getValue(1).toString();
            searchMap.put(titleId, titleName);
        }
        return searchMap;
    }

    public static JSONObject getJSONForUsers(List<PartnerUser> users, HttpServletRequest request, int start, int count, int total, UriInfo uri) throws JSONException {
        int nextPageStart;
        JSONObject resourcesList = new JSONObject();
        JSONArray usersJson = new JSONArray();
        JSONObject resource = new JSONObject();
        for (PartnerUser user : users) {
            JSONObject userJson = new JSONObject();
            userJson.put(HREF, (Object)HrefHelper.buildUserHref(user.getUserName(), request));
            userJson.put(USER_NAME, (Object)user.getUserName());
            usersJson.put((Object)userJson);
        }
        resource.put(START, start);
        resource.put(COUNT, count);
        resource.put(TOTAL, total);
        if (start > 0) {
            resource.put(FIRST, (Object)ConversionUtil.buildHrefToPageStub(uri, 0));
            resource.put(PREVIOUS, (Object)ConversionUtil.buildHrefToPageStub(uri, ConversionUtil.getPrevPageStart(start, count)));
        }
        if ((nextPageStart = ConversionUtil.getNextPageStart(start, count, total)) != 0) {
            resource.put(NEXT, (Object)ConversionUtil.buildHrefToPageStub(uri, nextPageStart));
        }
        resource.put(USER, (Object)usersJson);
        resourcesList.put(RESOURCE_LIST, (Object)resource);
        return resourcesList;
    }

    public static Document getXMLforUsers(List<PartnerUser> users, HttpServletRequest request, int start, int count, int total, UriInfo uri) throws ParserConfigurationException {
        int nextPageStart;
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = db.newDocument();
        Element root = doc.createElement(RESOURCE_LIST);
        root.setAttribute(START, String.valueOf(start));
        root.setAttribute(COUNT, String.valueOf(count));
        root.setAttribute(TOTAL, String.valueOf(total));
        if (start > 0) {
            root.setAttribute(FIRST, ConversionUtil.buildHrefToPageStub(uri, 0));
            root.setAttribute(PREVIOUS, ConversionUtil.buildHrefToPageStub(uri, ConversionUtil.getPrevPageStart(start, count)));
        }
        if ((nextPageStart = ConversionUtil.getNextPageStart(start, count, total)) != 0) {
            root.setAttribute(NEXT, ConversionUtil.buildHrefToPageStub(uri, nextPageStart));
        }
        doc.appendChild(root);
        for (PartnerUser user : users) {
            Element searchElement = doc.createElement(USER);
            searchElement.setAttribute(HREF, HrefHelper.buildUserHref(user.getUserName(), request));
            searchElement.appendChild(ConversionUtil.createChild(USER_NAME, user.getUserName(), doc));
            root.appendChild(searchElement);
        }
        return doc;
    }

    public static List<?> getCurrentPage(List<?> list, int start, int count) {
        int endIndex = Math.min(list.size(), start + count);
        if (start < endIndex) {
            return list.subList(start, endIndex);
        }
        return Collections.EMPTY_LIST;
    }

    private static String buildHrefToPageStub(UriInfo uri, int start) {
        URI userUri = uri.getRequestUriBuilder().replaceQueryParam(START, new Object[]{start}).build(new Object[0]);
        return userUri.toASCIIString();
    }

    private static int getNextPageStart(int start, int count, long totalResourceCount) {
        if ((long)(start + count) < totalResourceCount) {
            int nextPageStart = start + count;
            return nextPageStart;
        }
        return 0;
    }

    private static int getPrevPageStart(int start, int count) {
        int prevStart = start - count;
        if (prevStart < 0) {
            prevStart = 0;
        }
        return prevStart;
    }
}

