/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.util;

import com.tandbergtv.cms.title.search.entities.UnauthorizedUserException;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.PartnerType;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerUserManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PartnerUtils {
    private static IPartnerUserManager partnerService;

    private PartnerUtils() {
    }

    private static IPartnerUserManager getPartnerService() {
        if (partnerService == null) {
            partnerService = (IPartnerUserManager)InjectionUtil.injectInstance((String)"cms/PartnerUserManager/local", IPartnerUserManager.class);
        }
        return partnerService;
    }

    public static boolean checkAuthorization(Long partnerId) {
        List partners = PartnerUtils.getPartnerService().getPartnersByCurrentUser();
        if (partners.isEmpty()) {
            return false;
        }
        for (Partner p : partners) {
            if (!p.getType().equals((Object)PartnerType.SELF) && p.getId() != partnerId.longValue()) continue;
            return true;
        }
        return false;
    }

    public static List<Long> getAuthorizedPartnerIds() throws UnauthorizedUserException {
        return PartnerUtils.getAuthorizedPartnerIds(null);
    }

    public static List<Long> getAuthorizedPartnerIds(List<Long> requestPartnerIds) throws UnauthorizedUserException {
        List partners;
        if (requestPartnerIds == null) {
            requestPartnerIds = Collections.emptyList();
        }
        if ((partners = PartnerUtils.getPartnerService().getPartnersByCurrentUser()).isEmpty()) {
            throw new UnauthorizedUserException();
        }
        ArrayList<Long> partnerIds = new ArrayList<Long>();
        for (Partner p : partners) {
            if (p.getType().equals((Object)PartnerType.SELF)) {
                return requestPartnerIds;
            }
            partnerIds.add(p.getId());
        }
        if (!requestPartnerIds.isEmpty()) {
            ArrayList<Long> localPartnerIds = new ArrayList<Long>(requestPartnerIds);
            localPartnerIds.removeAll(partnerIds);
            if (!localPartnerIds.isEmpty()) {
                StringBuilder message = new StringBuilder("You hava no permission to access these partners:[");
                for (Long id : localPartnerIds) {
                    message.append(id).append(',');
                }
                message.setCharAt(message.length() - 1, ']');
                throw new UnauthorizedUserException(message.toString());
            }
        }
        return requestPartnerIds.isEmpty() ? partnerIds : requestPartnerIds;
    }
}

