/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.core.entities;

import com.ericsson.cms.sites.core.entities.CISNotificationType;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public class CISNotificationData
implements Serializable {
    private static final long serialVersionUID = 1L;
    Integer id;
    Integer siteId;
    String identity;
    String messageId;
    CISNotificationType notificationType;
    String callOutURL;
    String cmsSystemId;
    String cmsIdentity;
    String query;
    Date createDate;
    Date updateDate;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public CISNotificationData() {
        this.createDate = new Date();
        this.updateDate = new Date();
    }

    public CISNotificationData(Integer siteId, String identity, String cmsIdentity, String cmsSystemId, String messageId, CISNotificationType notificationType, List<String> callOutURLs, String query) throws UnsupportedEncodingException {
        this.siteId = siteId;
        this.identity = identity;
        this.messageId = messageId;
        this.notificationType = notificationType;
        this.callOutURL = this.encode(callOutURLs);
        this.query = query;
        this.createDate = new Date();
        this.updateDate = new Date();
        this.cmsSystemId = cmsSystemId;
        this.cmsIdentity = cmsIdentity;
    }

    public Integer getSiteId() {
        return this.siteId;
    }

    public void setSiteId(Integer siteId) {
        this.siteId = siteId;
    }

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public CISNotificationType getNotificationType() {
        return this.notificationType;
    }

    public void setNotificationType(CISNotificationType notificationType) {
        this.notificationType = notificationType;
    }

    public String getCallOutURL() {
        return this.callOutURL;
    }

    public void setCallOutURL(String callOutURL) {
        this.callOutURL = callOutURL;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public List<String> getCallOutURLs() throws UnsupportedEncodingException {
        return this.decode(this.callOutURL);
    }

    public void setCallOutURLs(List<String> callOutURLs) throws UnsupportedEncodingException {
        this.callOutURL = this.encode(callOutURLs);
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createdate) {
        this.createDate = createdate;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updatedate) {
        this.updateDate = updatedate;
    }

    public String getCmsSystemId() {
        return this.cmsSystemId;
    }

    public void setCmsSystemId(String cmsSystemId) {
        this.cmsSystemId = cmsSystemId;
    }

    public String getCmsIdentity() {
        return this.cmsIdentity;
    }

    public void setCmsIdentity(String cmsIdentity) {
        this.cmsIdentity = cmsIdentity;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    public String toString() {
        Field[] fields;
        StringBuilder result = new StringBuilder();
        String newLine = System.getProperty("line.separator");
        result.append(this.getClass().getName());
        result.append(" Object {");
        result.append(newLine);
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            result.append("  ");
            try {
                result.append(field.getName());
                result.append(": ");
                result.append(field.get(this));
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
            result.append(newLine);
        }
        result.append("}");
        return result.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    private String encode(List<String> callOutURLs) throws UnsupportedEncodingException {
        HashSet<String> callOutURLsSet = new HashSet<String>(callOutURLs);
        StringBuilder encURLs = new StringBuilder();
        for (String url : callOutURLsSet) {
            String enc = URLEncoder.encode(url, "UTF-8");
            encURLs.append(enc).append(",");
        }
        return encURLs.toString();
    }

    private List<String> decode(String callOutURLs) throws UnsupportedEncodingException {
        ArrayList<String> decURLs = new ArrayList<String>();
        List<String> encURLs = Arrays.asList(callOutURLs.split(","));
        for (String url : encURLs) {
            if (url.isEmpty()) continue;
            String dec = URLDecoder.decode(url, "UTF-8");
            decURLs.add(dec);
        }
        return decURLs;
    }
}

