/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.util;

import com.ericsson.neptune.i18n.I18nLocaleUtil;
import com.tandbergtv.neptune.i18n.common.MessageBundle;
import com.tandbergtv.neptune.i18n.service.I18nResourceService;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.lang.LocaleUtils;
import org.apache.log4j.Logger;

public class LocalizedMessageUtil {
    private static final Logger logger = Logger.getLogger(LocalizedMessageUtil.class);
    public static final String I18N_RESOURCE_GROUP_CONTENT_MESSAGES = "content";
    public static String TITLE_VIEW_SERVICE_ERR_MSG_GROUP = "content";
    public static final String TITLE_VIEW_SERVICE_ERR_MSG_BUNDLE = "com.tandbergtv.cms.portal.content.server.title.TitleViewServiceErrorMessages";
    private static final String I18N_RESOURCE_SERVICE_JNDI_LOOKUP_KEY = "cms/neptune/Neptune:service=com.tandbergtv.neptune.i18n.service.I18nResourceService";
    public static final String GROUP_PARTNER = "partner";
    public static final String I18N_RESOURCE_GROUP_REPORT = "report";
    private MessageBundle messageBundle;
    private String group;
    private String defaultResourceBaseName;
    private Locale locale;
    private ClassLoader cl;

    public LocalizedMessageUtil(String group) {
        this(group, group, null);
    }

    public LocalizedMessageUtil(String group, String defaultResourceBaseName) {
        this(group, defaultResourceBaseName, null);
    }

    public LocalizedMessageUtil(String group, String defaultResourceBaseName, ClassLoader cl) {
        this.group = group;
        this.defaultResourceBaseName = defaultResourceBaseName;
        this.cl = cl;
    }

    protected MessageBundle getMessageBundle() {
        if (this.messageBundle == null) {
            I18nResourceService i18nResourceService = (I18nResourceService)InjectionUtil.injectInstance((String)I18N_RESOURCE_SERVICE_JNDI_LOOKUP_KEY, I18nResourceService.class);
            this.messageBundle = i18nResourceService.getMessageBundleInstance();
        }
        return this.messageBundle;
    }

    public String getMessageValue(String key) {
        this.locale = this.getLocale();
        String defaultValue = key;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("local=" + this.locale.getLanguage() + " ,baseName=" + this.defaultResourceBaseName + ", group=" + this.group + ", key=" + key));
        }
        try {
            defaultValue = this.getResourceBundle(this.defaultResourceBaseName).getString(key);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("value in built-in " + this.defaultResourceBaseName + ":" + defaultValue));
            }
        }
        catch (MissingResourceException e) {
            logger.warn((Object)("Refer to a nonexistent resource key:" + key), (Throwable)e);
        }
        String returnVal = this.getMessageBundle().getMessageValue(key, this.group, defaultValue, this.locale);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("final value: " + returnVal));
        }
        return returnVal;
    }

    public String getMessageValue(String key, Object ... args) {
        this.locale = this.getLocale();
        String defaultValue = key;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("local=" + this.locale.getLanguage() + " ,baseName=" + this.defaultResourceBaseName + ", group" + this.group + ", key=" + key));
        }
        try {
            defaultValue = this.getResourceBundle(this.defaultResourceBaseName).getString(key);
            defaultValue = MessageFormat.format(defaultValue, args);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("value in built-in " + this.defaultResourceBaseName + ":" + defaultValue));
            }
        }
        catch (MissingResourceException e) {
            logger.debug((Object)("Refer to a nonexistent resource key:" + key));
        }
        String returnVal = this.getMessageBundle().getMessageValue(key, this.group, defaultValue, this.locale, args);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("final value: " + returnVal));
        }
        return returnVal;
    }

    public String getMessageValueFromExternalResource(String externalPath, String key) {
        try {
            ResourceBundle externalBundle = this.getExternalResourceBundle(externalPath);
            return this.getMessageBundle().getMessageValue(key, this.group, externalBundle.getString(key), this.locale);
        }
        catch (Exception e) {
            logger.error((Object)("fail to get resourceBundle . path:" + externalPath));
            return String.format("!%s!", key);
        }
    }

    private ResourceBundle getExternalResourceBundle(String externalPath) throws MalformedURLException {
        File directory = new File(externalPath);
        URL[] urls = new URL[]{directory.toURI().toURL()};
        URLClassLoader aUrlCL = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
        return ResourceBundle.getBundle(this.defaultResourceBaseName, this.locale, aUrlCL);
    }

    protected ResourceBundle getResourceBundle(String resourceBaseName) {
        Locale defaultLocale = Locale.getDefault();
        return this.cl == null ? ResourceBundle.getBundle(resourceBaseName, defaultLocale) : ResourceBundle.getBundle(resourceBaseName, defaultLocale, this.cl);
    }

    private Locale getLocale() {
        return LocaleUtils.toLocale((String)I18nLocaleUtil.getThreadScopeLocaleValue());
    }
}

