/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.routing;

import com.tandbergtv.watchpoint.routing.SoapMessageHelper;
import com.tandbergtv.workflow.adaptor.util.XMLDocumentUtility;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.comm.routing.CommunicationException;
import com.tandbergtv.workflow.comm.routing.IRoutingService;
import com.tandbergtv.workflow.message.HTTPMessage;
import com.tandbergtv.workflow.message.HTTPPayload;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.util.List;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class SoapRouter
implements IRoutingService {
    private static final String DESTINATION = "http://app:7070/workflow/services/AdaptorService";
    private static Logger logger = Logger.getLogger(SoapRouter.class);

    public IMessage send(IMessage msg) throws CommunicationException {
        HTTPMessage responseMessage = null;
        try {
            logger.debug((Object)"Making SOAP call to http://app:7070/workflow/services/AdaptorService");
            SOAPConnection connection = SOAPConnectionFactory.newInstance().createConnection();
            SOAPMessage reply = connection.call(new SoapMessageHelper().generateSOAPMessage(msg), (Object)DESTINATION);
            SOAPBody body = reply.getSOAPBody();
            if (body.getFault() != null) {
                SOAPFault fault = body.getFault();
                logger.warn((Object)fault.getFaultString());
            }
            String response = XMLDocumentUtility.convertToString((Node)reply.getSOAPPart());
            responseMessage = new HTTPMessage(new HTTPPayload(response));
            logger.debug((Object)("responsemessage: " + responseMessage));
            connection.close();
        }
        catch (SOAPException ex) {
            throw new CommunicationException("Could not send SOAP message.", (Throwable)ex);
        }
        catch (Exception ex) {
            throw new CommunicationException("Could not send xml from SOAP response message.", (Throwable)ex);
        }
        return responseMessage;
    }

    public WorkflowMessage send(WorkflowMessage arg0, List<IDestination> arg1) throws CommunicationException {
        throw new UnsupportedOperationException("This should not be called");
    }
}

