/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.model;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.ChangeListener;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.IField;
import com.tandbergtv.metadatamanager.model.TimeCodeType;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import com.tandbergtv.metadatamanager.util.DateUtil;
import com.tandbergtv.metadatamanager.util.TimeCodeUtil;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.w3c.util.DateParser;

public abstract class FieldBase
implements IField,
Serializable {
    protected String ttvXPath;
    private String value;
    private String largeValue;
    private Date dateValue;
    private Long intValue;
    private Float floatValue;
    private Boolean booleanValue;
    private Date timeValue;
    private TimeCodeType tcValue;
    protected List<Integer> indices;
    protected Asset root;
    protected long id;
    protected String dataType;
    protected Asset parentAsset;
    protected Boolean parsable = true;
    private static final Logger logger = Logger.getLogger(Field.class);
    private static final String TIME_FORMAT = "HH:mm:ss";
    private static final String TRUE = "true";
    private static final String FALSE = "false";

    public FieldBase() {
        this.indices = new ArrayList<Integer>();
    }

    public FieldBase(String ttvXPath, String value) {
        this();
        this.setTtvXPath(ttvXPath);
        this.setValue(value);
    }

    public FieldBase(IField copyFromField) {
        this.setTtvXPath(copyFromField.getTtvXPath());
        if (copyFromField.getDataType() != null) {
            this.dataType = copyFromField.getDataType();
        }
        this.setValue(copyFromField.getValue());
        this.setIndices(copyFromField.getIndices());
        if (copyFromField.getRoot() != null) {
            this.setRoot(copyFromField.getRoot());
        }
        if (copyFromField.getParentAsset() != null) {
            this.setParentAsset(copyFromField.getParentAsset());
        }
    }

    @Override
    public String getTtvXPath() {
        return this.ttvXPath;
    }

    @Override
    public void setTtvXPath(String ttvXPath) {
        this.ttvXPath = ttvXPath;
        this.checkAndSetDataType();
        if (this.value != null) {
            this.setValue(this.getStringValue());
        }
    }

    @Override
    public String getValue() {
        try {
            if (this.dataType.equals("integer")) {
                if (this.intValue != null) {
                    return String.valueOf(this.intValue);
                }
                if (!this.parsable.booleanValue()) {
                    return this.getStringValue();
                }
                return "";
            }
            if (this.dataType.equals("float")) {
                if (this.floatValue != null) {
                    return String.valueOf(this.floatValue);
                }
                if (!this.parsable.booleanValue()) {
                    return this.getStringValue();
                }
                return "";
            }
            if (this.dataType.equals("date")) {
                if (this.dateValue != null) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                    return sdf.format(this.dateValue);
                }
                if (!this.parsable.booleanValue()) {
                    return this.getStringValue();
                }
                return "";
            }
            if (this.dataType.equals("time")) {
                if (this.timeValue != null) {
                    SimpleDateFormat sdf = new SimpleDateFormat(TIME_FORMAT);
                    return sdf.format(this.timeValue);
                }
                if (!this.parsable.booleanValue()) {
                    return this.getStringValue();
                }
                return "";
            }
            if (this.dataType.equals("boolean")) {
                if (this.booleanValue != null) {
                    return String.valueOf(this.booleanValue);
                }
                if (!this.parsable.booleanValue()) {
                    return this.getStringValue();
                }
                return "";
            }
            if (this.dataType.equals("timecode")) {
                if (this.tcValue != null) {
                    return this.tcValue.getValue();
                }
                if (!this.parsable.booleanValue()) {
                    return this.getStringValue();
                }
                return "";
            }
            return this.getStringValue();
        }
        catch (Exception e) {
            return this.getStringValue();
        }
    }

    private String getStringValue() {
        if (this.largeValue != null && !this.largeValue.isEmpty()) {
            return this.largeValue;
        }
        return this.value;
    }

    @Override
    public Object getTypedValue() {
        try {
            if (!this.parsable.booleanValue()) {
                logger.debug((Object)("For xpath: " + this.ttvXPath + ", dataType: " + this.dataType + ", value: " + this.value + " returning unparseable value"));
                return this.getStringValue();
            }
            if (this.dataType.equals("string")) {
                return this.getStringValue();
            }
            if (this.dataType.equals("integer")) {
                return this.intValue;
            }
            if (this.dataType.equals("boolean")) {
                return this.booleanValue;
            }
            if (this.dataType.equals("float")) {
                return this.floatValue;
            }
            if (this.dataType.equals("time")) {
                return this.timeValue;
            }
            if (this.dataType.equals("date")) {
                return this.dateValue;
            }
            if (this.dataType.equals("timecode")) {
                return this.tcValue;
            }
        }
        catch (Exception e) {
            logger.debug((Object)("For xpath: " + this.ttvXPath + ", dataType: " + this.dataType + ", value: " + this.value + " returning null"));
            return null;
        }
        return null;
    }

    @Override
    public void setTypedValue(Object value) {
        if (value instanceof String) {
            this.setValue((String)value);
            return;
        }
        String originalValue = null;
        if (this.root != null && !this.root.getRegisteredListeners().isEmpty()) {
            originalValue = this.getValue();
        }
        if (this.dataType != null) {
            try {
                if (this.dataType.equals("integer")) {
                    this.intValue = (Long)value;
                    this.value = null;
                } else if (this.dataType.equals("float")) {
                    this.floatValue = (Float)value;
                    this.value = null;
                } else if (this.dataType.equals("date")) {
                    this.dateValue = (Date)value;
                    this.value = null;
                } else if (this.dataType.equals("boolean")) {
                    this.booleanValue = (Boolean)value;
                } else if (this.dataType.equals("time")) {
                    this.timeValue = (Date)value;
                } else if (this.dataType.equals("timecode")) {
                    this.tcValue = (TimeCodeType)value;
                }
                this.parsable = true;
            }
            catch (ClassCastException ex) {
                throw new RuntimeException("Data type of value doesn't match field data type. Expected data type: " + this.dataType + "Actual data type: " + value.getClass().getSimpleName());
            }
        } else if (value instanceof Date) {
            this.setStringValue(DateParser.getIsoDateNoMillis((Date)value));
        } else if (value instanceof Boolean || value instanceof Long || value instanceof Float || value instanceof String || value instanceof TimeCodeType) {
            this.setStringValue(value.toString());
        } else {
            throw new RuntimeException("Data type of value is of an unsupported type. Data type of value: " + value.getClass().getSimpleName());
        }
        this.logValue(originalValue);
    }

    private void logValue(String originalValue) {
        if (this.root == null || this.root.getRegisteredListeners().isEmpty()) {
            return;
        }
        String newValue = this.getValue();
        if (originalValue == null) {
            originalValue = "";
        }
        if (newValue == null) {
            newValue = "";
        }
        if (!originalValue.equals(newValue)) {
            for (ChangeListener listener : this.root.getRegisteredListeners()) {
                listener.handleChange(this.getTtvXPath(), this.getParentAsset().getPath(), originalValue, newValue);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setValue(String value) {
        if (value != null) {
            value = value.trim();
        }
        String originalValue = null;
        if (this.root != null && !this.root.getRegisteredListeners().isEmpty()) {
            originalValue = this.getValue();
        }
        try {
            if (this.dataType.equals("integer")) {
                this.intValue = Long.parseLong(value);
                if (this.isNonNegative() && this.intValue < 0L) {
                    throw new Exception("Invalid NonNegative");
                }
                this.value = null;
            } else if (this.dataType.equals("float")) {
                this.floatValue = Float.valueOf(Float.parseFloat(value));
                this.value = null;
            } else if (this.dataType.equals("date")) {
                this.dateValue = DateUtil.convertDate(value);
                this.value = null;
            } else if (this.dataType.equals("boolean")) {
                if (!value.equalsIgnoreCase(TRUE) && !value.equalsIgnoreCase(FALSE)) throw new RuntimeException("A boolean value must be true or false");
                this.booleanValue = Boolean.valueOf(value);
                this.value = null;
            } else if (this.dataType.equals("time")) {
                SimpleDateFormat formatter = new SimpleDateFormat(TIME_FORMAT);
                this.timeValue = (Date)formatter.parseObject(value);
                this.value = null;
            } else if (this.dataType.equals("timecode")) {
                if (!this.isTimeCodeValid(value)) {
                    throw new Exception("Invalid TimeCode format");
                }
                this.tcValue = new TimeCodeType(value);
                this.value = null;
            } else {
                this.setStringValue(value);
            }
            this.parsable = true;
        }
        catch (Exception e) {
            logger.debug((Object)"There was an error converting the value into the specified datatype. Defaulting to Error");
            this.setStringValue(value);
            this.intValue = null;
            this.floatValue = null;
            this.dateValue = null;
            this.booleanValue = null;
            this.timeValue = null;
            this.tcValue = null;
            this.parsable = false;
        }
        this.logValue(originalValue);
    }

    public boolean isTimeCodeValid(String value) {
        return TimeCodeUtil.getInstance().isTimeCode(value);
    }

    private void setStringValue(String str) {
        if (str != null && str.length() > 2000) {
            this.largeValue = str;
            this.value = str.substring(0, 2000);
        } else {
            this.largeValue = "";
            this.value = str;
        }
    }

    @Override
    public List<Integer> getIndices() {
        return this.indices;
    }

    @Override
    public void setIndices(List<Integer> indices) {
        this.indices = indices;
    }

    @Override
    public Asset getRoot() {
        return this.root;
    }

    @Override
    public void setRoot(Asset root) {
        this.root = root;
    }

    @Override
    public String getStoredIndices() {
        StringBuilder sb = new StringBuilder();
        for (Integer index : this.indices) {
            sb.append("#");
            try {
                sb.append(index);
            }
            catch (Exception exception) {}
        }
        return sb.toString();
    }

    private void setStoredIndices(String indices) {
        String[] split = indices.split("#");
        boolean first = true;
        for (String index : split) {
            if (first) {
                first = false;
                continue;
            }
            try {
                this.indices.add(Integer.parseInt(index));
            }
            catch (Exception e) {
                this.indices.add(null);
            }
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public String getDataType() {
        return this.dataType;
    }

    @Deprecated
    public void setDataType(String dataType) {
        this.dataType = dataType;
        this.checkAndSetDataType();
    }

    protected void checkAndSetDataType() {
        if (this.ttvXPath != null && !this.ttvXPath.isEmpty()) {
            String type = DataTypeMappingReader.getInstance().determineDataType(this.ttvXPath);
            if (type == null || type.isEmpty()) {
                if (this.dataType == null || this.dataType.isEmpty()) {
                    this.dataType = "string";
                }
            } else {
                this.dataType = type;
            }
        }
    }

    protected boolean isNonNegative() {
        boolean isNonNegative = false;
        if (this.ttvXPath != null && !this.ttvXPath.isEmpty()) {
            isNonNegative = DataTypeMappingReader.getInstance().isNonNegative(this.ttvXPath);
        }
        return isNonNegative;
    }

    @Override
    public Asset getParentAsset() {
        return this.parentAsset;
    }

    @Override
    public void setParentAsset(Asset parentAsset) {
        this.parentAsset = parentAsset;
    }

    @Override
    public String toString() {
        return "[" + this.id + "] " + this.getTtvXPath() + ", " + this.getValue() + " " + this.getStoredIndices();
    }

    private String getLargeValue() {
        return this.largeValue;
    }

    private void setLargeValue(String largeValue) {
        this.largeValue = largeValue;
    }

    @Override
    public Boolean getParsable() {
        return this.parsable;
    }

    public void setParsable(Boolean parsable) {
        this.parsable = parsable;
    }

    public String getTtvXPathWithIndices() {
        return FieldBase.buildTtvXPathWithIndices(this.ttvXPath, this.indices);
    }

    public static String buildTtvXPathWithIndices(String xpath, List<Integer> indices) {
        StringTokenizer strTok = new StringTokenizer(xpath, "/");
        String str = "";
        int i = 0;
        while (strTok.hasMoreTokens()) {
            String token = strTok.nextToken();
            if (i > 0) {
                str = str + "/";
            }
            if (!token.startsWith("@")) {
                token = token + "[" + indices.get(i) + "]";
                ++i;
            }
            str = str + token;
        }
        return str;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().getSuperclass().equals(FieldBase.class)) {
            FieldBase f = (FieldBase)obj;
            if (f.id > 0L && this.id > 0L) {
                return f.id == this.id;
            }
            return f.dataType.equals(this.dataType) && f.getTtvXPath().equals(this.getTtvXPath()) && f.getValue().equals(this.getValue()) && this.indicesEqual(f.getIndices());
        }
        return false;
    }

    private boolean indicesEqual(List<Integer> indicesToCompare) {
        if (indicesToCompare.size() != this.indices.size()) {
            return false;
        }
        for (int i = 0; i < this.indices.size(); ++i) {
            if (indicesToCompare.get(i).equals(this.indices.get(i))) continue;
            return false;
        }
        return true;
    }

    protected void fillInClone(FieldBase clone) {
        clone.ttvXPath = this.ttvXPath;
        clone.value = this.value;
        clone.largeValue = this.largeValue;
        clone.dateValue = this.dateValue;
        clone.intValue = this.intValue;
        clone.floatValue = this.floatValue;
        clone.booleanValue = this.booleanValue;
        clone.timeValue = this.timeValue;
        clone.tcValue = this.tcValue;
        clone.indices = new ArrayList<Integer>();
        for (Integer i : this.indices) {
            clone.indices.add(i);
        }
        clone.id = this.id;
        clone.dataType = this.dataType;
        clone.parsable = this.parsable;
    }
}

