/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.search;

import com.tandbergtv.metadatamanager.search.ConditionBuilderFactory;
import com.tandbergtv.metadatamanager.search.SearchSchemaHelper;
import com.tandbergtv.metadatamanager.search.oracle.AssetSearchQueryBuilder;
import com.tandbergtv.metadatamanager.search.pg.PgAssetSearchQueryBuilder;
import org.hibernate.SessionFactory;
import org.hibernate.impl.SessionFactoryImpl;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class QueryBuilderFactory {
    private SessionFactory sessionFactory;
    private AssetSearchQueryBuilder assetSearchQueryBuilder;
    private PgAssetSearchQueryBuilder pgAssetSearchQueryBuilder;
    private ConditionBuilderFactory condidtionBuilderFactory;
    private SearchSchemaHelper schemaHelper;

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setHibernateTemplate(HibernateTemplate hibernateTemplate) {
        this.sessionFactory = hibernateTemplate.getSessionFactory();
    }

    public void setCondidtionBuilderFactory(ConditionBuilderFactory condidtionBuilderFactory) {
        this.condidtionBuilderFactory = condidtionBuilderFactory;
    }

    public void setSchemaHelper(SearchSchemaHelper schemaHelper) {
        this.schemaHelper = schemaHelper;
    }

    public void init() {
        this.assetSearchQueryBuilder = new AssetSearchQueryBuilder(this.schemaHelper);
        this.assetSearchQueryBuilder.setConditionBuilderFactory(this.condidtionBuilderFactory);
        this.pgAssetSearchQueryBuilder = new PgAssetSearchQueryBuilder(this.schemaHelper);
        this.pgAssetSearchQueryBuilder.setConditionBuilderFactory(this.condidtionBuilderFactory);
    }

    private boolean isOracle() {
        return ((SessionFactoryImpl)this.sessionFactory).getDialect().getClass().getName().contains("Oracle");
    }

    public AssetSearchQueryBuilder getAssetSearchQueryBuilder() {
        if (this.isOracle()) {
            return this.assetSearchQueryBuilder;
        }
        return this.pgAssetSearchQueryBuilder;
    }
}

