/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.search.pg;

import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.tandbergtv.metadatamanager.search.oracle.DateConditionBuilder;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PgDateConditionBuilder
extends DateConditionBuilder {
    public PgDateConditionBuilder(Predicate predicate) {
        super(predicate);
    }

    @Override
    protected String equal() {
        SimpleDateFormat xmlDateFormat = new SimpleDateFormat(this.getXmlDateFormat());
        Date startDate = this.truncateTime(this.getFirstDate());
        Date endDate = this.addDays(startDate, 1);
        String conditionFormat = " (xpath('%s/text()',mdm.document))[1]::text::timestamp without time zone >= '%s' and (xpath('%s/text()',mdm.document))[1]::text::timestamp without time zone < '%s'";
        return String.format(conditionFormat, this.getXpath(), xmlDateFormat.format(startDate), this.getXpath(), xmlDateFormat.format(endDate));
    }

    @Override
    protected String greaterThan() {
        SimpleDateFormat xmlDateFormat = new SimpleDateFormat(this.getXmlDateFormat());
        Date startDate = this.addDays(this.truncateTime(this.getFirstDate()), 1);
        String conditionFormat = " (xpath('%s/text()',mdm.document))[1]::text::timestamp without time zone >= '%s'";
        return String.format(conditionFormat, this.getXpath(), xmlDateFormat.format(startDate));
    }

    @Override
    protected String greaterThanEqual() {
        SimpleDateFormat xmlDateFormat = new SimpleDateFormat(this.getXmlDateFormat());
        Date startDate = this.truncateTime(this.getFirstDate());
        String conditionFormat = " (xpath('%s/text()',mdm.document))[1]::text::timestamp without time zone >= '%s'";
        return String.format(conditionFormat, this.getXpath(), xmlDateFormat.format(startDate));
    }

    @Override
    protected String lessThan() {
        SimpleDateFormat xmlDateFormat = new SimpleDateFormat(this.getXmlDateFormat());
        Date startDate = this.truncateTime(this.getFirstDate());
        String conditionFormat = " (xpath('%s/text()',mdm.document))[1]::text::timestamp without time zone < '%s'";
        return String.format(conditionFormat, this.getXpath(), xmlDateFormat.format(startDate));
    }

    @Override
    protected String lessThanEqual() {
        SimpleDateFormat xmlDateFormat = new SimpleDateFormat(this.getXmlDateFormat());
        Date startDate = this.addDays(this.truncateTime(this.getFirstDate()), 1);
        String conditionFormat = " (xpath('%s/text()',mdm.document))[1]::text::timestamp without time zone < '%s'";
        return String.format(conditionFormat, this.getXpath(), xmlDateFormat.format(startDate));
    }

    @Override
    protected String notEqual() {
        SimpleDateFormat xmlDateFormat = new SimpleDateFormat(this.getXmlDateFormat());
        Date startDate = this.truncateTime(this.getFirstDate());
        Date endDate = this.addDays(startDate, 1);
        String conditionFormat = " (xpath('%s/text()',mdm.document))[1]::text::timestamp without time zone < '%s' and (xpath('%s/text()',mdm.document))[1]::text::timestamp without time zone > '%s'";
        return String.format(conditionFormat, this.getXpath(), xmlDateFormat.format(startDate), this.getXpath(), xmlDateFormat.format(endDate));
    }

    @Override
    protected String lessThanToday() {
        SimpleDateFormat xmlDateFormat = new SimpleDateFormat(this.getXmlDateFormat());
        Date startDate = this.truncateTime(this.getRelativeDate());
        String conditionFormat = " (xpath('%s/text()',mdm.document))[1]::text::timestamp without time zone < '%s'";
        return String.format(conditionFormat, this.getXpath(), xmlDateFormat.format(startDate));
    }

    @Override
    protected String notEqualToToday() {
        SimpleDateFormat xmlDateFormat = new SimpleDateFormat(this.getXmlDateFormat());
        Date startDate = this.truncateTime(this.getRelativeDate());
        Date endDate = this.addDays(startDate, 1);
        String conditionFormat = " (xpath('%s/text()',mdm.document))[1]::text::timestamp without time zone < '%s' and (xpath('%s/text()',mdm.document))[1]::text::timestamp without time zone > '%s'";
        return String.format(conditionFormat, this.getXpath(), xmlDateFormat.format(startDate), this.getXpath(), xmlDateFormat.format(endDate));
    }

    @Override
    protected String notLessThanToday() {
        SimpleDateFormat xmlDateFormat = new SimpleDateFormat(this.getXmlDateFormat());
        Date startDate = this.truncateTime(this.getRelativeDate());
        String conditionFormat = " (xpath('%s/text()',mdm.document))[1]::text::timestamp without time zone >= '%s'";
        return String.format(conditionFormat, this.getXpath(), xmlDateFormat.format(startDate));
    }

    @Override
    protected String greaterThanToday() {
        SimpleDateFormat xmlDateFormat = new SimpleDateFormat(this.getXmlDateFormat());
        Date startDate = this.addDays(this.truncateTime(this.getRelativeDate()), 1);
        String conditionFormat = " (xpath('%s/text()',mdm.document))[1]::text::timestamp without time zone >= '%s'";
        return String.format(conditionFormat, this.getXpath(), xmlDateFormat.format(startDate));
    }

    @Override
    protected String notGreaterThanToday() {
        SimpleDateFormat xmlDateFormat = new SimpleDateFormat(this.getXmlDateFormat());
        Date startDate = this.truncateTime(this.getRelativeDate());
        String conditionFormat = " (xpath('%s/text()',mdm.document))[1]::text::timestamp without time zone <= '%s'";
        return String.format(conditionFormat, this.getXpath(), xmlDateFormat.format(startDate));
    }

    @Override
    protected String between() {
        SimpleDateFormat xmlDateFormat = new SimpleDateFormat(this.getXmlDateFormat());
        Date startDate = this.truncateTime(this.getFirstDate());
        PredicateRightValue prv = (PredicateRightValue)this.predicate;
        Date endDate = this.parseDate((String)prv.getValue().get(1));
        endDate = this.truncateTime(endDate);
        endDate = this.addDays(endDate, 1);
        String conditionFormat = " (xpath('%s/text()',mdm.document))[1]::text::timestamp without time zone >= '%s' and (xpath('%s/text()',mdm.document))[1]::text::timestamp without time zone < '%s'";
        return String.format(conditionFormat, this.getXpath(), xmlDateFormat.format(startDate), this.getXpath(), xmlDateFormat.format(endDate));
    }

    private String getXpath() {
        String xpathTail = this.getXpathTail();
        String xpathMinusTail = this.isCustomField() ? this.getCustomFieldXpath() : this.getXpathMinusTail();
        return xpathMinusTail + "/" + xpathTail;
    }
}

