/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.specimpl;

import com.tandbergtv.metadatamanager.exception.TranslationException;
import com.tandbergtv.metadatamanager.spec.ITranslator;
import com.tandbergtv.metadatamanager.util.ResourceResolver;
import com.tandbergtv.metadatamanager.util.XmlUtil;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class XslTranslator
implements ITranslator {
    private final Logger logger = Logger.getLogger(this.getClass());
    @Deprecated
    private TransformerFactory tf;
    @Deprecated
    private InputStream xslStream;
    @Deprecated
    private ClassLoader classLoader;
    @Deprecated
    private Transformer transformer = null;
    private TransformerThreadLocal transformerLocal;

    @Deprecated
    public XslTranslator() {
    }

    public XslTranslator(ClassLoader classLoader, String xslPath) {
        this.transformerLocal = new TransformerThreadLocal(xslPath, classLoader);
    }

    @Override
    @Deprecated
    public void setXslStream(InputStream xslStream) {
        this.xslStream = xslStream;
        try {
            if (this.tf == null) {
                this.tf = XmlUtil.createTransformerFactory(this.classLoader);
                this.tf.setURIResolver(new ResourceResolver(this.classLoader));
            }
            this.transformer = this.tf.newTransformer(new StreamSource(this.xslStream));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Document translate(Document doc) throws TranslationException {
        this.logger.debug((Object)"In Translate");
        DocumentBuilder dBuilder = null;
        Transformer t = null;
        try {
            dBuilder = XmlUtil.borrowDocumentBuilder();
            Document docOut = dBuilder.newDocument();
            DOMResult result = new DOMResult(docOut);
            t = this.transformer == null ? (Transformer)this.transformerLocal.get() : this.transformer;
            t.transform(new DOMSource(doc), result);
            Document document = docOut;
            return document;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Deprecated
    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    private static class TransformerThreadLocal
    extends ThreadLocal<Transformer> {
        private String xslPath;
        private ClassLoader classLoader;

        public TransformerThreadLocal(String xslPath, ClassLoader classLoader) {
            this.xslPath = xslPath;
            this.classLoader = classLoader;
        }

        @Override
        protected Transformer initialValue() {
            Transformer t;
            if (this.classLoader == null) {
                throw new RuntimeException("Failed to create Transformer, classloader not set");
            }
            if (this.xslPath == null) {
                throw new RuntimeException("Failed to create Transformer, xslPath not defined");
            }
            try {
                TransformerFactory tf = XmlUtil.createTransformerFactory(this.classLoader);
                tf.setURIResolver(new ResourceResolver(this.classLoader));
                InputStream xslStream = this.classLoader.getResourceAsStream(this.xslPath);
                t = tf.newTransformer(new StreamSource(xslStream));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return t;
        }
    }
}

