/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.util;

import com.tandbergtv.metadatamanager.util.DateParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.w3c.util.DateParser;
import org.w3c.util.InvalidDateException;

public class DateUtil {
    public static Date convertDate(String date) throws DateParseException {
        if (date == null || "".equals(date)) {
            return null;
        }
        Date d = DateUtil.parseDateWithTimeZone(date);
        if (d != null) {
            return d;
        }
        d = DateUtil.parseDate("yyyy-MM-dd'T'HH:mm:ss", date);
        if (d != null) {
            return d;
        }
        d = DateUtil.parseDate("yyyy-MM-dd'T'HH:mm", date);
        if (d != null) {
            return d;
        }
        d = DateUtil.parseDate("yyyy-MM-dd", date);
        if (d != null) {
            return d;
        }
        d = DateUtil.parseDate("yyyy-MM-dd'T'HH:mm:ss.SSS", date);
        if (d != null) {
            return d;
        }
        throw new DateParseException("The string " + date + " can't be parsed to a date");
    }

    public static Date convertTime(String time) throws DateParseException {
        if (time == null || "".equals(time)) {
            return null;
        }
        return DateUtil.parseDate("HH:mm:ss.SSS", time);
    }

    private static Date parseDateWithTimeZone(String date) {
        int indexOfT;
        String time;
        if (date.contains("T") && ((time = date.substring(indexOfT = date.indexOf(84))).contains("Z") || time.contains("+") || time.contains("-"))) {
            Date d1 = null;
            try {
                d1 = DateParser.parse(date);
            }
            catch (InvalidDateException e) {
                return null;
            }
            return d1;
        }
        return null;
    }

    private static Date parseDate(String format, String date) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        ParsePosition pp = new ParsePosition(0);
        Date result = sdf.parse(date, pp);
        if (pp.getIndex() < date.length() - 1) {
            return null;
        }
        return result;
    }
}

