/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.validation.Schematron;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CustomSchematronBuilder {
    public static InputStream buildSchematron(Map<String, Boolean> rules) {
        HashMap<String, ArrayList<String>> sortedRules = new HashMap<String, ArrayList<String>>();
        for (Map.Entry<String, Boolean> rule : rules.entrySet()) {
            if (!rule.getValue().booleanValue()) continue;
            String xpath = rule.getKey();
            String string = CustomSchematronBuilder.getField(xpath);
            String context = CustomSchematronBuilder.getContext(xpath);
            ArrayList<String> bucket = (ArrayList<String>)sortedRules.get(context);
            if (bucket == null) {
                bucket = new ArrayList<String>();
            }
            bucket.add(string);
            sortedRules.put(context, bucket);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?><iso:schema xmlns=\"http://purl.oclc.org/dsdl/schematron\" xmlns:iso=\"http://purl.oclc.org/dsdl/schematron\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:ext=\"http://www.schematron.com/namespace/extensionsAndExperiments\" queryBinding='xslt2' schemaVersion='ISO19757-3'><iso:title>Custom Vaildations</iso:title><iso:pattern>");
        Set set = sortedRules.entrySet();
        for (Map.Entry entry : set) {
            sb.append("<iso:rule context=\"" + (String)entry.getKey() + "\">");
            for (String fieldName : (List)entry.getValue()) {
                sb.append("<iso:report test=\"not(" + fieldName + ")\">ERR-02 : " + fieldName.replace("@", "") + "</iso:report>");
            }
            sb.append("</iso:rule>");
        }
        sb.append("</iso:pattern></iso:schema>");
        byte[] bytes = null;
        try {
            bytes = sb.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return new ByteArrayInputStream(bytes);
    }

    private static String getContext(String xpath) {
        int lastSlash = xpath.lastIndexOf("/");
        return xpath.substring(0, lastSlash);
    }

    private static String getField(String xpath) {
        int lastSlash = xpath.lastIndexOf("/");
        int end = xpath.length();
        return xpath.substring(lastSlash + 1, end);
    }
}

