/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.utils.title;

import com.ericsson.cms.search.ElasticSearchService;
import com.ericsson.cms.search.IElasticSearchService;
import com.ericsson.utils.title.SaveTitleIdsWork;
import com.tandbergtv.metadatamanager.ITTVDataModelHandler;
import com.tandbergtv.metadatamanager.customfield.persistence.CustomFieldPersistenceService;
import com.tandbergtv.metadatamanager.customfield.persistence.ICustomFieldPersistenceService;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import com.tandbergtv.watchpoint.pmm.core.TitlePersistenceException;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.ApplicationContextHelper;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.DefaultTitlePersistenceService;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.ITitlePersistenceService;
import com.tandbergtv.watchpoint.pmm.title.TitleManager;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.Serializable;
import java.util.Date;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.jdbc.Work;
import org.springframework.context.ApplicationContext;

public class PersistenceUtil {
    private PersistenceUtil() {
    }

    private static void addService(Service service) {
        ServiceRegistry.getDefault().register(service.getServiceName(), service);
        service.start();
    }

    public static void closeContext() {
        PersistenceUtil.stopService(IElasticSearchService.class);
        PersistenceUtil.stopService(ITitleManager.class);
        PersistenceUtil.stopService(ITitlePersistenceService.class);
    }

    private static void stopService(Class claz) {
        try {
            Service service = (Service)ServiceRegistry.getDefault().lookup(claz);
            if (service != null) {
                service.stop();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeContext(String[] configFiles) {
        ApplicationContextHelper helper = new ApplicationContextHelper(configFiles);
        ApplicationContext context = helper.getContext();
        ITTVDataModelHandler assetDataModelHandler = (ITTVDataModelHandler)context.getBean("TTVSpecHandler");
        PersistenceUtil.addService((Service)new DefaultTitlePersistenceService(assetDataModelHandler));
        ElasticSearchService esService = new ElasticSearchService();
        esService.setCacheAssetsRequiringFiles(true);
        PersistenceUtil.addService((Service)esService);
        PersistenceUtil.addService((Service)new TitleManager());
        HibernateContext.getContext().initializeContext();
        Session session = HibernateContext.getContext().getCurrentSession();
        Transaction trans = session.beginTransaction();
        try {
            DataTypeMappingReader dt = DataTypeMappingReader.getInstance();
            ICustomFieldPersistenceService cfs = CustomFieldPersistenceService.getInstance((ApplicationContext)context);
            dt.refreshCustomFieldDataTypeMap(cfs.getAllGroups());
        }
        finally {
            trans.commit();
        }
    }

    public static void saveTitleIds(int numShards, int batchSize, Date fromDate) {
        Session session = HibernateContext.getContext().getCurrentSession();
        Transaction trans = session.beginTransaction();
        session.doWork((Work)new SaveTitleIdsWork(numShards, batchSize, fromDate));
        trans.commit();
    }

    public static Title getTitleFromDB(long titleId) {
        try {
            ITitlePersistenceService titleService = (ITitlePersistenceService)ServiceRegistry.getDefault().lookup(ITitlePersistenceService.class);
            Title title = titleService.get((Serializable)Long.valueOf(titleId));
            return title;
        }
        catch (TitlePersistenceException ex) {
            System.out.println("Skipping title " + titleId);
            ex.printStackTrace();
            return null;
        }
    }

    public static boolean saveTitleInElasticSearch(Title title) throws Exception {
        IElasticSearchService esService = (IElasticSearchService)ServiceRegistry.getDefault().lookup(IElasticSearchService.class);
        boolean status = esService.saveTitle(title);
        return status;
    }

    public static boolean removeTitleInElasticSearch(Title title) throws Exception {
        IElasticSearchService esService = (IElasticSearchService)ServiceRegistry.getDefault().lookup(IElasticSearchService.class);
        boolean status = esService.deleteTitle(title);
        return status;
    }
}

