/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.utils.title;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ProcessUtil {
    public static List<ProcInfo> getProcessList(String name) {
        ArrayList<ProcInfo> processes = new ArrayList<ProcInfo>();
        try {
            String line;
            String[] cmd = new String[]{"/bin/sh", "-c", "ps -eo pid,cmd | grep " + name + " | grep -v grep"};
            Process p = Runtime.getRuntime().exec(cmd);
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                ProcInfo info = new ProcInfo();
                int idx = line.indexOf(" java");
                if (idx <= 0) {
                    System.out.println("Could not extract process ID. " + line);
                    continue;
                }
                String strProcId = line.substring(0, idx).trim();
                info.procId = Integer.parseInt(strProcId);
                idx = line.lastIndexOf(32);
                info.idFileName = line.substring(idx + 1).trim();
                processes.add(info);
            }
            input.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Collections.sort(processes);
        return processes;
    }

    public static List<ProcInfo> getWorkflowProcess() {
        ArrayList<ProcInfo> list = new ArrayList<ProcInfo>();
        try {
            String line;
            String[] cmd = new String[]{"/bin/sh", "-c", "ps -eo pid,cmd | grep com.tandbergtv.workflow.driver.search.elasticsearch.util.sync.WoRdbmsToEsSynchronizer | grep -v grep"};
            Process p = Runtime.getRuntime().exec(cmd);
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                ProcInfo info = new ProcInfo();
                int idx = line.indexOf(" java");
                if (idx > 0) {
                    String strProcId = line.substring(0, idx).trim();
                    info.procId = Integer.parseInt(strProcId);
                    info.idFileName = "work/workflowBookmark.txt";
                    list.add(info);
                    break;
                }
                System.out.println("Could not extract process ID. " + line);
            }
            input.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return list;
    }

    public static void printProcessList(List<ProcInfo> list) {
        System.out.println("===========================================");
        System.out.println("     PID          File Name");
        System.out.println("===========================================");
        for (ProcInfo info : list) {
            System.out.format("%9d     %s\n", info.procId, info.idFileName);
        }
        System.out.println("===========================================");
    }

    public static void killProcesses(List<ProcInfo> list) {
        for (ProcInfo info : list) {
            ProcessUtil.kill(info.procId);
        }
    }

    public static boolean kill(int procId) {
        try {
            String line;
            Process p = Runtime.getRuntime().exec("kill " + procId);
            BufferedReader err = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while ((line = err.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    public static class ProcInfo
    implements Comparable<ProcInfo> {
        public int procId;
        public String idFileName;

        @Override
        public int compareTo(ProcInfo o) {
            return this.procId - o.procId;
        }
    }
}

