/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.utils.title;

import com.ericsson.utils.title.ResyncManagerMain;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Properties;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.transport.TransportClient;

public class PropertiesUtil {
    public static SimpleDateFormat colonDF = new SimpleDateFormat("yyyy-MM-dd:HH:mm:ss");
    public static SimpleDateFormat spaceDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readProperties() {
        InputStream is = ResyncManagerMain.class.getClassLoader().getResourceAsStream("sync.properties");
        if (is == null) {
            System.out.println("Could not load 'sync.properties' from classpath.");
            return null;
        }
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (Exception ex) {
            System.out.println("Could not load 'sync.properties' from classpath. " + ex.getMessage());
            Properties properties = null;
            return properties;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
        return props;
    }

    public static boolean isCurrentHost() {
        Properties timeProps;
        String hostname = "";
        try {
            timeProps = PropertiesUtil.readTimeProperties();
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            return true;
        }
        if (timeProps == null) {
            return true;
        }
        String currentHost = timeProps.getProperty("currentHost");
        return currentHost == null || currentHost.equals(hostname);
    }

    public static boolean isCleaning() {
        Properties timeProps;
        try {
            timeProps = PropertiesUtil.readTimeProperties();
        }
        catch (Exception e) {
            return false;
        }
        if (timeProps == null) {
            return false;
        }
        String isCleaning = timeProps.getProperty("isCleaning");
        return isCleaning != null && !isCleaning.isEmpty();
    }

    public static Properties readTimeProperties() throws Exception {
        Properties props;
        InputStream is = ResyncManagerMain.class.getClassLoader().getResourceAsStream("timestamp.properties");
        for (int count = 0; is == null && count < 3; ++count) {
            props = new Properties();
            System.out.println("Could not load 'timestamp.properties' from classpath.");
            props.setProperty("lastSuccessfulRun", "2000-01-01:00:00:00");
            props.setProperty("lastDBReplication", "2000-01-01:00:00:00");
            PropertiesUtil.saveTimeProperties(props);
            is = ResyncManagerMain.class.getClassLoader().getResourceAsStream("timestamp.properties");
        }
        try {
            props = new Properties();
            props.load(is);
        }
        catch (Exception ex) {
            System.out.println("Could not load 'timestamp.properties' from classpath. " + ex.getMessage());
            throw ex;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
        return props;
    }

    public static void updateTimeProperties(TransportClient client) throws Exception {
        Properties props = PropertiesUtil.readTimeProperties();
        if (props != null) {
            String newRep = props.getProperty("newDBReplication");
            String currentRun = props.getProperty("currentRuntime");
            if (newRep != null) {
                props.setProperty("lastSuccessfulRun", newRep);
                props.setProperty("lastDBReplication", newRep);
                try {
                    PropertiesUtil.publishReplicationTimeToES(client, spaceDF.format(colonDF.parse(newRep.replaceAll("\\\\", ""))));
                }
                catch (Exception e) {
                    System.out.println("ERROR: Failed to publish replication time to ES: " + e.getMessage());
                    return;
                }
            } else if (currentRun != null) {
                props.setProperty("lastSuccessfulRun", currentRun);
            }
            props.remove("currentHost");
            props.remove("currentRuntime");
            props.remove("newDBReplication");
            props.remove("workflowRuntime");
            PropertiesUtil.saveTimeProperties(props);
        }
    }

    public static void resetTimeProperties() throws Exception {
        Properties props = PropertiesUtil.readTimeProperties();
        if (props != null) {
            String lastRun = props.getProperty("lastSuccessfulRun");
            String lastRep = props.getProperty("lastDBReplication");
            props = new Properties();
            if (lastRun == null) {
                props.setProperty("lastSuccessfulRun", "2000-01-01:00:00:00");
            } else {
                props.setProperty("lastSuccessfulRun", lastRun);
            }
            if (lastRep == null) {
                props.setProperty("lastDBReplication", "2000-01-01:00:00:00");
            } else {
                props.setProperty("lastDBReplication", lastRep);
            }
            PropertiesUtil.saveTimeProperties(props);
        }
    }

    public static void saveTimeProperties(Properties props) throws Exception {
        String propFile = "/opt/tandbergtv/cms/scripts/sync_utils/conf/timestamp.properties";
        File file = new File(propFile);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                System.out.println("Could not create 'timestamp.properties'.");
                return;
            }
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            props.store(writer, null);
        }
        catch (Exception ex) {
            System.out.println("ERROR: Could not write Elasticsearch properties file (" + propFile + "). " + ex.getMessage());
            throw ex;
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    private static void publishReplicationTimeToES(TransportClient client, String newRep) throws Exception {
        System.out.println("Publishing replication time to ES: lastsyncindex");
        IndexResponse response = (IndexResponse)client.prepareIndex("lastsyncindex", "_doc", "1").setSource(new Object[]{"lastSyncDate", newRep}).execute().actionGet();
        if (response == null || !response.getId().equals("1")) {
            throw new Exception("ERROR: ES did not write lastsyncindex.");
        }
    }
}

