/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.utils.title;

import com.ericsson.neptune.es.CmsTransportClient;
import com.ericsson.utils.title.ProcessUtil;
import com.ericsson.utils.title.PropertiesUtil;
import com.ericsson.utils.title.ResyncElasticSearchTitlesApp;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.elasticsearch.client.transport.TransportClient;

public class ResyncManagerMain {
    private static final int TIMEOUT_MIN = 5;
    private static final int QUERY_SEC = 20;
    static CommandLine cl;
    static String database;
    static String databasePort;
    static CmsTransportClient esClient;

    public static void main(String[] args) throws Exception {
        System.out.print("Running ResyncManagerMain ");
        for (int i = 0; i < args.length; ++i) {
            System.out.println(" <" + args[i] + ">");
        }
        BasicParser parser = new BasicParser();
        try {
            cl = parser.parse(ResyncManagerMain.getOptions(), args);
        }
        catch (ParseException e) {
            ResyncManagerMain.printUsageAndExit();
        }
        if (args.length == 0 || cl.hasOption("h")) {
            ResyncManagerMain.printUsageAndExit();
        }
        ResyncManagerMain.checkOS();
        ResyncManagerMain.checkParameter(cl);
        String cmd = args[0];
        if (cmd.equalsIgnoreCase("status")) {
            ResyncManagerMain.doStatus(args);
        } else if (cmd.equalsIgnoreCase("stop")) {
            ResyncManagerMain.doStop();
        } else if (cmd.equalsIgnoreCase("start")) {
            ResyncManagerMain.doStart(args);
        } else if (cmd.equalsIgnoreCase("clean")) {
            ResyncManagerMain.doClean(args);
        } else {
            System.out.println("Invalid command: " + cmd);
            System.out.println();
            ResyncManagerMain.printUsageAndExit();
        }
        if (esClient != null) {
            esClient.close();
        }
        System.exit(0);
    }

    private static void checkParameter(CommandLine commandLine) {
        if ((commandLine.hasOption("w") || commandLine.hasOption("a")) && !commandLine.hasOption("db")) {
            System.out.println("db is required when sync workflow");
            ResyncManagerMain.printUsageAndExit();
        }
    }

    private static Options getOptions() {
        Options options = new Options();
        options.addOption("a", "all", false, "Resyncs all titles and all work orders.");
        options.addOption("s", "starttime", true, "All entries that were updated later than starttime are selected for synchronization. Expected format is yyyy-MM-dd HH:mm:ss.");
        options.addOption("t", "titles", false, "Sync titles only.");
        options.addOption("w", "workflow", false, "Sync workflow only.");
        options.addOption("c", "concurrency", true, "Sets the number of parallel threads or writing to ElasticSearch. Defaults to 5.");
        options.addOption("q", "queuelimit", true, "Sets the internal queue size and intern the SQL query batch size. Defaults to 100.");
        options.addOption("p", "variableprocesslimit", true, "Max number of processids to use in variable isntance query, defaults to 50");
        options.addOption("v", "variableconcurrency", true, "Sets the number of parallel connections to DB while gathering VARIABLE INSTANCE information. Defaults to 20.");
        options.addOption("g", "geo", false, "Only use when running on georedundant site. Keeps ElasticSearch in sync with last database streaming.");
        options.addOption("db", "database", true, "Explicitly specify database.");
        options.addOption("dp", "databaseport", true, "Explicitly specify database port. Default value is 5432");
        options.addOption("h", "help", false, "Show help.");
        return options;
    }

    private static synchronized TransportClient getTransportClient() {
        if (esClient == null) {
            esClient = new CmsTransportClient("/opt/tandbergtv/cms/conf/contentMgmt/ElasticSearch.properties");
        }
        return esClient.getTransportClient();
    }

    private static void doStatus(String[] args) throws Exception {
        ResyncStatus status = ResyncManagerMain.checkResyncStatus();
        if (status == null) {
            System.out.println("Something went wrong.");
        }
        switch (status) {
            case NOTCURRENTHOST: {
                System.out.println("Resync is probably running on the other host.");
                break;
            }
            case STOPPED: {
                System.out.println("Resync is stopped. Please run START to resume.");
                break;
            }
            case RUNNING: {
                System.out.println("Resync is running.");
                ResyncManagerMain.printProcessesList();
                break;
            }
            case DONE: {
                System.out.println("Resync has completed successfully! Please run CLEAN.");
                break;
            }
            case READY: {
                System.out.println("Resync is ready to run.");
                break;
            }
            case CLEANING: {
                System.out.println("Resync is cleaning.");
                break;
            }
            default: {
                System.out.println("Resync Status Error!");
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void doStart(String[] args) throws Exception {
        isGeoredundantSite = false;
        modifiedSince = null;
        concurrency = -1;
        queueLimit = -1;
        variableProcessLimit = -1;
        variableConcurrency = -1;
        hostname = "";
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        if (ResyncManagerMain.cl.hasOption("db")) {
            db = ResyncManagerMain.cl.getOptionValue("db");
            if (!db.equals("dbserver") && !db.startsWith("edb")) {
                System.out.println("Invalid database! Must be \"dbserver\" or \"edb#\": \"" + db + "\"");
                return;
            }
            ResyncManagerMain.database = db;
        }
        if (ResyncManagerMain.cl.hasOption("dp")) {
            ResyncManagerMain.databasePort = ResyncManagerMain.cl.getOptionValue("dp");
        }
        if (ResyncManagerMain.cl.hasOption("g")) {
            System.out.println("GEOREDUNDANCY = TRUE");
            isGeoredundantSite = true;
        }
        if ((status = ResyncManagerMain.checkResyncStatus()) == null) {
            System.out.println("Something went wrong.");
        }
        i = 0;
        block16: while (true) lbl-1000:
        // 5 sources

        {
            switch (7.$SwitchMap$com$ericsson$utils$title$ResyncManagerMain$ResyncStatus[status.ordinal()]) {
                case 4: {
                    if (!isGeoredundantSite) ** GOTO lbl53
                    currentRuntime = null;
                    timeProps = PropertiesUtil.readTimeProperties();
                    if (timeProps == null) {
                        timeProps = new Properties();
                    } else {
                        currentRun = timeProps.getProperty("currentRuntime");
                        if (currentRun != null) {
                            try {
                                currentRuntime = PropertiesUtil.colonDF.parse(currentRun.replaceAll("\\\\", ""));
                            }
                            catch (java.text.ParseException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    if (currentRuntime != null && new Date().getTime() - currentRuntime.getTime() < 300000L) ** GOTO lbl51
                    PropertiesUtil.updateTimeProperties(ResyncManagerMain.getTransportClient());
                    ResyncManagerMain.clean();
                    status = ResyncManagerMain.checkResyncStatus();
                    if (++i <= 3) ** GOTO lbl-1000
                    System.out.println("Problem switching currentHost! Check timestamp.properties");
                    return;
lbl51:
                    // 1 sources

                    ResyncManagerMain.doStop();
                    return;
lbl53:
                    // 1 sources

                    System.out.println("Previous resync had completed successfully! Running CLEAN.");
                    PropertiesUtil.updateTimeProperties(ResyncManagerMain.getTransportClient());
                    ResyncManagerMain.clean();
                    status = ResyncManagerMain.checkResyncStatus();
                    if (++i <= 3) ** GOTO lbl-1000
                    System.out.println("Couldn't clean properly! Check file permissions.");
                    return;
                }
                case 5: {
                    System.out.println("Resync utility is ready.");
                    break block16;
                }
                case 3: {
                    System.out.println("Resync utility is running.");
                    ResyncManagerMain.printProcessesList();
                    return;
                }
                case 1: {
                    System.out.println("Resync is probably running on the other host.");
                    if (!isGeoredundantSite) break block16;
                    currentRuntime = null;
                    timeProps = PropertiesUtil.readTimeProperties();
                    if (timeProps == null) {
                        timeProps = new Properties();
                    } else {
                        currentRun = timeProps.getProperty("currentRuntime");
                        if (currentRun != null) {
                            try {
                                currentRuntime = PropertiesUtil.colonDF.parse(currentRun.replaceAll("\\\\", ""));
                            }
                            catch (java.text.ParseException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    if (currentRuntime != null && new Date().getTime() - currentRuntime.getTime() < 300000L) ** GOTO lbl92
                    System.out.println("Switching running host to this.");
                    timeProps.setProperty("currentHost", hostname);
                    PropertiesUtil.saveTimeProperties(timeProps);
                    status = ResyncManagerMain.checkResyncStatus();
                    if (++i <= 3) ** GOTO lbl-1000
                    System.out.println("Problem switching currentHost! Check timestamp.properties");
                    return;
lbl92:
                    // 1 sources

                    ResyncManagerMain.doStop();
                    return;
                }
                case 2: {
                    System.out.println("Last resync was incomplete.");
                    timeProps = PropertiesUtil.readTimeProperties();
                    if (timeProps == null) {
                        timeProps = new Properties();
                    }
                    System.out.println("Setting currentRuntime: " + PropertiesUtil.spaceDF.format(new Date()));
                    timeProps.setProperty("currentRuntime", PropertiesUtil.colonDF.format(new Date()));
                    PropertiesUtil.saveTimeProperties(timeProps);
                    if (ResyncManagerMain.checkTitlesResyncStatus() == ResyncStatus.STOPPED) {
                        System.out.println("Resuming titles resync.");
                        ResyncManagerMain.resumeTitlesResync();
                    }
                    if (ResyncManagerMain.checkWorkflowResyncStatus() == ResyncStatus.STOPPED) {
                        System.out.println("Resuming workflow resync.");
                        ResyncManagerMain.resumeWorkflowResync();
                    }
                    ResyncManagerMain.waitForCompletion(isGeoredundantSite);
                    return;
                }
                case 6: {
                    System.out.println("Currently cleaning...");
                    status = ResyncManagerMain.checkResyncStatus();
                    if (++i <= 3) continue block16;
                    System.out.println("Couldn't clean properly! Check file permissions.");
                    return;
                }
                default: {
                    System.out.println("Resync Status Error!");
                    return;
                }
            }
            break;
        }
        if (ResyncManagerMain.cl.hasOption("a")) {
            System.out.println("ALL = TRUE");
            System.out.println("Resyncing from: 1970-01-01:00:00:00");
            modifiedSince = ResyncManagerMain.determineModifiedSince(new Date(0L), false);
            timeProps = PropertiesUtil.readTimeProperties();
            if (timeProps == null) {
                timeProps = new Properties();
            }
            if (isGeoredundantSite) {
                System.out.println("Setting currentHost: " + hostname);
                timeProps.setProperty("currentHost", hostname);
            }
            if (modifiedSince != null) {
                System.out.println("Setting currentRuntime: " + PropertiesUtil.spaceDF.format(new Date()));
                timeProps.setProperty("currentRuntime", PropertiesUtil.colonDF.format(new Date()));
            }
            PropertiesUtil.saveTimeProperties(timeProps);
            System.out.println("Starting Titles Resync.");
            ResyncManagerMain.startTitlesResync(modifiedSince, false);
            System.out.println("Starting Workflow Resync.");
            ResyncManagerMain.startWorkflowResync(modifiedSince, concurrency, queueLimit, variableProcessLimit, variableConcurrency);
        } else {
            if (ResyncManagerMain.cl.hasOption("s")) {
                startTime = null;
                try {
                    startTime = PropertiesUtil.spaceDF.parse(ResyncManagerMain.cl.getOptionValue("s"));
                    System.out.println("STARTTIME = " + PropertiesUtil.spaceDF.format(startTime));
                }
                catch (java.text.ParseException e) {
                    epoch = Long.parseLong(ResyncManagerMain.cl.getOptionValue("s"));
                    if (epoch == null || epoch < 0L) {
                        System.out.println("Invalid date format (yyyy-MM-dd HH:mm:ss): " + ResyncManagerMain.cl.getOptionValue("s"));
                        System.exit(1);
                    }
                    startTime = new Date(epoch);
                    System.out.println("STARTTIME = " + PropertiesUtil.spaceDF.format(startTime));
                }
                modifiedSince = ResyncManagerMain.determineModifiedSince(startTime, isGeoredundantSite);
            } else {
                System.out.println("Resyncing from: 1970-01-01 00:00:00");
                modifiedSince = ResyncManagerMain.determineModifiedSince(new Date(0L), isGeoredundantSite);
            }
            if (modifiedSince != null) {
                timeProps = PropertiesUtil.readTimeProperties();
                if (timeProps == null) {
                    timeProps = new Properties();
                }
                if (isGeoredundantSite) {
                    System.out.println("Setting currentHost: " + hostname);
                    timeProps.setProperty("currentHost", hostname);
                }
                if (modifiedSince != null) {
                    System.out.println("MODIFIEDSINCE = " + PropertiesUtil.spaceDF.format(modifiedSince));
                    System.out.println("Setting currentRuntime: " + PropertiesUtil.spaceDF.format(new Date()));
                    timeProps.setProperty("currentRuntime", PropertiesUtil.colonDF.format(new Date()));
                    if (isGeoredundantSite) {
                        System.out.println("Setting newDBReplication: " + PropertiesUtil.spaceDF.format(new Date()));
                        timeProps.setProperty("newDBReplication", PropertiesUtil.colonDF.format(new Date()));
                    }
                }
                PropertiesUtil.saveTimeProperties(timeProps);
                if (ResyncManagerMain.cl.hasOption("t") || !ResyncManagerMain.cl.hasOption("w")) {
                    System.out.println("Starting Titles Resync.");
                    ResyncManagerMain.startTitlesResync(modifiedSince, isGeoredundantSite);
                }
                if (ResyncManagerMain.cl.hasOption("w") || !ResyncManagerMain.cl.hasOption("t")) {
                    if (ResyncManagerMain.cl.hasOption("c")) {
                        concurrency = Integer.parseInt(ResyncManagerMain.cl.getOptionValue("c"));
                    }
                    if (ResyncManagerMain.cl.hasOption("q")) {
                        queueLimit = Integer.parseInt(ResyncManagerMain.cl.getOptionValue("q"));
                    }
                    if (ResyncManagerMain.cl.hasOption("p")) {
                        variableProcessLimit = Integer.parseInt(ResyncManagerMain.cl.getOptionValue("p"));
                    }
                    if (ResyncManagerMain.cl.hasOption("v")) {
                        variableConcurrency = Integer.parseInt(ResyncManagerMain.cl.getOptionValue("v"));
                    }
                    System.out.println("Starting Workflow Resync.");
                    ResyncManagerMain.startWorkflowResync(modifiedSince, concurrency, queueLimit, variableProcessLimit, variableConcurrency);
                }
            }
        }
        ResyncManagerMain.waitForCompletion(isGeoredundantSite);
    }

    private static void waitForCompletion(boolean isGeoredundantSite) throws Exception {
        while (true) {
            System.out.println("\n\n--------------------------------------\n\n");
            System.out.println("Query time: " + PropertiesUtil.spaceDF.format(new Date()));
            ResyncStatus resyncStatus = ResyncManagerMain.checkResyncStatus();
            if (resyncStatus == ResyncStatus.DONE) {
                PropertiesUtil.updateTimeProperties(ResyncManagerMain.getTransportClient());
                break;
            }
            if (resyncStatus == ResyncStatus.READY) break;
            if (resyncStatus == ResyncStatus.STOPPED) {
                return;
            }
            if (resyncStatus == ResyncStatus.NOTCURRENTHOST) {
                ResyncManagerMain.doStop();
                return;
            }
            System.out.println("\n");
            ResyncManagerMain.printProcessesList();
            if (isGeoredundantSite) {
                Properties timeProps = PropertiesUtil.readTimeProperties();
                if (timeProps == null) {
                    timeProps = new Properties();
                }
                System.out.println("Setting currentRuntime: " + PropertiesUtil.spaceDF.format(new Date()));
                timeProps.setProperty("currentRuntime", PropertiesUtil.colonDF.format(new Date()));
                PropertiesUtil.saveTimeProperties(timeProps);
            }
            try {
                Thread.sleep(20000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                break;
            }
        }
        ResyncManagerMain.clean();
    }

    private static void doClean(String[] args) throws Exception {
        ResyncStatus status = ResyncManagerMain.checkResyncStatus();
        if (status == null) {
            System.out.println("Something went wrong.");
        }
        switch (status) {
            case STOPPED: {
                System.out.println("Previous resync was incomplete.");
                break;
            }
            case RUNNING: {
                System.out.println("Resync is running! Please run STOP before cleaning.");
                ResyncManagerMain.printProcessesList();
                return;
            }
            case NOTCURRENTHOST: {
                System.out.println("Resync utility is probably running on the other host.");
                break;
            }
            case DONE: {
                System.out.println("Resync has completed successfully!");
                PropertiesUtil.updateTimeProperties(ResyncManagerMain.getTransportClient());
                break;
            }
            case CLEANING: {
                System.out.println("Resync utility is currently cleaning.");
                return;
            }
            case READY: {
                System.out.println("Resync utility is ready.");
                break;
            }
            default: {
                System.out.println("Resync Status Error!");
            }
        }
        ResyncManagerMain.clean();
    }

    private static void doStop() {
        if (!ResyncManagerMain.getTitleResyncProcesses().isEmpty()) {
            System.out.println("Stopping titles resync...");
            ResyncManagerMain.killTitleProcesses();
            System.out.println("Titles resync stopped.");
        }
        if (!ResyncManagerMain.getWorkflowResyncProcesses().isEmpty()) {
            System.out.println("Stopping workflow resync...");
            ResyncManagerMain.killWorkflowProcesses();
            System.out.println("Workflow resync stopped.");
        }
    }

    private static boolean clean() throws Exception {
        boolean cleanStatus = false;
        if (!ResyncManagerMain.getTitleResyncProcesses().isEmpty()) {
            ResyncManagerMain.killTitleProcesses();
        }
        System.out.println("Cleaning...");
        Properties timeProps = PropertiesUtil.readTimeProperties();
        if (timeProps == null) {
            timeProps = new Properties();
        }
        System.out.println("Setting isCleaning: true");
        timeProps.setProperty("isCleaning", "true");
        PropertiesUtil.saveTimeProperties(timeProps);
        File workDir = new File("work");
        File logDir = new File("log");
        while (!cleanStatus) {
            File[] allLogFiles;
            File[] allWorkFiles;
            cleanStatus = true;
            for (File file : allWorkFiles = workDir.listFiles()) {
                System.out.println("Deleting " + file.getName() + "...");
                if (file.delete()) continue;
                System.out.println("Could not delete " + file.getName() + "!!!");
                cleanStatus = false;
            }
            for (File file : allLogFiles = logDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith("titleIds-") || name.startsWith("work");
                }
            })) {
                System.out.println("Deleting " + file.getName() + "...");
                if (file.delete()) continue;
                System.out.println("Could not delete " + file.getName() + "!!!");
                cleanStatus = false;
            }
            File[] allGeoLogFiles = logDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith("geo_sync_");
                }
            });
            Arrays.sort(allGeoLogFiles, new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    return Long.valueOf(f1.lastModified()).compareTo(f2.lastModified());
                }
            });
            for (int i = 0; i < allGeoLogFiles.length - 6; ++i) {
                System.out.println("Deleting " + allGeoLogFiles[i].getName() + "...");
                if (allGeoLogFiles[i].delete()) continue;
                System.out.println("Could not delete " + allGeoLogFiles[i].getName() + "!!!");
                cleanStatus = false;
            }
        }
        System.out.println("Done cleaning.");
        timeProps = PropertiesUtil.readTimeProperties();
        if (timeProps != null) {
            System.out.println("Removing isCleaning");
            timeProps.remove("isCleaning");
            PropertiesUtil.saveTimeProperties(timeProps);
        }
        return cleanStatus;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Date determineModifiedSince(Date newModifiedSince, boolean isGeoredundantSite) throws Exception {
        Date modifiedSince = null;
        if (newModifiedSince == null) {
            try {
                return ResyncManagerMain.getModifiedSinceDate(PropertiesUtil.readProperties());
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
                return null;
            }
        }
        Properties timeProps = PropertiesUtil.readTimeProperties();
        if (timeProps == null) {
            return null;
        }
        Date lastSuccessfulRun = ResyncManagerMain.parseDate(timeProps, "lastSuccessfulRun", "Last modification time", "timestamp.properties");
        if (lastSuccessfulRun == null) {
            System.out.println("No lastSuccessfulRun. Defaulting to: 1970-01-01 00:00:00");
            lastSuccessfulRun = new Date(0L);
        }
        if (isGeoredundantSite) {
            Date lastDBReplication = ResyncManagerMain.parseDate(timeProps, "lastDBReplication", "Last database replication time", "timestamp.properties");
            if (lastDBReplication == null) {
                System.out.println("No lastDBReplication. Defaulting to: 1970-01-01 00:00:00");
                lastDBReplication = new Date(0L);
            }
            if (newModifiedSince.after(lastDBReplication)) {
                System.out.println("Old replication date: " + PropertiesUtil.spaceDF.format(lastDBReplication));
                System.out.println("New replication date: " + PropertiesUtil.spaceDF.format(newModifiedSince));
                System.out.println("Last successful run: " + PropertiesUtil.spaceDF.format(lastSuccessfulRun));
                return lastDBReplication.after(lastSuccessfulRun) ? lastSuccessfulRun : lastDBReplication;
            }
            System.out.println("Old replication date: " + PropertiesUtil.spaceDF.format(lastDBReplication));
            System.out.println("New replication date: " + PropertiesUtil.spaceDF.format(newModifiedSince));
            System.out.println("No database replication since " + PropertiesUtil.spaceDF.format(lastDBReplication));
            System.out.println("Resync utility will not run.");
            return null;
        }
        System.out.println("Last successful run: " + PropertiesUtil.spaceDF.format(lastSuccessfulRun));
        System.out.println("New run: " + PropertiesUtil.spaceDF.format(newModifiedSince));
        return newModifiedSince.after(lastSuccessfulRun) ? lastSuccessfulRun : newModifiedSince;
    }

    private static void startTitlesResync(Date modifiedSince, boolean isSecondarySite) {
        if (!ResyncManagerMain.validateDatabase()) {
            System.out.println("Invalid Database Properties.");
            return;
        }
        int parallelBatches = ResyncManagerMain.getParallelBatches();
        int batchSize = ResyncManagerMain.getBatchSize();
        System.out.println("Generating title ID files...");
        if (modifiedSince != null) {
            System.out.println("Will only sync titles created or modified since: " + PropertiesUtil.spaceDF.format(modifiedSince));
        } else {
            System.out.println("Will resync ALL titles");
        }
        ResyncElasticSearchTitlesApp app = new ResyncElasticSearchTitlesApp(null, database, databasePort);
        app.saveTitleIds(parallelBatches, batchSize, modifiedSince);
        app.close();
        List<Integer> workFiles = ResyncManagerMain.getWorkFiles();
        System.out.println("Starting " + workFiles.size() + " Parallel batches...");
        for (int i = 0; i < workFiles.size(); ++i) {
            System.out.println("Working on work/titleIds-" + workFiles.get(i) + ".txt");
            ResyncManagerMain.startResyncProcess(workFiles.get(i));
        }
        System.out.println("Done.");
    }

    private static void resumeTitlesResync() {
        if (!ResyncManagerMain.validateDatabase()) {
            System.out.println("Invalid Database Properties.");
            return;
        }
        List<Integer> workFiles = ResyncManagerMain.getWorkFiles();
        System.out.println("Resuming resync...");
        System.out.println("Starting " + workFiles.size() + " Parallel batches...");
        for (int i = 0; i < workFiles.size(); ++i) {
            System.out.println("Working on work/titleIds-" + workFiles.get(i) + ".txt");
            ResyncManagerMain.startResyncProcess(workFiles.get(i));
        }
        System.out.println("Done.");
    }

    private static void startWorkflowResync(Date date, int concurrency, int queueLimit, int variableProcessLimit, int variableConcurrency) throws Exception {
        String workflowCommand = "./workflow_elasticsearch_sync.sh " + database + " -port " + databasePort;
        workflowCommand = workflowCommand + " -starttime \"" + PropertiesUtil.spaceDF.format(date) + "\"";
        if (concurrency > 0) {
            workflowCommand = workflowCommand + " -concurrency " + Integer.toString(concurrency);
        }
        if (queueLimit > 0) {
            workflowCommand = workflowCommand + " -queuelimit " + Integer.toString(queueLimit);
        }
        if (variableProcessLimit > 0) {
            workflowCommand = workflowCommand + " -variableprocesslimit " + Integer.toString(variableProcessLimit);
        }
        if (variableConcurrency > 0) {
            workflowCommand = workflowCommand + " -variableconcurrency " + Integer.toString(variableConcurrency);
        }
        System.out.println("Workflow command: " + workflowCommand);
        String[] cmd = new String[]{"/bin/bash", "-c", "cd /opt/tandbergtv/cms/scripts/sync_utils/bin; " + workflowCommand};
        try {
            Runtime.getRuntime().exec(cmd);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Error in executing workflow script!");
            return;
        }
        Properties timeProps = PropertiesUtil.readTimeProperties();
        if (timeProps == null) {
            timeProps = new Properties();
        }
        timeProps.setProperty("workflowRuntime", PropertiesUtil.spaceDF.format(date));
        PropertiesUtil.saveTimeProperties(timeProps);
        System.out.println("Workflow resync started running.");
    }

    private static void resumeWorkflowResync() throws Exception {
        Date date = ResyncManagerMain.getWorkflowRuntime();
        if (date == null) {
            System.out.println("Can't resume workflow! Property was deleted.");
            return;
        }
        String workflowCommand = "./workflow_elasticsearch_sync.sh " + database + " -port " + databasePort;
        workflowCommand = workflowCommand + " -starttime \"" + PropertiesUtil.spaceDF.format(date) + "\"";
        System.out.println("Workflow command: " + workflowCommand);
        String[] cmd = new String[]{"/bin/bash", "-c", "cd /opt/tandbergtv/cms/scripts/sync_utils/bin; " + workflowCommand};
        try {
            String line;
            Process p = Runtime.getRuntime().exec(cmd);
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                System.out.println(line);
                if (!line.contains("WFSElasticSearchService.start()")) continue;
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Error in executing workflow script!");
            return;
        }
        if (ProcessUtil.getProcessList("WoRdbmsToEsSynchronizer").size() == 0) {
            System.out.println("Workflow resync did not run!");
            return;
        }
        System.out.println("Workflow resync started running.");
    }

    private static boolean validateDatabase() {
        Properties syncProps = PropertiesUtil.readProperties();
        if (syncProps == null) {
            return false;
        }
        System.out.println("Database Properties:");
        if (!ResyncManagerMain.validateProperty(syncProps, "jdbc.driverClassName", "JDBC Driver", "sync.properties")) {
            return false;
        }
        if (!ResyncManagerMain.validateProperty(syncProps, "jdbc.username", "DB user name", "sync.properties")) {
            return false;
        }
        System.out.println();
        return true;
    }

    private static void killTitleProcesses() {
        ProcessUtil.killProcesses(ResyncManagerMain.getTitleResyncProcesses());
        ResyncManagerMain.sleep(1);
        List<ProcessUtil.ProcInfo> list = ResyncManagerMain.getTitleResyncProcesses();
        if (!list.isEmpty()) {
            System.out.println("Could not stop the following processes:");
            ProcessUtil.printProcessList(list);
        } else {
            System.out.println("Stopped.");
        }
    }

    private static void killWorkflowProcesses() {
        ProcessUtil.killProcesses(ResyncManagerMain.getWorkflowResyncProcesses());
        ResyncManagerMain.sleep(1);
        List<ProcessUtil.ProcInfo> list = ResyncManagerMain.getWorkflowResyncProcesses();
        if (!list.isEmpty()) {
            System.out.println("Could not stop the following processes:");
            ProcessUtil.printProcessList(list);
        } else {
            System.out.println("Stopped.");
        }
    }

    private static Date parseDate(Properties props, String name, String label, String propFileName) {
        ResyncManagerMain.validateProperty(props, name, label, propFileName, false);
        try {
            Date date = PropertiesUtil.colonDF.parse(props.getProperty(name));
            if (date == null) {
                throw new Exception();
            }
            return date;
        }
        catch (Exception e) {
            System.out.println("Date unparseable: " + props.getProperty(name));
            return null;
        }
    }

    private static boolean validateProperty(Properties props, String name, String label, String propFileName) {
        return ResyncManagerMain.validateProperty(props, name, label, propFileName, true);
    }

    private static boolean validateProperty(Properties props, String name, String label, String propFileName, boolean required) {
        String str = props.getProperty(name);
        if (str == null || str.trim().isEmpty()) {
            String msg = label + " is not set ('" + name + "' property in '" + propFileName + "' file).";
            if (required) {
                System.out.println("ERROR: " + msg);
                return false;
            }
            System.out.println("WARN: " + msg + " Will use default value.");
            return true;
        }
        System.out.println(label + ": " + str.replaceFirst(":", " "));
        return true;
    }

    private static boolean startResyncProcess(int num) {
        boolean success = true;
        try {
            String line;
            Process p = Runtime.getRuntime().exec("./bin/sync_title_ids.sh " + database + " " + databasePort + " " + num);
            BufferedReader err = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while ((line = err.readLine()) != null) {
                System.out.println(line);
                success = false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            success = false;
        }
        return success;
    }

    private static Date getModifiedSinceDate(Properties props) throws Exception {
        Date date = null;
        String str = props.getProperty("modifiedSince");
        if (str != null && !str.trim().isEmpty()) {
            date = PropertiesUtil.colonDF.parse(str);
            if (date == null) {
                date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(str);
            }
            if (date == null) {
                throw new Exception("Invalid date format: " + str);
            }
        }
        return date;
    }

    private static List<Integer> getWorkFiles() {
        File[] allFiles;
        ArrayList<Integer> workFiles = new ArrayList<Integer>();
        File dir = new File("work");
        if (!dir.exists() && !dir.mkdir()) {
            System.out.println("Error: Cannot make directory \"work\"");
            return workFiles;
        }
        if (!dir.isDirectory()) {
            System.out.println("Error: \"work\" is not a directory");
            return workFiles;
        }
        for (File f : allFiles = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("titleIds-") && name.endsWith(".txt");
            }
        })) {
            String name = f.getName();
            Integer workFile = Integer.parseInt(name.substring(name.indexOf("-") + 1, name.indexOf(".")));
            if (workFiles.contains(workFile)) continue;
            workFiles.add(workFile);
        }
        return workFiles;
    }

    private static int getParallelBatches() {
        int parallelBatches = 1;
        String str = PropertiesUtil.readProperties().getProperty("parallelBatches");
        if (str == null || str.trim().isEmpty()) {
            System.out.println("WARN: Number of parallel batches is not set ('parallelBatches' property in 'sync.properties' file). Will use 1.");
        } else {
            try {
                parallelBatches = Integer.parseInt(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (parallelBatches < 1) {
            parallelBatches = 1;
        } else if (parallelBatches > 10) {
            parallelBatches = 10;
        }
        System.out.println("Parallel Batches : " + parallelBatches);
        return parallelBatches;
    }

    private static int getBatchSize() {
        int batchSize = 100;
        String str = PropertiesUtil.readProperties().getProperty("batchSize");
        if (str == null || str.trim().isEmpty()) {
            System.out.println("WARN: Batch size is not set ('batchSize' property in 'sync.properties' file). Will use 1.");
        } else {
            try {
                batchSize = Integer.parseInt(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (batchSize < 1) {
            batchSize = 0;
        }
        System.out.println("Batch Size : " + batchSize);
        return batchSize;
    }

    private static void sleep(int seconds) {
        try {
            Thread.sleep(1000 * seconds);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void checkOS() {
        String osName = System.getProperty("os.name");
        if (osName == null || !osName.toLowerCase().contains("linux")) {
            System.out.println("Unsupported operating system: " + osName);
            System.out.println("Can only run on Linux");
            System.exit(1);
        }
    }

    private static void printUsageAndExit() {
        System.out.println("USAGE:");
        System.out.println("ResyncManagerMain <command> [<parameter 1, parameter 2, ..., parameter N] <options>");
        System.out.println("Commands:");
        System.out.println("  START");
        System.out.println("  STOP");
        System.out.println("  STATUS");
        System.out.println("  CLEAN");
        HelpFormatter help = new HelpFormatter();
        help.setSyntaxPrefix("");
        help.printHelp("Options:", ResyncManagerMain.getOptions());
        System.exit(1);
    }

    private static List<ProcessUtil.ProcInfo> getTitleResyncProcesses() {
        return ProcessUtil.getProcessList("com.ericsson.utils.title.ResyncElasticSearchTitlesMain");
    }

    private static List<ProcessUtil.ProcInfo> getWorkflowResyncProcesses() {
        return ProcessUtil.getWorkflowProcess();
    }

    private static ResyncStatus checkResyncStatus() throws Exception {
        if (PropertiesUtil.isCleaning()) {
            System.out.println("Resync Status: " + ResyncStatus.CLEANING.toString());
            System.out.println("Resync is currently cleaning.");
            return ResyncStatus.CLEANING;
        }
        if (!PropertiesUtil.isCurrentHost()) {
            System.out.println("Resync Status: " + ResyncStatus.NOTCURRENTHOST.toString());
            System.out.println("Resync is probably still running on other host.");
            return ResyncStatus.NOTCURRENTHOST;
        }
        ResyncStatus titleStatus = ResyncManagerMain.checkTitlesResyncStatus();
        ResyncStatus workflowStatus = ResyncManagerMain.checkWorkflowResyncStatus();
        if (titleStatus == null || workflowStatus == null) {
            System.out.println("Resync Status: Corrupted work files!");
            System.out.println("Resetting timestamp.properties.");
            PropertiesUtil.resetTimeProperties();
            ResyncManagerMain.clean();
            return ResyncManagerMain.checkResyncStatus();
        }
        System.out.println("Content Resync Status: " + ResyncManagerMain.checkTitlesResyncStatus().toString());
        System.out.println("Workflow Resync Status: " + ResyncManagerMain.checkWorkflowResyncStatus().toString());
        if (titleStatus == ResyncStatus.READY && workflowStatus == ResyncStatus.READY) {
            return titleStatus;
        }
        if (titleStatus == ResyncStatus.STOPPED || workflowStatus == ResyncStatus.STOPPED) {
            return ResyncStatus.STOPPED;
        }
        if (titleStatus == ResyncStatus.RUNNING || workflowStatus == ResyncStatus.RUNNING) {
            return ResyncStatus.RUNNING;
        }
        if (titleStatus == ResyncStatus.DONE || workflowStatus == ResyncStatus.DONE) {
            return ResyncStatus.DONE;
        }
        return null;
    }

    private static void printProcessesList() {
        ArrayList<ProcessUtil.ProcInfo> list = new ArrayList<ProcessUtil.ProcInfo>();
        list.addAll(ResyncManagerMain.getTitleResyncProcesses());
        list.addAll(ResyncManagerMain.getWorkflowResyncProcesses());
        ProcessUtil.printProcessList(list);
    }

    private static ResyncStatus checkTitlesResyncStatus() {
        File[] allTitleStatFiles;
        List<ProcessUtil.ProcInfo> titlesList = ResyncManagerMain.getTitleResyncProcesses();
        File dir = new File("work");
        if (!dir.exists() && !dir.mkdir()) {
            System.out.println("Error: Cannot make directory \"work\"");
            return null;
        }
        File dir2 = new File("log");
        if (!dir2.exists() && !dir2.mkdir()) {
            System.out.println("Error: Cannot make directory \"log\"");
            return null;
        }
        if (!dir.isDirectory()) {
            System.out.println("Error: \"work\" is not a directory");
            return null;
        }
        File[] allFiles = dir.listFiles();
        File[] allTitleWorkFiles = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("titleIds-") && name.endsWith(".txt");
            }
        });
        if (allTitleWorkFiles.length != (allTitleStatFiles = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".stat");
            }
        })).length) {
            System.out.println("Corrupted work files!!!");
            return null;
        }
        if (allFiles.length == 0) {
            return ResyncStatus.READY;
        }
        for (File file : allFiles) {
            if (!file.getName().contains(".stat")) continue;
            RandomAccessFile statusFile = null;
            String lastID = null;
            try {
                statusFile = new RandomAccessFile(file, "r");
                statusFile.seek(0L);
                lastID = statusFile.readUTF();
                statusFile.close();
            }
            catch (Exception e) {
                if (!titlesList.isEmpty()) {
                    return ResyncStatus.RUNNING;
                }
                return ResyncStatus.STOPPED;
            }
            if (lastID.contains("FINISH")) continue;
            if (!titlesList.isEmpty()) {
                return ResyncStatus.RUNNING;
            }
            return ResyncStatus.STOPPED;
        }
        return ResyncStatus.DONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResyncStatus checkWorkflowResyncStatus() {
        List<ProcessUtil.ProcInfo> workflowList = ResyncManagerMain.getWorkflowResyncProcesses();
        if (!workflowList.isEmpty()) {
            return ResyncStatus.RUNNING;
        }
        BufferedReader reader = null;
        FileInputStream fis = null;
        String bookMark = null;
        try {
            String line;
            File f = new File("/opt/tandbergtv/cms/scripts/sync_utils/work/workflowBookmark.txt");
            if (!f.exists()) {
                ResyncStatus resyncStatus = ResyncStatus.READY;
                return resyncStatus;
            }
            fis = new FileInputStream(f);
            reader = new BufferedReader(new InputStreamReader(fis));
            while ((line = reader.readLine()) != null) {
                if (line.trim().startsWith("#") || line.trim().split(":").length != 4) continue;
                bookMark = line;
                break;
            }
        }
        catch (Exception e) {
            System.out.println("Encountered exception during bookmark initialization: " + e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        if (bookMark != null && !bookMark.isEmpty()) {
            String[] arr = bookMark.split(":");
            if (arr != null && arr.length == 4) {
                if (!arr[1].equals("-1")) {
                    return ResyncStatus.STOPPED;
                }
                return ResyncStatus.DONE;
            }
        } else {
            return ResyncStatus.READY;
        }
        System.out.println("Error!");
        return null;
    }

    private static Date getWorkflowRuntime() throws Exception {
        Properties props = PropertiesUtil.readTimeProperties();
        if (props != null && props.containsKey("workflowRuntime")) {
            String runtime = props.getProperty("workflowRuntime");
            try {
                return PropertiesUtil.spaceDF.parse(runtime);
            }
            catch (java.text.ParseException e) {
                System.out.println("Wrong format (yyyy-mm-dd HH:mm:ss): " + runtime);
                return null;
            }
        }
        return null;
    }

    static {
        databasePort = "5432";
    }

    private static enum ResyncStatus {
        READY,
        RUNNING,
        STOPPED,
        NOTCURRENTHOST,
        DONE,
        CLEANING;

    }
}

